/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hudi.common.util.collection.FilterIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFilterIterator {
    @Test
    public void testFilter() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5);
        Predicate<Integer> filter = i -> i % 2 != 0;
        FilterIterator filterIterator = new FilterIterator(list.iterator(), filter);
        ArrayList<Object> filteredList = new ArrayList<Object>();
        while (filterIterator.hasNext()) {
            filteredList.add(filterIterator.next());
        }
        Assertions.assertEquals(Arrays.asList(1, 3, 5), filteredList);
    }

    @Test
    public void testFilterFailed() {
        Iterator i1 = Collections.emptyIterator();
        FilterIterator ci = new FilterIterator(i1, i -> true);
        Assertions.assertFalse((boolean)ci.hasNext());
        try {
            ci.next();
            Assertions.fail((String)"expected error for empty iterator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

