/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.RocksDBDAO;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRocksDBDAO {
    private RocksDBDAO dbManager;

    @BeforeEach
    public void setUpClass() {
        String string = "/dummy/path/" + UUID.randomUUID().toString();
        FileSystemViewStorageConfig.newBuilder().build();
        this.dbManager = new RocksDBDAO(string, FileSystemViewStorageConfig.newBuilder().build().getRocksdbBasePath());
    }

    @AfterEach
    public void tearDownClass() {
        if (this.dbManager != null) {
            this.dbManager.close();
            this.dbManager = null;
        }
    }

    @Test
    public void testRocksDBManager() {
        String prefix1 = "prefix1_";
        String prefix2 = "prefix2_";
        String prefix3 = "prefix3_";
        String prefix4 = "prefix4_";
        List<String> prefixes = Arrays.asList(prefix1, prefix2, prefix3, prefix4);
        String family1 = "family1";
        String family2 = "family2";
        List<String> colFamilies = Arrays.asList(family1, family2);
        ArrayList payloads = new ArrayList();
        IntStream.range(0, 100).forEach(index -> {
            String prefix = (String)prefixes.get(index % 4);
            String key = prefix + UUID.randomUUID();
            String family = (String)colFamilies.get(index % 2);
            String val = "VALUE_" + UUID.randomUUID();
            payloads.add(new Payload<String>(prefix, key, val, family));
        });
        colFamilies.forEach(family -> this.dbManager.dropColumnFamily(family));
        colFamilies.forEach(family -> this.dbManager.addColumnFamily(family));
        HashMap countsMap = new HashMap();
        payloads.forEach(payload -> {
            Map c;
            this.dbManager.put(payload.getFamily(), (String)payload.getKey(), (Serializable)payload);
            if (!countsMap.containsKey(((Payload)payload).family)) {
                countsMap.put(((Payload)payload).family, new HashMap());
            }
            if (!(c = (Map)countsMap.get(((Payload)payload).family)).containsKey(((Payload)payload).prefix)) {
                c.put(((Payload)payload).prefix, 0);
            }
            int currCount = (Integer)c.get(((Payload)payload).prefix);
            c.put(((Payload)payload).prefix, currCount + 1);
        });
        colFamilies.forEach(family -> prefixes.forEach(prefix -> {
            List<Pair> gotPayloads = this.dbManager.prefixSearch(family, prefix).collect(Collectors.toList());
            Integer expCount = (Integer)((Map)countsMap.get(family)).get(prefix);
            Assertions.assertEquals((long)(expCount == null ? 0L : expCount.longValue()), (long)gotPayloads.size(), (String)("Size check for prefix (" + prefix + ") and family (" + family + ")"));
            gotPayloads.forEach(p -> {
                Assertions.assertEquals((Object)((Payload)p.getRight()).getFamily(), (Object)family);
                Assertions.assertTrue((boolean)((Payload)p.getRight()).getKey().toString().startsWith((String)prefix));
            });
        }));
        payloads.stream().filter(p -> !p.getPrefix().equalsIgnoreCase(prefix1)).forEach(payload -> {
            Payload p = (Payload)this.dbManager.get(payload.getFamily(), (String)payload.getKey());
            Assertions.assertEquals((Object)payload, (Object)p, (String)("Retrieved correct payload for key :" + (String)payload.getKey()));
            this.dbManager.delete(payload.getFamily(), (String)payload.getKey());
            Payload p2 = (Payload)this.dbManager.get(payload.getFamily(), (String)payload.getKey());
            Assertions.assertNull((Object)p2, (String)("Retrieved correct payload for key :" + (String)payload.getKey()));
        });
        colFamilies.forEach(family -> {
            long countBeforeDeletion = this.dbManager.prefixSearch(family, prefix1).count();
            this.dbManager.prefixDelete(family, prefix1);
            if (countBeforeDeletion > 0L) {
                long countAfterDeletion = this.dbManager.prefixSearch(family, prefix1).count();
                Assertions.assertEquals((long)0L, (long)countAfterDeletion, (String)("Expected prefixDelete to remove all items for family: " + family));
            }
        });
        payloads.stream().filter(p -> !p.getPrefix().equalsIgnoreCase(prefix1)).forEach(payload -> {
            Payload p2 = (Payload)this.dbManager.get(payload.getFamily(), (String)payload.getKey());
            Assertions.assertNull((Object)p2, (String)("Retrieved correct payload for key :" + (String)payload.getKey()));
        });
        colFamilies.forEach(family -> prefixes.stream().filter(p -> !p.equalsIgnoreCase(prefix1)).forEach(prefix -> {
            List gotPayloads = this.dbManager.prefixSearch(family, prefix).collect(Collectors.toList());
            Assertions.assertEquals((int)0, (int)gotPayloads.size(), (String)("Size check for prefix (" + prefix + ") and family (" + family + ")"));
        }));
        String rocksDBBasePath = this.dbManager.getRocksDBBasePath();
        this.dbManager.close();
        Assertions.assertFalse((boolean)new File(rocksDBBasePath).exists());
    }

    @Test
    public void testWithSerializableKey() {
        String prefix1 = "prefix1_";
        String prefix2 = "prefix2_";
        String prefix3 = "prefix3_";
        String prefix4 = "prefix4_";
        List<String> prefixes = Arrays.asList(prefix1, prefix2, prefix3, prefix4);
        String family1 = "family1";
        String family2 = "family2";
        List<String> colFamilies = Arrays.asList(family1, family2);
        ArrayList payloads = new ArrayList();
        IntStream.range(0, 100).forEach(index -> {
            String prefix = (String)prefixes.get(index % 4);
            String key = prefix + UUID.randomUUID().toString();
            String family = (String)colFamilies.get(index % 2);
            String val = "VALUE_" + UUID.randomUUID().toString();
            payloads.add(new Payload<PayloadKey>(prefix, new PayloadKey(key), val, family));
        });
        colFamilies.forEach(family -> this.dbManager.dropColumnFamily(family));
        colFamilies.forEach(family -> this.dbManager.addColumnFamily(family));
        HashMap countsMap = new HashMap();
        this.dbManager.writeBatch(batch -> payloads.forEach(payload -> {
            Map c;
            this.dbManager.putInBatch(batch, payload.getFamily(), (Serializable)payload.getKey(), payload);
            if (!countsMap.containsKey(((Payload)payload).family)) {
                countsMap.put(((Payload)payload).family, new HashMap());
            }
            if (!(c = (Map)countsMap.get(((Payload)payload).family)).containsKey(((Payload)payload).prefix)) {
                c.put(((Payload)payload).prefix, 0);
            }
            int currCount = (Integer)c.get(((Payload)payload).prefix);
            c.put(((Payload)payload).prefix, currCount + 1);
        }));
        Iterator<List<Payload>> payloadSplits = payloads.stream().collect(Collectors.partitioningBy(s -> payloads.indexOf(s) > payloads.size() / 2)).values().iterator();
        payloads.forEach(payload -> {
            Payload p = (Payload)this.dbManager.get(payload.getFamily(), (Serializable)payload.getKey());
            Assertions.assertEquals((Object)payload, (Object)p, (String)("Retrieved correct payload for key :" + payload.getKey()));
        });
        payloadSplits.next().forEach(payload -> {
            this.dbManager.delete(payload.getFamily(), (Serializable)payload.getKey());
            Payload want = (Payload)this.dbManager.get(payload.getFamily(), (Serializable)payload.getKey());
            Assertions.assertNull((Object)want, (String)("Verify deleted during single delete for key :" + payload.getKey()));
        });
        this.dbManager.writeBatch(batch -> ((List)payloadSplits.next()).forEach(payload -> {
            this.dbManager.deleteInBatch(batch, payload.getFamily(), (Serializable)payload.getKey());
            Payload want = (Payload)this.dbManager.get(payload.getFamily(), (Serializable)payload.getKey());
            Assertions.assertEquals((Object)payload, (Object)want, (String)("Verify not deleted during batch delete in progress for key :" + payload.getKey()));
        }));
        payloads.forEach(payload -> {
            Payload want = (Payload)this.dbManager.get(payload.getFamily(), (Serializable)payload.getKey());
            Assertions.assertNull((Object)want, (String)("Verify delete for key :" + payload.getKey()));
        });
        colFamilies.forEach(family -> prefixes.forEach(prefix -> {
            List gotPayloads = this.dbManager.prefixSearch(family, prefix).collect(Collectors.toList());
            Assertions.assertEquals((int)0, (int)gotPayloads.size(), (String)("Size check for prefix (" + prefix + ") and family (" + family + ")"));
        }));
        String rocksDBBasePath = this.dbManager.getRocksDBBasePath();
        this.dbManager.close();
        Assertions.assertFalse((boolean)new File(rocksDBBasePath).exists());
    }

    public static class Payload<T>
    implements Serializable {
        private final String prefix;
        private final T key;
        private final String val;
        private final String family;

        public Payload(String prefix, T key, String val, String family) {
            this.prefix = prefix;
            this.key = key;
            this.val = val;
            this.family = family;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public T getKey() {
            return this.key;
        }

        public String getVal() {
            return this.val;
        }

        public String getFamily() {
            return this.family;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Payload payload = (Payload)o;
            return Objects.equals(this.prefix, payload.prefix) && Objects.equals(this.key, payload.key) && Objects.equals(this.val, payload.val) && Objects.equals(this.family, payload.family);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.key, this.val, this.family);
        }
    }

    public static class PayloadKey
    implements Serializable {
        private String key;

        public PayloadKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PayloadKey that = (PayloadKey)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

