/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.Arrays;
import java.util.Map;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMergeSchema {
    @Test
    public void testPrimitiveMerge() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"col2", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"col3", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get())));
        InternalSchema oldSchema = new InternalSchema(record);
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get((InternalSchema)oldSchema);
        addChange.addColumns("c1", (Type)Types.BooleanType.get(), "add c1 after col1");
        addChange.addPositionChange("c1", "col1", "after");
        addChange.addColumns("c2", (Type)Types.IntType.get(), "add c2 before col3");
        addChange.addPositionChange("c2", "col3", "before");
        InternalSchema newAddSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnAddChange)addChange);
        TableChanges.ColumnDeleteChange deleteChange = TableChanges.ColumnDeleteChange.get((InternalSchema)newAddSchema);
        deleteChange.deleteColumn("col1");
        deleteChange.deleteColumn("col3");
        InternalSchema newDeleteSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)newAddSchema, (TableChanges.ColumnDeleteChange)deleteChange);
        Assertions.assertEquals((int)newAddSchema.getMaxColumnId(), (int)newDeleteSchema.getMaxColumnId());
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get((InternalSchema)newDeleteSchema);
        updateChange.updateColumnType("col2", (Type)Types.LongType.get()).updateColumnComment("col2", "alter col2 comments").renameColumn("col2", "colx").addPositionChange("col2", "col4", "after");
        InternalSchema updateSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)newDeleteSchema, (TableChanges.ColumnUpdateChange)updateChange);
        TableChanges.ColumnAddChange addChange1 = TableChanges.ColumnAddChange.get((InternalSchema)updateSchema);
        addChange1.addColumns("col1", (Type)Types.BooleanType.get(), "add new col1");
        InternalSchema finalSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)updateSchema, (TableChanges.ColumnAddChange)addChange1);
        Pair mergeSchemaWithRenamedField = new InternalSchemaMerger(oldSchema, finalSchema, true, false, false).mergeSchemaGetRenamed();
        InternalSchema mergeSchema = (InternalSchema)mergeSchemaWithRenamedField.getLeft();
        Assertions.assertEquals((Object)"col2", ((Map)mergeSchemaWithRenamedField.getRight()).get("colx"));
        InternalSchema checkedSchema = new InternalSchema(Types.RecordType.get(Arrays.asList(Types.Field.get((int)4, (boolean)true, (String)"c1", (Type)Types.BooleanType.get(), (String)"add c1 after col1"), Types.Field.get((int)5, (boolean)true, (String)"c2", (Type)Types.IntType.get(), (String)"add c2 before col3"), Types.Field.get((int)3, (boolean)true, (String)"col4", (Type)Types.FloatType.get()), Types.Field.get((int)1, (boolean)true, (String)"col2", (Type)Types.LongType.get(), (String)"alter col2 comments"), Types.Field.get((int)6, (boolean)true, (String)"col1suffix", (Type)Types.BooleanType.get(), (String)"add new col1"))));
        mergeSchema = new InternalSchemaMerger(oldSchema, finalSchema, true, false).mergeSchema();
        Assertions.assertEquals((Object)mergeSchema, (Object)checkedSchema);
        InternalSchema mergeSchema1 = new InternalSchemaMerger(oldSchema, finalSchema, true, true).mergeSchema();
        InternalSchema checkedSchema1 = new InternalSchema(Types.RecordType.get(Arrays.asList(Types.Field.get((int)4, (boolean)true, (String)"c1", (Type)Types.BooleanType.get(), (String)"add c1 after col1"), Types.Field.get((int)5, (boolean)true, (String)"c2", (Type)Types.IntType.get(), (String)"add c2 before col3"), Types.Field.get((int)3, (boolean)true, (String)"col4", (Type)Types.FloatType.get()), Types.Field.get((int)1, (boolean)true, (String)"col2", (Type)Types.IntType.get(), (String)"alter col2 comments"), Types.Field.get((int)6, (boolean)true, (String)"col1suffix", (Type)Types.BooleanType.get(), (String)"add new col1"))));
        Assertions.assertEquals((Object)mergeSchema1, (Object)checkedSchema1);
    }
}

