/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.convert;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaTestUtils;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroInternalSchemaConverter {
    public static Schema getSimpleSchema() {
        return AvroSchemaTestUtils.createRecord("simpleSchema", AvroSchemaTestUtils.createPrimitiveField("field1", Schema.Type.INT), AvroSchemaTestUtils.createPrimitiveField("field2", Schema.Type.STRING));
    }

    public static List<String> getSimpleSchemaExpectedColumnNames() {
        return Arrays.asList("field1", "field2");
    }

    public static Schema getSimpleSchemaWithNullable() {
        return AvroSchemaTestUtils.createRecord("simpleSchemaWithNullable", AvroSchemaTestUtils.createNullablePrimitiveField("field1", Schema.Type.INT), AvroSchemaTestUtils.createPrimitiveField("field2", Schema.Type.STRING));
    }

    public static Schema getComplexSchemaSingleLevel() {
        return AvroSchemaTestUtils.createRecord("complexSchemaSingleLevel", AvroSchemaTestUtils.createNestedField("field1", Schema.Type.INT), AvroSchemaTestUtils.createArrayField("field2", Schema.Type.STRING), AvroSchemaTestUtils.createMapField("field3", Schema.Type.DOUBLE));
    }

    public static List<String> getComplexSchemaSingleLevelExpectedColumnNames() {
        return Arrays.asList("field1.nested", "field2.element", "field3.key", "field3.value");
    }

    public static Schema getDeeplyNestedFieldSchema() {
        return AvroSchemaTestUtils.createRecord("deeplyNestedFieldSchema", AvroSchemaTestUtils.createPrimitiveField("field1", Schema.Type.INT), new Schema.Field("field2", AvroSchemaTestUtils.createRecord("field2nest", AvroSchemaTestUtils.createArrayField("field2nestarray", AvroSchemaTestUtils.createNullableRecord("field2nestarraynest", AvroSchemaTestUtils.createNullablePrimitiveField("field21", Schema.Type.INT), AvroSchemaTestUtils.createNullablePrimitiveField("field22", Schema.Type.INT)))), null, null), AvroSchemaTestUtils.createNullablePrimitiveField("field3", Schema.Type.INT));
    }

    public static List<String> getDeeplyNestedFieldSchemaExpectedColumnNames() {
        return Arrays.asList("field1", "field2.field2nestarray.element.field21", "field2.field2nestarray.element.field22", "field3");
    }

    @Test
    public void testCollectColumnNames() {
        Schema simpleSchema = TestAvroInternalSchemaConverter.getSimpleSchema();
        List fieldNames = AvroInternalSchemaConverter.collectColNamesFromSchema((Schema)simpleSchema);
        List<String> expectedOutput = TestAvroInternalSchemaConverter.getSimpleSchemaExpectedColumnNames();
        Assertions.assertEquals((int)expectedOutput.size(), (int)fieldNames.size());
        Assertions.assertTrue((boolean)fieldNames.containsAll(expectedOutput));
        Schema simpleSchemaWithNullable = TestAvroInternalSchemaConverter.getSimpleSchemaWithNullable();
        fieldNames = AvroInternalSchemaConverter.collectColNamesFromSchema((Schema)simpleSchemaWithNullable);
        expectedOutput = TestAvroInternalSchemaConverter.getSimpleSchemaExpectedColumnNames();
        Assertions.assertEquals((int)expectedOutput.size(), (int)fieldNames.size());
        Assertions.assertTrue((boolean)fieldNames.containsAll(expectedOutput));
        Schema complexSchemaSingleLevel = TestAvroInternalSchemaConverter.getComplexSchemaSingleLevel();
        fieldNames = AvroInternalSchemaConverter.collectColNamesFromSchema((Schema)complexSchemaSingleLevel);
        expectedOutput = TestAvroInternalSchemaConverter.getComplexSchemaSingleLevelExpectedColumnNames();
        Assertions.assertEquals((int)expectedOutput.size(), (int)fieldNames.size());
        Assertions.assertTrue((boolean)fieldNames.containsAll(expectedOutput));
        Schema deeplyNestedFieldSchema = TestAvroInternalSchemaConverter.getDeeplyNestedFieldSchema();
        fieldNames = AvroInternalSchemaConverter.collectColNamesFromSchema((Schema)deeplyNestedFieldSchema);
        expectedOutput = TestAvroInternalSchemaConverter.getDeeplyNestedFieldSchemaExpectedColumnNames();
        Assertions.assertEquals((int)expectedOutput.size(), (int)fieldNames.size());
        Assertions.assertTrue((boolean)fieldNames.containsAll(expectedOutput));
    }
}

