/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

public class TestMetadataPartitionType {
    @ParameterizedTest
    @EnumSource(value=MetadataPartitionType.class)
    public void testPartitionEnabledByConfigOnly(MetadataPartitionType partitionType) {
        int expectedEnabledPartitions;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)tableConfig.isMetadataPartitionAvailable(partitionType)).thenReturn((Object)false);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        HoodieMetadataConfig.Builder metadataConfigBuilder = HoodieMetadataConfig.newBuilder();
        switch (partitionType) {
            case EXPRESSION_INDEX: {
                metadataConfigBuilder.enable(true).withExpressionIndexEnabled(true);
                expectedEnabledPartitions = 4;
                break;
            }
            case SECONDARY_INDEX: {
                metadataConfigBuilder.enable(true).withEnableRecordIndex(true).withSecondaryIndexEnabled(true);
                expectedEnabledPartitions = 5;
                break;
            }
            case BLOOM_FILTERS: {
                metadataConfigBuilder.enable(true).withMetadataIndexBloomFilter(true);
                expectedEnabledPartitions = 4;
                break;
            }
            case RECORD_INDEX: {
                metadataConfigBuilder.enable(true).withEnableRecordIndex(true);
                expectedEnabledPartitions = 5;
                break;
            }
            default: {
                metadataConfigBuilder.enable(true);
                expectedEnabledPartitions = 3;
            }
        }
        List enabledPartitions = MetadataPartitionType.getEnabledPartitions((HoodieMetadataConfig)metadataConfigBuilder.build(), (HoodieTableMetaClient)metaClient);
        Assertions.assertEquals((int)expectedEnabledPartitions, (int)enabledPartitions.size());
        Assertions.assertTrue((enabledPartitions.contains(partitionType) || MetadataPartitionType.ALL_PARTITIONS.equals((Object)partitionType) ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionAvailableByMetaClientOnly() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)tableConfig.isMetadataPartitionAvailable(MetadataPartitionType.FILES)).thenReturn((Object)true);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        Mockito.when((Object)metaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX)).thenReturn((Object)true);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withEnableRecordIndex(false).build();
        List enabledPartitions = MetadataPartitionType.getEnabledPartitions((HoodieMetadataConfig)metadataConfig, (HoodieTableMetaClient)metaClient);
        Assertions.assertEquals((int)4, (int)enabledPartitions.size(), (String)"RECORD_INDEX, FILES, COL_STATS, PARTITION_STATS should be available");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.FILES), (String)"FILES should be enabled by availability");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.RECORD_INDEX), (String)"RECORD_INDEX should be enabled by availability");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.COLUMN_STATS), (String)"COLUMN_STATS should be enabled by default");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.PARTITION_STATS), (String)"PARTITION_STATS should be enabled by default");
    }

    @Test
    public void testNoPartitionsEnabled() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        Mockito.when((Object)metaClient.getTableConfig().isMetadataPartitionAvailable((MetadataPartitionType)Mockito.any())).thenReturn((Object)false);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(false).build();
        List enabledPartitions = MetadataPartitionType.getEnabledPartitions((HoodieMetadataConfig)metadataConfig, (HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)enabledPartitions.isEmpty(), (String)"No partitions should be enabled");
    }

    @Test
    public void testExpressionIndexPartitionEnabled() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)tableConfig.isMetadataPartitionAvailable(MetadataPartitionType.FILES)).thenReturn((Object)true);
        HoodieIndexDefinition expressionIndexDefinition = this.createIndexDefinition(MetadataPartitionType.EXPRESSION_INDEX, "dummy", "column_stats", "lower", Collections.singletonList("name"), null);
        HoodieIndexMetadata expressionIndexMetadata = new HoodieIndexMetadata(Collections.singletonMap("expr_index_dummy", expressionIndexDefinition));
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)expressionIndexMetadata));
        Mockito.when((Object)metaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.EXPRESSION_INDEX)).thenReturn((Object)true);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).build();
        List enabledPartitions = MetadataPartitionType.getEnabledPartitions((HoodieMetadataConfig)metadataConfig, (HoodieTableMetaClient)metaClient);
        Assertions.assertEquals((int)4, (int)enabledPartitions.size(), (String)"EXPRESSION_INDEX, FILES, COL_STATS and SECONDARY_INDEX should be available");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.FILES), (String)"FILES should be enabled by availability");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.EXPRESSION_INDEX), (String)"EXPRESSION_INDEX should be enabled by availability");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.COLUMN_STATS), (String)"COLUMN_STATS should be enabled by default");
        Assertions.assertTrue((boolean)enabledPartitions.contains(MetadataPartitionType.PARTITION_STATS), (String)"PARTITION_STATS should be enabled by default");
    }

    @Test
    public void testGetMetadataPartitionsNeedingWriteStatusTracking() {
        List trackingPartitions = MetadataPartitionType.getMetadataPartitionsNeedingWriteStatusTracking();
        Assertions.assertTrue((boolean)trackingPartitions.contains(MetadataPartitionType.RECORD_INDEX), (String)"RECORD_INDEX should need write status tracking");
        Assertions.assertEquals((int)1, (int)trackingPartitions.size(), (String)"Only one partition should need write status tracking");
    }

    @Test
    public void testFromPartitionPath() {
        Assertions.assertEquals((Object)MetadataPartitionType.FILES, (Object)MetadataPartitionType.fromPartitionPath((String)"files"));
        Assertions.assertEquals((Object)MetadataPartitionType.EXPRESSION_INDEX, (Object)MetadataPartitionType.fromPartitionPath((String)"expr_index_dummy"));
        Assertions.assertEquals((Object)MetadataPartitionType.SECONDARY_INDEX, (Object)MetadataPartitionType.fromPartitionPath((String)"secondary_index_dummy"));
        Assertions.assertEquals((Object)MetadataPartitionType.COLUMN_STATS, (Object)MetadataPartitionType.fromPartitionPath((String)"column_stats"));
        Assertions.assertEquals((Object)MetadataPartitionType.BLOOM_FILTERS, (Object)MetadataPartitionType.fromPartitionPath((String)"bloom_filters"));
        Assertions.assertEquals((Object)MetadataPartitionType.RECORD_INDEX, (Object)MetadataPartitionType.fromPartitionPath((String)"record_index"));
        Assertions.assertEquals((Object)MetadataPartitionType.PARTITION_STATS, (Object)MetadataPartitionType.fromPartitionPath((String)"partition_stats"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataPartitionType.fromPartitionPath((String)"unknown"));
    }

    @Test
    public void testGetMetadataPartitionRecordType() {
        Assertions.assertEquals((int)1, (int)MetadataPartitionType.ALL_PARTITIONS.getRecordType());
        Assertions.assertEquals((int)2, (int)MetadataPartitionType.FILES.getRecordType());
        Assertions.assertEquals((int)3, (int)MetadataPartitionType.COLUMN_STATS.getRecordType());
        Assertions.assertEquals((int)4, (int)MetadataPartitionType.BLOOM_FILTERS.getRecordType());
        Assertions.assertEquals((int)5, (int)MetadataPartitionType.RECORD_INDEX.getRecordType());
        Assertions.assertEquals((int)6, (int)MetadataPartitionType.PARTITION_STATS.getRecordType());
        Assertions.assertEquals((int)7, (int)MetadataPartitionType.SECONDARY_INDEX.getRecordType());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataPartitionType.class)
    public void testGetNonExpressionIndexPath(MetadataPartitionType partitionType) {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        String expressionIndexName = "dummyExpressionIndex";
        String secondaryIndexName = "dummySecondaryIndex";
        HoodieIndexMetadata indexMetadata = TestMetadataPartitionType.getIndexMetadata(expressionIndexName, secondaryIndexName);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        if (partitionType == MetadataPartitionType.EXPRESSION_INDEX) {
            Assertions.assertEquals((Object)expressionIndexName, (Object)partitionType.getPartitionPath(metaClient, expressionIndexName));
        } else if (partitionType == MetadataPartitionType.SECONDARY_INDEX) {
            Assertions.assertEquals((Object)secondaryIndexName, (Object)partitionType.getPartitionPath(metaClient, secondaryIndexName));
        } else {
            Assertions.assertEquals((Object)partitionType.getPartitionPath(), (Object)partitionType.getPartitionPath(metaClient, null));
        }
    }

    private static HoodieIndexMetadata getIndexMetadata(String expressionIndexName, String secondaryIndexName) {
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        HoodieIndexDefinition expressionIndexDefinition = HoodieIndexDefinition.newBuilder().withIndexName(expressionIndexName).withIndexType("column_stats").withIndexFunction("lower").withSourceFields(Collections.singletonList("name")).build();
        indexDefinitions.put(expressionIndexName, expressionIndexDefinition);
        HoodieIndexDefinition secondaryIndexDefinition = HoodieIndexDefinition.newBuilder().withIndexName(secondaryIndexName).withIndexType(null).withIndexFunction(null).withSourceFields(Collections.singletonList("name")).build();
        indexDefinitions.put(secondaryIndexName, secondaryIndexDefinition);
        return new HoodieIndexMetadata(indexDefinitions);
    }

    @Test
    public void testExceptionForMissingExpressionIndexMetadata() {
        MetadataPartitionType partitionType = MetadataPartitionType.EXPRESSION_INDEX;
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> partitionType.getPartitionPath(metaClient, "testIndex"));
    }

    @Test
    public void testIndexNameWithoutPrefix() {
        for (MetadataPartitionType partitionType : MetadataPartitionType.getValidValues()) {
            String userIndexName = MetadataPartitionType.isExpressionOrSecondaryIndex((String)partitionType.getPartitionPath()) ? "idx" : "";
            HoodieIndexDefinition indexDefinition = this.createIndexDefinition(partitionType, userIndexName, null, null, null, null);
            Assertions.assertEquals((Object)partitionType.getIndexNameWithoutPrefix(indexDefinition), (Object)userIndexName);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HoodieIndexDefinition indexDefinition = this.createIndexDefinition(MetadataPartitionType.RECORD_INDEX, "", null, null, null, null);
            MetadataPartitionType.EXPRESSION_INDEX.getIndexNameWithoutPrefix(indexDefinition);
        });
    }

    private HoodieIndexDefinition createIndexDefinition(MetadataPartitionType partitionType, String userIndexName, String indexType, String indexFunction, List<String> sourceFields, Map<String, String> indexOptions) {
        String indexSuffix = StringUtils.nonEmpty((String)userIndexName) ? userIndexName : "";
        return HoodieIndexDefinition.newBuilder().withIndexName(partitionType.getPartitionPath() + indexSuffix).withIndexType(indexType).withIndexFunction(indexFunction).withSourceFields(sourceFields).withIndexOptions(indexOptions).build();
    }

    @Test
    public void testIsExpressionOrSecondaryIndex() {
        Assertions.assertTrue((boolean)MetadataPartitionType.isExpressionOrSecondaryIndex((String)"expr_index_"));
        Assertions.assertTrue((boolean)MetadataPartitionType.isExpressionOrSecondaryIndex((String)"expr_index_idx"));
        Assertions.assertTrue((boolean)MetadataPartitionType.isExpressionOrSecondaryIndex((String)"secondary_index_"));
        Assertions.assertTrue((boolean)MetadataPartitionType.isExpressionOrSecondaryIndex((String)"secondary_index_idx"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataPartitionType.isExpressionOrSecondaryIndex((String)"expr_index"), (String)"No MetadataPartitionType for partition path: expr_index");
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataPartitionType.isExpressionOrSecondaryIndex((String)"expr_indexidx"), (String)"No MetadataPartitionType for partition path: expr_indexidx");
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataPartitionType.isExpressionOrSecondaryIndex((String)"secondary_index"), (String)"No MetadataPartitionType for partition path: secondary_index");
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataPartitionType.isExpressionOrSecondaryIndex((String)"secondary_indexidx"), (String)"No MetadataPartitionType for partition path: secondary_indexidx");
        for (MetadataPartitionType partitionType : MetadataPartitionType.getValidValues()) {
            if (partitionType == MetadataPartitionType.EXPRESSION_INDEX || partitionType == MetadataPartitionType.SECONDARY_INDEX) continue;
            Assertions.assertFalse((boolean)MetadataPartitionType.isExpressionOrSecondaryIndex((String)partitionType.getPartitionPath()));
        }
    }
}

