/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.ConsoleMetricsReporter;
import org.apache.hudi.metrics.InMemoryMetricsReporter;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.Slf4jMetricsReporter;
import org.apache.hudi.metrics.custom.CustomizableMetricsReporter;
import org.apache.hudi.metrics.prometheus.PrometheusReporter;
import org.apache.hudi.metrics.prometheus.PushGatewayMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestMetricsReporterFactory {
    @Mock
    HoodieMetricsConfig metricsConfig;
    @Mock
    MetricRegistry registry;

    TestMetricsReporterFactory() {
    }

    public static Object[][] params() {
        return new Object[][]{{MetricsReporterType.INMEMORY, InMemoryMetricsReporter.class}, {MetricsReporterType.CONSOLE, ConsoleMetricsReporter.class}, {MetricsReporterType.PROMETHEUS, PrometheusReporter.class}, {MetricsReporterType.PROMETHEUS_PUSHGATEWAY, PushGatewayMetricsReporter.class}, {MetricsReporterType.SLF4J, Slf4jMetricsReporter.class}};
    }

    @ParameterizedTest
    @MethodSource(value={"params"})
    public void metricsReporterFactoryShouldReturnReporter(MetricsReporterType type, Class expectClazz) {
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)type);
        MetricsReporter reporter = (MetricsReporter)MetricsReporterFactory.createReporter((HoodieMetricsConfig)this.metricsConfig, (MetricRegistry)this.registry).get();
        Assertions.assertEquals(reporter.getClass(), (Object)expectClazz);
    }

    @Test
    void metricsReporterFactoryShouldReturnCloudWatchReporter() {
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.CLOUDWATCH);
        MetricsReporter reporterMock = (MetricsReporter)Mockito.mock(MetricsReporter.class);
        try (MockedStatic mockedStatic = Mockito.mockStatic(ReflectionUtils.class);){
            mockedStatic.when(() -> ReflectionUtils.loadClass((String)((String)ArgumentMatchers.eq((Object)"org.apache.hudi.aws.metrics.cloudwatch.CloudWatchMetricsReporter")), (Class[])((Class[])Mockito.any(Class[].class)), (Object[])new Object[]{ArgumentMatchers.eq((Object)this.metricsConfig), ArgumentMatchers.eq((Object)this.registry)})).thenReturn((Object)reporterMock);
            MetricsReporter actualReporter = (MetricsReporter)MetricsReporterFactory.createReporter((HoodieMetricsConfig)this.metricsConfig, (MetricRegistry)this.registry).get();
            Assertions.assertSame((Object)reporterMock, (Object)actualReporter);
        }
    }

    @Test
    void metricsReporterFactoryShouldReturnUserDefinedReporter() {
        Mockito.when((Object)this.metricsConfig.getMetricReporterClassName()).thenReturn((Object)DummyMetricsReporter.class.getName());
        TypedProperties props = new TypedProperties();
        props.setProperty("testKey", "testValue");
        Mockito.when((Object)this.metricsConfig.getProps()).thenReturn((Object)props);
        MetricsReporter reporter = (MetricsReporter)MetricsReporterFactory.createReporter((HoodieMetricsConfig)this.metricsConfig, (MetricRegistry)this.registry).get();
        Assertions.assertTrue((boolean)(reporter instanceof CustomizableMetricsReporter));
        Assertions.assertEquals((Object)props, (Object)((DummyMetricsReporter)reporter).getProps());
        Assertions.assertEquals((Object)this.registry, (Object)((DummyMetricsReporter)reporter).getRegistry());
    }

    @Test
    void metricsReporterFactoryShouldThrowExceptionWhenMetricsReporterClassIsIllegal() {
        Mockito.when((Object)this.metricsConfig.getMetricReporterClassName()).thenReturn((Object)IllegalTestMetricsReporter.class.getName());
        Mockito.when((Object)this.metricsConfig.getProps()).thenReturn((Object)new TypedProperties());
        Assertions.assertThrows(HoodieException.class, () -> MetricsReporterFactory.createReporter((HoodieMetricsConfig)this.metricsConfig, (MetricRegistry)this.registry));
    }

    public static class IllegalTestMetricsReporter {
        public IllegalTestMetricsReporter(Properties props, MetricRegistry registry) {
        }
    }

    public static class DummyMetricsReporter
    extends CustomizableMetricsReporter {
        public DummyMetricsReporter(Properties props, MetricRegistry registry) {
            super(props, registry);
        }

        public void start() {
        }

        public void report() {
        }

        public void stop() {
        }
    }
}

