/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.util.ExternalFilePathUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieBaseFile
extends BaseFile {
    private static final long serialVersionUID = 1L;
    private static final char UNDERSCORE = '_';
    private static final char DOT = '.';
    private final String fileId;
    private final String commitTime;
    private Option<BaseFile> bootstrapBaseFile;

    public HoodieBaseFile(HoodieBaseFile dataFile) {
        super(dataFile);
        this.bootstrapBaseFile = dataFile.bootstrapBaseFile;
        this.fileId = dataFile.getFileId();
        this.commitTime = dataFile.getCommitTime();
    }

    public HoodieBaseFile(StoragePathInfo pathInfo) {
        this(pathInfo, null);
    }

    public HoodieBaseFile(StoragePathInfo pathInfo, BaseFile bootstrapBaseFile) {
        this(pathInfo, HoodieBaseFile.getFileIdAndCommitTimeFromFileName(pathInfo.getPath().getName()), bootstrapBaseFile);
    }

    public HoodieBaseFile(String filePath) {
        this(filePath, null);
    }

    public HoodieBaseFile(String filePath, BaseFile bootstrapBaseFile) {
        super(filePath);
        this.bootstrapBaseFile = Option.ofNullable((Object)bootstrapBaseFile);
        String[] fileIdAndCommitTime = HoodieBaseFile.getFileIdAndCommitTimeFromFileName(this.getFileName());
        this.fileId = fileIdAndCommitTime[0];
        this.commitTime = fileIdAndCommitTime[1];
    }

    public HoodieBaseFile(String filePath, String fileId, String commitTime, BaseFile bootstrapBaseFile) {
        super(filePath);
        this.bootstrapBaseFile = Option.ofNullable((Object)bootstrapBaseFile);
        this.fileId = fileId;
        this.commitTime = commitTime;
    }

    private HoodieBaseFile(StoragePathInfo pathInfo, String[] fileIdAndCommitTime, BaseFile bootstrapBaseFile) {
        this(pathInfo, fileIdAndCommitTime[0], fileIdAndCommitTime[1], bootstrapBaseFile);
    }

    public HoodieBaseFile(StoragePathInfo pathInfo, String fileId, String commitTime, BaseFile bootstrapBaseFile) {
        super(HoodieBaseFile.maybeHandleExternallyGeneratedFileName(pathInfo, fileId));
        this.bootstrapBaseFile = Option.ofNullable((Object)bootstrapBaseFile);
        this.fileId = fileId;
        this.commitTime = commitTime;
    }

    private static String[] getFileIdAndCommitTimeFromFileName(String fileName) {
        return ExternalFilePathUtil.isExternallyCreatedFile(fileName) ? HoodieBaseFile.handleExternallyGeneratedFile(fileName) : HoodieBaseFile.handleHudiGeneratedFile(fileName);
    }

    private static String[] handleHudiGeneratedFile(String fileName) {
        String[] values = new String[2];
        int underscoreCount = 0;
        int lastUnderscoreIndex = 0;
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '_') {
                if (underscoreCount == 0) {
                    values[0] = fileName.substring(0, i);
                }
                lastUnderscoreIndex = (short)i;
                underscoreCount = (short)(underscoreCount + 1);
                continue;
            }
            if (c != '.' || underscoreCount != 2) continue;
            values[1] = fileName.substring(lastUnderscoreIndex + 1, i);
            return values;
        }
        values[1] = fileName.substring(lastUnderscoreIndex + 1);
        return values;
    }

    private static String[] handleExternallyGeneratedFile(String fileName) {
        String[] values = new String[2];
        int lastUnderscore = fileName.lastIndexOf(95);
        int secondToLastUnderscore = fileName.lastIndexOf(95, lastUnderscore - 1);
        values[0] = fileName.substring(0, secondToLastUnderscore);
        values[1] = fileName.substring(secondToLastUnderscore + 1, lastUnderscore);
        return values;
    }

    private static StoragePathInfo maybeHandleExternallyGeneratedFileName(StoragePathInfo pathInfo, String fileId) {
        if (pathInfo == null) {
            return null;
        }
        if (ExternalFilePathUtil.isExternallyCreatedFile(pathInfo.getPath().getName())) {
            StoragePath parent = pathInfo.getPath().getParent();
            return new StoragePathInfo(new StoragePath(parent, fileId), pathInfo.getLength(), pathInfo.isDirectory(), pathInfo.getBlockReplication(), pathInfo.getBlockSize(), pathInfo.getModificationTime(), pathInfo.getLocations());
        }
        return pathInfo;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public Option<BaseFile> getBootstrapBaseFile() {
        return this.bootstrapBaseFile;
    }

    public void setBootstrapBaseFile(BaseFile bootstrapBaseFile) {
        this.bootstrapBaseFile = Option.ofNullable((Object)bootstrapBaseFile);
    }

    @Override
    public String toString() {
        return "HoodieBaseFile{fullPath=" + this.getPath() + ", fileLen=" + this.getFileLen() + ", BootstrapBaseFile=" + this.bootstrapBaseFile.orElse(null) + '}';
    }
}

