/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;

public class ActiveAction
implements Serializable,
Comparable<ActiveAction> {
    private final HoodieInstant requested;
    private final HoodieInstant inflight;
    private final List<HoodieInstant> completed;

    protected ActiveAction(@Nullable HoodieInstant requested, @Nullable HoodieInstant inflight, List<HoodieInstant> completed) {
        this.requested = requested;
        this.inflight = inflight;
        this.completed = completed;
    }

    public static ActiveAction fromInstants(List<HoodieInstant> instants) {
        ValidationUtils.checkArgument((instants != null ? 1 : 0) != 0, (String)"Instants should not be null");
        HoodieInstant requested = null;
        HoodieInstant inflight = null;
        ArrayList<HoodieInstant> completed = new ArrayList<HoodieInstant>();
        for (HoodieInstant instant : instants) {
            if (instant.isRequested()) {
                requested = instant;
                continue;
            }
            if (instant.isInflight()) {
                inflight = instant;
                continue;
            }
            completed.add(instant);
        }
        ValidationUtils.checkState((!completed.isEmpty() ? 1 : 0) != 0, (String)("The instants to archive must be completed: " + instants));
        completed.sort(Comparator.comparing(HoodieInstant::getCompletionTime).reversed());
        return new ActiveAction(requested, inflight, completed);
    }

    public List<HoodieInstant> getPendingInstants() {
        ArrayList<HoodieInstant> instants = new ArrayList<HoodieInstant>(2);
        if (this.requested != null) {
            instants.add(this.requested);
        }
        if (this.inflight != null) {
            instants.add(this.inflight);
        }
        return instants;
    }

    public List<HoodieInstant> getCompletedInstants() {
        return this.completed;
    }

    private HoodieInstant getCompleted() {
        return this.completed.get(0);
    }

    public String getAction() {
        return this.getCompleted().getAction();
    }

    public String getPendingAction() {
        return (String)this.getPendingInstant().map(HoodieInstant::getAction).orElse((Object)"null");
    }

    public String getInstantTime() {
        return this.getCompleted().requestedTime();
    }

    public String getCompletionTime() {
        return this.getCompleted().getCompletionTime();
    }

    public Option<byte[]> getCommitMetadata(HoodieTableMetaClient metaClient) {
        Option<byte[]> content = metaClient.getActiveTimeline().getInstantDetails(this.getCompleted());
        if (content.isPresent() && ((byte[])content.get()).length == 0) {
            return Option.empty();
        }
        return content;
    }

    public Option<byte[]> getRequestedCommitMetadata(HoodieTableMetaClient metaClient) {
        if (this.requested != null) {
            Option<byte[]> requestedContent = metaClient.getActiveTimeline().getInstantDetails(this.requested);
            if (!requestedContent.isPresent() || ((byte[])requestedContent.get()).length == 0) {
                return Option.empty();
            }
            return requestedContent;
        }
        return Option.empty();
    }

    public Option<byte[]> getInflightCommitMetadata(HoodieTableMetaClient metaClient) {
        if (this.inflight != null) {
            Option<byte[]> inflightContent = metaClient.getActiveTimeline().getInstantDetails(this.inflight);
            if (!inflightContent.isPresent() || ((byte[])inflightContent.get()).length == 0) {
                return Option.empty();
            }
            return inflightContent;
        }
        return Option.empty();
    }

    public Option<byte[]> getCleanPlan(HoodieTableMetaClient metaClient) {
        Option<HoodieInstant> pendingInstant = this.getPendingInstant();
        if (!pendingInstant.isPresent()) {
            return Option.empty();
        }
        return metaClient.getActiveTimeline().readCleanerInfoAsBytes((HoodieInstant)pendingInstant.get());
    }

    public Option<byte[]> getCompactionPlan(HoodieTableMetaClient metaClient) {
        if (this.requested != null) {
            return metaClient.getActiveTimeline().readCompactionPlanAsBytes(this.requested);
        }
        return Option.empty();
    }

    public Option<byte[]> getLogCompactionPlan(HoodieTableMetaClient metaClient) {
        if (this.requested != null) {
            return metaClient.getActiveTimeline().readCompactionPlanAsBytes(this.requested);
        }
        return Option.empty();
    }

    protected Option<HoodieInstant> getPendingInstant() {
        if (this.requested != null) {
            return Option.of((Object)this.requested);
        }
        if (this.inflight != null) {
            return Option.of((Object)this.inflight);
        }
        return Option.empty();
    }

    @Override
    public int compareTo(ActiveAction other) {
        return this.getCompleted().requestedTime().compareTo(other.getCompleted().requestedTime());
    }

    public String toString() {
        return this.getInstantTime() + "__" + this.getAction();
    }
}

