/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;

public interface HoodieInstantReader {
    default public InputStream getContentStream(HoodieInstant instant) {
        throw new RuntimeException("Not implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    default public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        try (InputStream inputStream = this.getContentStream(instant);){
            Option option = Option.of((Object)FileIOUtils.readAsByteArray((InputStream)inputStream));
            return option;
        }
        catch (IOException ex) {
            throw new HoodieIOException("Could not read commit details from stream", ex);
        }
    }
}

