/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.timeline.dto.FileStatusDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseFileDTO {
    @JsonProperty(value="fileStatus")
    private FileStatusDTO fileStatus;
    @JsonProperty(value="fullPath")
    private String fullPath;
    @JsonProperty(value="fileLen")
    private long fileLen;
    @JsonProperty(value="commitTime")
    private String commitTime;
    @JsonProperty(value="fileId")
    private String fileId;
    @JsonProperty(value="bootstrapBaseFile")
    private BaseFileDTO bootstrapBaseFile;

    public static HoodieBaseFile toHoodieBaseFile(BaseFileDTO dto) {
        HoodieBaseFile baseFile;
        if (null == dto) {
            return null;
        }
        if (null != dto.fileStatus) {
            baseFile = new HoodieBaseFile(FileStatusDTO.toStoragePathInfo(dto.fileStatus), dto.fileId, dto.commitTime, BaseFileDTO.toBaseFile(dto.bootstrapBaseFile));
        } else {
            baseFile = new HoodieBaseFile(dto.fullPath, dto.fileId, dto.commitTime, BaseFileDTO.toBaseFile(dto.bootstrapBaseFile));
            baseFile.setFileLen(dto.fileLen);
        }
        return baseFile;
    }

    private static BaseFile toBaseFile(BaseFileDTO dto) {
        BaseFile baseFile;
        if (null == dto) {
            return null;
        }
        if (null != dto.fileStatus) {
            baseFile = new BaseFile(FileStatusDTO.toStoragePathInfo(dto.fileStatus));
        } else {
            baseFile = new BaseFile(dto.fullPath);
            baseFile.setFileLen(dto.fileLen);
        }
        return baseFile;
    }

    public static BaseFileDTO fromHoodieBaseFile(BaseFile baseFile) {
        if (null == baseFile) {
            return null;
        }
        BaseFileDTO dto = new BaseFileDTO();
        dto.fileStatus = FileStatusDTO.fromStoragePathInfo(baseFile.getPathInfo());
        dto.fullPath = baseFile.getPath();
        dto.fileLen = baseFile.getFileLen();
        if (baseFile instanceof HoodieBaseFile) {
            HoodieBaseFile hoodieBaseFile = (HoodieBaseFile)baseFile;
            dto.bootstrapBaseFile = (BaseFileDTO)hoodieBaseFile.getBootstrapBaseFile().map(BaseFileDTO::fromHoodieBaseFile).orElse(null);
            dto.fileId = hoodieBaseFile.getFileId();
            dto.commitTime = hoodieBaseFile.getCommitTime();
        }
        return dto;
    }
}

