/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.BaseHoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;

public class BaseTimelineV1
extends BaseHoodieTimeline {
    public BaseTimelineV1(Stream<HoodieInstant> instants, HoodieInstantReader instantReader) {
        this(instants, instantReader, TimelineLayout.fromVersion(TimelineLayoutVersion.LAYOUT_VERSION_1));
    }

    private BaseTimelineV1(Stream<HoodieInstant> instants, HoodieInstantReader instantReader, TimelineLayout layout) {
        super(instants, instantReader, layout.getTimelineFactory(), layout.getInstantComparator(), layout.getInstantGenerator());
    }

    @Deprecated
    public BaseTimelineV1() {
        super(TimelineLayout.fromVersion(TimelineLayoutVersion.LAYOUT_VERSION_1), null);
    }

    @Override
    public HoodieTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "logcompaction", "replacecommit");
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> validActions.contains(s.getAction())), this.getInstantReader());
    }

    @Override
    public HoodieTimeline filterPendingClusteringTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("replacecommit") && !s.isCompleted()).filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i, this.instantGenerator)), this.getInstantReader());
    }

    @Override
    public HoodieTimeline filterPendingReplaceOrClusteringTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("replacecommit") && !s.isCompleted()), this.getInstantReader());
    }

    @Override
    public HoodieTimeline filterPendingReplaceClusteringAndCompactionTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> !s.isCompleted() && (s.getAction().equals("replacecommit") || s.getAction().equals("compaction"))), this.getInstantReader());
    }

    @Override
    public HoodieTimeline getCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit"));
    }

    @Override
    public HoodieTimeline getCommitAndReplaceTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "replacecommit"));
    }

    @Override
    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return TimelineLayoutVersion.LAYOUT_VERSION_1;
    }

    @Override
    public Option<HoodieInstant> getLastClusteringInstant() {
        return Option.fromJavaOptional(this.getCommitsTimeline().filter(s -> s.getAction().equalsIgnoreCase("replacecommit")).getReverseOrderedInstants().filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i, this.instantGenerator)).findFirst());
    }

    @Override
    public Option<HoodieInstant> getFirstPendingClusterInstant() {
        return this.getLastOrFirstPendingClusterInstant(false);
    }

    @Override
    public Option<HoodieInstant> getLastPendingClusterInstant() {
        return this.getLastOrFirstPendingClusterInstant(true);
    }

    private Option<HoodieInstant> getLastOrFirstPendingClusterInstant(boolean isLast) {
        HoodieTimeline replaceTimeline = this.filterPendingReplaceTimeline();
        Stream<HoodieInstant> replaceStream = isLast ? replaceTimeline.getReverseOrderedInstants() : replaceTimeline.getInstantsAsStream();
        return Option.fromJavaOptional(replaceStream.filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i, this.instantGenerator)).findFirst());
    }

    @Override
    public boolean isPendingClusteringInstant(String instantTime) {
        return this.getOrCreatePendingClusteringInstantSet().contains(instantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOrCreatePendingClusteringInstantSet() {
        if (this.pendingClusteringInstants == null) {
            BaseTimelineV1 baseTimelineV1 = this;
            synchronized (baseTimelineV1) {
                if (this.pendingClusteringInstants == null) {
                    List<HoodieInstant> pendingReplaceInstants = this.getCommitsTimeline().filterPendingReplaceTimeline().getInstants();
                    pendingReplaceInstants.stream().collect(Collectors.groupingBy(HoodieInstant::requestedTime)).forEach((timestamp, instants) -> {
                        if (instants.size() > 1) {
                            throw new IllegalStateException("Multiple instants with same timestamp: " + timestamp + " instants: " + instants);
                        }
                    });
                    this.pendingClusteringInstants = pendingReplaceInstants.stream().filter((? super T instant) -> ClusteringUtils.isClusteringInstant(this, instant, this.instantGenerator)).map(HoodieInstant::requestedTime).collect(Collectors.toSet());
                }
            }
        }
        return this.pendingClusteringInstants;
    }
}

