/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerators;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.BaseTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantFileNameGeneratorV2;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveTimelineV2
extends BaseTimelineV2
implements HoodieActiveTimeline {
    public static final Set<String> VALID_EXTENSIONS_IN_ACTIVE_TIMELINE = new HashSet<String>(Arrays.asList(".commit", ".inflight", ".commit.requested", ".deltacommit", ".deltacommit.inflight", ".deltacommit.requested", ".savepoint", ".savepoint.inflight", ".clean", ".clean.requested", ".clean.inflight", INFLIGHT_COMPACTION_EXTENSION, REQUESTED_COMPACTION_EXTENSION, ".restore.requested", ".restore.inflight", ".restore", INFLIGHT_LOG_COMPACTION_EXTENSION, REQUESTED_LOG_COMPACTION_EXTENSION, ".rollback", ".rollback.requested", ".rollback.inflight", ".replacecommit.requested", ".replacecommit.inflight", ".replacecommit", ".indexing.requested", ".indexing.inflight", ".indexing", ".schemacommit.requested", ".schemacommit.inflight", ".schemacommit", ".clustering.requested", ".clustering.inflight"));
    private static final Logger LOG = LoggerFactory.getLogger(ActiveTimelineV2.class);
    protected HoodieTableMetaClient metaClient;
    private final InstantFileNameGenerator instantFileNameGenerator = new InstantFileNameGeneratorV2();

    private ActiveTimelineV2(HoodieTableMetaClient metaClient, Set<String> includedExtensions, boolean applyLayoutFilters) {
        try {
            this.setInstants(metaClient.scanHoodieInstantsFromFileSystem(metaClient.getTimelinePath(), includedExtensions, applyLayoutFilters));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to scan metadata", e);
        }
        this.metaClient = metaClient;
        LOG.info("Loaded instants upto : " + this.lastInstant());
    }

    public ActiveTimelineV2(HoodieTableMetaClient metaClient) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), true);
    }

    public ActiveTimelineV2(HoodieTableMetaClient metaClient, boolean applyLayoutFilter) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), applyLayoutFilter);
    }

    @Deprecated
    public ActiveTimelineV2() {
    }

    @Deprecated
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Set<String> getValidExtensionsInActiveTimeline() {
        return Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE);
    }

    @Override
    public void createCompleteInstant(HoodieInstant instant) {
        LOG.info("Creating a new complete instant " + instant);
        this.createCompleteFileInMetaPath(true, instant, Option.empty());
    }

    @Override
    public void createNewInstant(HoodieInstant instant) {
        LOG.info("Creating a new instant " + instant);
        ValidationUtils.checkArgument((!instant.isCompleted() ? 1 : 0) != 0);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.empty(), false);
    }

    @Override
    public void createRequestedCommitWithReplaceMetadata(String instantTime, String actionType) {
        HoodieInstant instant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, actionType, instantTime);
        LOG.info("Creating a new instant " + instant);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)new HoodieRequestedReplaceMetadata())), false);
    }

    @Override
    public <T> void saveAsComplete(HoodieInstant instant, Option<T> metadata) {
        this.saveAsComplete(true, instant, metadata);
    }

    @Override
    public <T> void saveAsComplete(boolean shouldLock, HoodieInstant instant, Option<T> metadata) {
        LOG.info("Marking instant complete " + instant);
        ValidationUtils.checkArgument((boolean)instant.isInflight(), (String)("Could not mark an already completed instant as complete again " + instant));
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, instant.getAction(), instant.requestedTime());
        this.transitionStateToComplete(shouldLock, instant, commitInstant, metadata);
        LOG.info("Completed " + instant);
    }

    @Override
    public HoodieInstant revertToInflight(HoodieInstant instant) {
        LOG.info("Reverting instant to inflight " + instant);
        HoodieInstant inflight = TimelineUtils.getInflightInstant(instant, this.metaClient);
        this.revertCompleteToInflight(instant, inflight);
        LOG.info("Reverted " + instant + " to inflight " + inflight);
        return inflight;
    }

    @Override
    public void deleteInflight(HoodieInstant instant) {
        ValidationUtils.checkArgument((boolean)instant.isInflight());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deletePending(HoodieInstant instant) {
        ValidationUtils.checkArgument((!instant.isCompleted() ? 1 : 0) != 0);
        this.deleteInstantFile(instant);
    }

    @Override
    public void deleteCompletedRollback(HoodieInstant instant) {
        ValidationUtils.checkArgument((boolean)instant.isCompleted());
        ValidationUtils.checkArgument((boolean)Objects.equals(instant.getAction(), "rollback"));
        this.deleteInstantFile(instant);
    }

    @Override
    public void deleteEmptyInstantIfExists(HoodieInstant instant) {
        ValidationUtils.checkArgument((boolean)this.isEmpty(instant));
        this.deleteInstantFileIfExists(instant);
    }

    @Override
    public void deleteCompactionRequested(HoodieInstant instant) {
        ValidationUtils.checkArgument((boolean)instant.isRequested());
        ValidationUtils.checkArgument((boolean)Objects.equals(instant.getAction(), "compaction"));
        this.deleteInstantFile(instant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteInstantFileIfExists(HoodieInstant instant) {
        LOG.info("Deleting instant " + instant);
        StoragePath commitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        try {
            if (this.metaClient.getStorage().exists(commitFilePath)) {
                boolean result = this.metaClient.getStorage().deleteFile(commitFilePath);
                if (!result) throw new HoodieIOException("Could not delete instant " + instant + " with path " + commitFilePath);
                LOG.info("Removed instant " + instant);
                return;
            } else {
                LOG.warn("The commit " + commitFilePath + " to remove does not exist");
            }
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove commit " + commitFilePath, e);
        }
    }

    protected void deleteInstantFile(HoodieInstant instant) {
        LOG.info("Deleting instant " + instant);
        StoragePath filePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        try {
            boolean result = this.metaClient.getStorage().deleteFile(filePath);
            if (!result) {
                throw new HoodieIOException("Could not delete instant " + instant + " with path " + filePath);
            }
            LOG.info("Removed instant " + instant);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove inflight commit " + filePath, e);
        }
    }

    protected String getInstantFileName(HoodieInstant instant) {
        if (instant.isCompleted() && instant.getCompletionTime() == null) {
            return this.instantFileNameGenerator.getFileName(this.getInstantsAsStream().filter((? super T s) -> s.equals(instant)).findFirst().orElseThrow(() -> new HoodieIOException("Cannot find the instant" + instant)));
        }
        return this.instantFileNameGenerator.getFileName(instant);
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        StoragePath detailPath = this.getInstantFileNamePath(this.getInstantFileName(instant));
        return this.readDataFromPath(detailPath);
    }

    @Override
    public InputStream getContentStream(HoodieInstant instant) {
        StoragePath filePath = this.getInstantFileNamePath(this.getInstantFileName(instant));
        return this.readDataStreamFromPath(filePath);
    }

    @Override
    public HoodieInstantReader getInstantReader() {
        return this;
    }

    @Override
    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidSchema() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> WriteOperationType.canUpdateSchema(((HoodieCommitMetadata)instantCommitMetadataPair.getRight()).getOperationType()) && !StringUtils.isNullOrEmpty((String)((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getMetadata("schema"))).findFirst());
    }

    @Override
    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidData() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> !((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getFileIdAndRelativePaths().isEmpty()).findFirst());
    }

    private Stream<Pair<HoodieInstant, HoodieCommitMetadata>> getCommitMetadataStream() {
        return this.getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().sorted(Comparator.comparing(HoodieInstant::requestedTime).reversed()).map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = this.readCommitMetadata((HoodieInstant)instant);
                return Pair.of(instant, commitMetadata);
            }
            catch (IOException e) {
                throw new HoodieIOException(String.format("Failed to fetch HoodieCommitMetadata for instant (%s)", instant), e);
            }
        });
    }

    @Override
    public Option<byte[]> readCleanerInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(this.getInstantFileNamePath(this.getInstantFileName(instant)));
    }

    @Override
    public Option<byte[]> readCompactionPlanAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new StoragePath(this.metaClient.getTimelinePath(), this.getInstantFileName(instant)));
    }

    @Override
    public HoodieInstant revertInstantFromInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, inflightInstant.getAction(), inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionPendingState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public HoodieInstant revertLogCompactionInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "logcompaction", inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionPendingState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public HoodieInstant transitionCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionLogCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "logcompaction", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionCompactionInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", inflightInstant.requestedTime());
        this.transitionStateToComplete(shouldLock, inflightInstant, commitInstant, Option.of((Object)metadata));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionLogCompactionInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", inflightInstant.requestedTime());
        this.transitionStateToComplete(shouldLock, inflightInstant, commitInstant, Option.of((Object)metadata));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionCleanInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<HoodieCleanMetadata> metadata) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "clean", inflightInstant.requestedTime());
        this.transitionStateToComplete(shouldLock, inflightInstant, commitInstant, metadata);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionCleanRequestedToInflight(HoodieInstant requestedInstant, Option<HoodieCleanerPlan> metadata) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "clean", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflight, metadata);
        return inflight;
    }

    @Override
    public HoodieInstant transitionRollbackInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieRollbackMetadata metadata) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "rollback", inflightInstant.requestedTime());
        this.transitionStateToComplete(shouldLock, inflightInstant, commitInstant, Option.of((Object)((Object)metadata)));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionRollbackRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "rollback", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    @Override
    public HoodieInstant transitionRestoreRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("restore"), (String)("Transition to inflight requested for a restore instant with diff action " + requestedInstant));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested(), (String)("Transition to inflight requested for an instant not in requested state " + requestedInstant));
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "restore", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    @Override
    public <T> HoodieInstant transitionReplaceRequestedToInflight(HoodieInstant requestedInstant, Option<T> metadata) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflightInstant, metadata);
        return inflightInstant;
    }

    @Override
    public <T> HoodieInstant transitionClusterRequestedToInflight(HoodieInstant requestedInstant, Option<T> metadata) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("clustering"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflightInstant, metadata);
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionReplaceInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieReplaceCommitMetadata metadata) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", inflightInstant.requestedTime());
        this.transitionStateToComplete(shouldLock, inflightInstant, commitInstant, Option.of((Object)metadata));
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionClusterInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, HoodieReplaceCommitMetadata metadata) {
        ValidationUtils.checkArgument((boolean)inflightInstant.getAction().equals("clustering"));
        ValidationUtils.checkArgument((boolean)inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", inflightInstant.requestedTime());
        this.transitionStateToComplete(shouldLock, inflightInstant, commitInstant, Option.of((Object)metadata));
        return commitInstant;
    }

    private <T> void transitionPendingState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<T> metadata) {
        this.transitionPendingState(fromInstant, toInstant, metadata, false);
    }

    protected <T> void transitionStateToComplete(boolean shouldLock, HoodieInstant fromInstant, HoodieInstant toInstant, Option<T> metadata) {
        ValidationUtils.checkArgument((boolean)fromInstant.requestedTime().equals(toInstant.requestedTime()), (String)String.format("%s and %s are not consistent when transition state.", fromInstant, toInstant));
        String fromInstantFileName = this.instantFileNameGenerator.getFileName(fromInstant);
        try {
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                this.createFileInMetaPath(fromInstantFileName, metadata, false);
                StoragePath fromInstantPath = this.getInstantFileNamePath(fromInstantFileName);
                HoodieInstant instantWithCompletionTime = this.instantGenerator.createNewInstant(toInstant.getState(), toInstant.getAction(), toInstant.requestedTime(), this.metaClient.createNewInstantTime(false));
                StoragePath toInstantPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instantWithCompletionTime));
                boolean success = this.metaClient.getStorage().rename(fromInstantPath, toInstantPath);
                if (!success) {
                    throw new HoodieIOException("Could not rename " + fromInstantPath + " to " + toInstantPath);
                }
            } else {
                ValidationUtils.checkArgument((boolean)this.metaClient.getStorage().exists(this.getInstantFileNamePath(fromInstantFileName)), (String)("File " + this.getInstantFileNamePath(fromInstantFileName) + " does not exist!"));
                this.createCompleteFileInMetaPath(shouldLock, toInstant, metadata);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete " + fromInstant, e);
        }
    }

    protected <T> void transitionPendingState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<T> metadata, boolean allowRedundantTransitions) {
        ValidationUtils.checkArgument((boolean)fromInstant.requestedTime().equals(toInstant.requestedTime()), (String)String.format("%s and %s are not consistent when transition state.", fromInstant, toInstant));
        String fromInstantFileName = this.instantFileNameGenerator.getFileName(fromInstant);
        String toInstantFileName = this.instantFileNameGenerator.getFileName(toInstant);
        try {
            HoodieStorage storage = this.metaClient.getStorage();
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                this.createFileInMetaPath(fromInstantFileName, metadata, allowRedundantTransitions);
                StoragePath fromInstantPath = this.getInstantFileNamePath(fromInstantFileName);
                StoragePath toInstantPath = this.getInstantFileNamePath(toInstantFileName);
                boolean success = storage.rename(fromInstantPath, toInstantPath);
                if (!success) {
                    throw new HoodieIOException("Could not rename " + fromInstantPath + " to " + toInstantPath);
                }
            } else {
                ValidationUtils.checkArgument((boolean)storage.exists(this.getInstantFileNamePath(fromInstantFileName)), (String)("File " + this.getInstantFileNamePath(fromInstantFileName) + " does not exist!"));
                if (allowRedundantTransitions) {
                    FileIOUtils.createFileInPath((HoodieStorage)storage, (StoragePath)this.getInstantFileNamePath(toInstantFileName), this.getInstantWriter(metadata));
                } else {
                    storage.createImmutableFileInPath(this.getInstantFileNamePath(toInstantFileName), this.getInstantWriter(metadata));
                }
                LOG.info("Create new file for toInstant ?" + this.getInstantFileNamePath(toInstantFileName));
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete " + fromInstant, e);
        }
    }

    protected void revertCompleteToInflight(HoodieInstant completed, HoodieInstant inflight) {
        ValidationUtils.checkArgument((boolean)completed.isCompleted());
        ValidationUtils.checkArgument((boolean)inflight.isInflight());
        ValidationUtils.checkArgument((boolean)completed.requestedTime().equals(inflight.requestedTime()));
        StoragePath inflightFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(inflight));
        StoragePath completedFilePath = this.getInstantFileNamePath(this.getInstantFileName(completed));
        try {
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                boolean success;
                if (!this.metaClient.getStorage().exists(inflightFilePath) && !(success = this.metaClient.getStorage().rename(completedFilePath, inflightFilePath))) {
                    throw new HoodieIOException("Could not rename " + completedFilePath + " to " + inflightFilePath);
                }
            } else {
                StoragePath requestedInstantFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.requestedTime())));
                if (!this.metaClient.getStorage().exists(requestedInstantFilePath)) {
                    this.metaClient.getStorage().create(requestedInstantFilePath, false).close();
                }
                if (!this.metaClient.getStorage().exists(inflightFilePath)) {
                    this.metaClient.getStorage().create(inflightFilePath, false).close();
                }
                boolean success = this.metaClient.getStorage().deleteFile(completedFilePath);
                ValidationUtils.checkArgument((boolean)success, (String)"State Reverting failed");
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete revert " + completed, e);
        }
    }

    private StoragePath getInstantFileNamePath(String fileName) {
        return new StoragePath(fileName.contains("schemacommit") ? this.metaClient.getSchemaFolderName() : this.metaClient.getTimelinePath().toString(), fileName);
    }

    @Override
    public void transitionRequestedToInflight(String commitType, String inFlightInstant) {
        HoodieInstant requested = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, commitType, inFlightInstant);
        this.transitionRequestedToInflight(requested, Option.empty(), false);
    }

    @Override
    public <T> void transitionRequestedToInflight(HoodieInstant requested, Option<T> metadata) {
        this.transitionRequestedToInflight(requested, metadata, false);
    }

    @Override
    public <T> void transitionRequestedToInflight(HoodieInstant requested, Option<T> metadata, boolean allowRedundantTransitions) {
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, requested.getAction(), requested.requestedTime());
        ValidationUtils.checkArgument((boolean)requested.isRequested(), (String)("Instant " + requested + " in wrong state"));
        this.transitionPendingState(requested, inflight, metadata, allowRedundantTransitions);
    }

    @Override
    public void saveToCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata) {
        this.saveToCompactionRequested(instant, metadata, false);
    }

    @Override
    public void saveToCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata, boolean overwrite) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("compaction"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), overwrite);
    }

    @Override
    public void saveToLogCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata) {
        this.saveToLogCompactionRequested(instant, metadata, false);
    }

    @Override
    public void saveToLogCompactionRequested(HoodieInstant instant, HoodieCompactionPlan metadata, boolean overwrite) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("logcompaction"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), overwrite);
    }

    @Override
    public void saveToPendingReplaceCommit(HoodieInstant instant, HoodieRequestedReplaceMetadata metadata) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("replacecommit"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), false);
    }

    @Override
    public void saveToPendingClusterCommit(HoodieInstant instant, HoodieRequestedReplaceMetadata metadata) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("clustering"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), false);
    }

    @Override
    public void saveToCleanRequested(HoodieInstant instant, Option<HoodieCleanerPlan> metadata) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("clean"));
        ValidationUtils.checkArgument((boolean)instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), metadata, false);
    }

    @Override
    public void saveToRollbackRequested(HoodieInstant instant, HoodieRollbackPlan metadata) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("rollback"));
        ValidationUtils.checkArgument((boolean)instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), false);
    }

    @Override
    public void saveToRestoreRequested(HoodieInstant instant, HoodieRestorePlan metadata) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("restore"));
        ValidationUtils.checkArgument((boolean)instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), false);
    }

    @Override
    public HoodieInstant transitionIndexRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument((boolean)requestedInstant.getAction().equals("indexing"), (String)String.format("%s is not equal to %s action", requestedInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument((boolean)requestedInstant.isRequested(), (String)String.format("Instant %s not in requested state", requestedInstant.requestedTime()));
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "indexing", requestedInstant.requestedTime());
        this.transitionPendingState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public void saveToPendingIndexAction(HoodieInstant instant, HoodieIndexPlan metadata) {
        ValidationUtils.checkArgument((boolean)instant.getAction().equals("indexing"), (String)String.format("%s is not equal to %s action", instant.getAction(), "indexing"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.of((Object)((Object)metadata)), false);
    }

    public <T> void createFileInMetaPath(String filename, Option<T> metadata, boolean allowOverwrite) {
        StoragePath fullPath = this.getInstantFileNamePath(filename);
        Option<HoodieInstantWriter> writerOption = TimelineUtils.getHoodieInstantWriterOption(this, metadata);
        if (allowOverwrite || this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(this.metaClient.getTimelinePath()), (StoragePath)fullPath, writerOption);
        } else {
            this.metaClient.getStorage(this.metaClient.getTimelinePath()).createImmutableFileInPath(fullPath, writerOption);
        }
    }

    protected <T> void createCompleteFileInMetaPath(boolean shouldLock, HoodieInstant instant, Option<T> metadata) {
        Option<HoodieInstantWriter> writerOption = TimelineUtils.getHoodieInstantWriterOption(this, metadata);
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator(this.metaClient.getTimeGeneratorConfig(), this.metaClient.getStorageConf());
        timeGenerator.consumeTime(!shouldLock, currentTimeMillis -> {
            String completionTime = TimelineUtils.generateInstantTime(false, timeGenerator);
            String fileName = this.instantFileNameGenerator.getFileName(completionTime, instant);
            StoragePath fullPath = this.getInstantFileNamePath(fileName);
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                FileIOUtils.createFileInPath((HoodieStorage)this.metaClient.getStorage(), (StoragePath)fullPath, (Option)writerOption);
            } else {
                this.metaClient.getStorage().createImmutableFileInPath(fullPath, writerOption);
            }
            LOG.info("Created new file for toInstant ?" + fullPath);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Option<byte[]> readDataFromPath(StoragePath detailPath) {
        try (InputStream is = this.metaClient.getStorage().open(detailPath);){
            Option option = Option.of((Object)FileIOUtils.readAsByteArray((InputStream)is));
            return option;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read commit details from " + detailPath, e);
        }
    }

    protected InputStream readDataStreamFromPath(StoragePath filePath) {
        try {
            return this.metaClient.getStorage().open(filePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read commit details from " + filePath, e);
        }
    }

    @Override
    public HoodieActiveTimeline reload() {
        return new ActiveTimelineV2(this.metaClient);
    }

    @Override
    public void copyInstant(HoodieInstant instant, StoragePath dstDir) {
        StoragePath srcPath = new StoragePath(this.metaClient.getTimelinePath(), this.getInstantFileName(instant));
        StoragePath dstPath = new StoragePath(dstDir, this.getInstantFileName(instant));
        try {
            HoodieStorage storage = this.metaClient.getStorage();
            storage.createDirectory(dstDir);
            FileIOUtils.copy((HoodieStorage)storage, (StoragePath)srcPath, (HoodieStorage)storage, (StoragePath)dstPath, (boolean)false, (boolean)true);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not copy instant from " + srcPath + " to " + dstPath, e);
        }
    }

    @Override
    public Set<String> getValidExtensions() {
        return VALID_EXTENSIONS_IN_ACTIVE_TIMELINE;
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return TimelineUtils.isEmpty(this.metaClient, instant);
    }
}

