/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.model.HoodieLSMTimelineInstant;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ArchivedTimelineLoader;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.LSMTimeline;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.StoragePath;
import org.jetbrains.annotations.Nullable;

public class ArchivedTimelineLoaderV2
implements ArchivedTimelineLoader {
    private static final String INSTANT_TIME_ARCHIVED_META_FIELD = "instantTime";

    @Override
    public void loadInstants(HoodieTableMetaClient metaClient, @Nullable HoodieArchivedTimeline.TimeRangeFilter filter, HoodieArchivedTimeline.LoadMode loadMode, Function<GenericRecord, Boolean> commitsFilter, BiConsumer<String, GenericRecord> recordConsumer) {
        try {
            List<String> fileNames = LSMTimeline.latestSnapshotManifest(metaClient, metaClient.getArchivePath()).getFileNames();
            Schema readSchema = LSMTimeline.getReadSchema(loadMode);
            ((Stream)fileNames.stream().filter(fileName -> filter == null || LSMTimeline.isFileInRange(filter, fileName)).parallel()).forEach(fileName -> {
                try (HoodieAvroFileReader reader = (HoodieAvroFileReader)HoodieIOFactory.getIOFactory(metaClient.getStorage()).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, new StoragePath(metaClient.getArchivePath(), fileName));
                     ClosableIterator<IndexedRecord> iterator = reader.getIndexedRecordIterator(HoodieLSMTimelineInstant.getClassSchema(), readSchema);){
                    while (iterator.hasNext()) {
                        GenericRecord record = (GenericRecord)iterator.next();
                        String instantTime = record.get(INSTANT_TIME_ARCHIVED_META_FIELD).toString();
                        if (filter != null && !filter.isInRange(instantTime) || !((Boolean)commitsFilter.apply(record)).booleanValue()) continue;
                        recordConsumer.accept(instantTime, record);
                    }
                }
                catch (IOException ioException) {
                    throw new HoodieIOException("Error open file reader for path: " + new StoragePath(metaClient.getArchivePath(), fileName));
                }
            });
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + metaClient.getArchivePath(), e);
        }
    }
}

