/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;

public class InstantFileNameGeneratorV2
implements InstantFileNameGenerator {
    @Override
    public TimelineLayoutVersion getLayoutVersion() {
        return TimelineLayoutVersion.LAYOUT_VERSION_2;
    }

    @Override
    public String makeCommitFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".commit"});
    }

    @Override
    public String makeInflightCommitFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".inflight"});
    }

    @Override
    public String makeRequestedCommitFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".commit.requested"});
    }

    @Override
    public String makeCleanerFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".clean"});
    }

    @Override
    public String makeRequestedCleanerFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".clean.requested"});
    }

    @Override
    public String makeInflightCleanerFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".clean.inflight"});
    }

    @Override
    public String makeRollbackFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".rollback"});
    }

    @Override
    public String makeRequestedRollbackFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".rollback.requested"});
    }

    @Override
    public String makeRequestedRestoreFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".restore.requested"});
    }

    @Override
    public String makeInflightRollbackFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".rollback.inflight"});
    }

    @Override
    public String makeInflightSavePointFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".savepoint.inflight"});
    }

    @Override
    public String makeSavePointFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".savepoint"});
    }

    @Override
    public String makeInflightDeltaFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".deltacommit.inflight"});
    }

    @Override
    public String makeRequestedDeltaFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".deltacommit.requested"});
    }

    @Override
    public String makeInflightCompactionFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION});
    }

    @Override
    public String makeRequestedCompactionFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION});
    }

    @Override
    public String makeInflightLogCompactionFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, HoodieTimeline.INFLIGHT_LOG_COMPACTION_EXTENSION});
    }

    @Override
    public String makeRequestedLogCompactionFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, HoodieTimeline.REQUESTED_LOG_COMPACTION_EXTENSION});
    }

    @Override
    public String makeRestoreFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".restore"});
    }

    @Override
    public String makeInflightRestoreFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".restore.inflight"});
    }

    @Override
    public String makeReplaceFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".replacecommit"});
    }

    @Override
    public String makeInflightReplaceFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".replacecommit.inflight"});
    }

    @Override
    public String makeRequestedReplaceFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".replacecommit.requested"});
    }

    @Override
    public String makeRequestedClusteringFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".clustering.requested"});
    }

    @Override
    public String makeInflightClusteringFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".clustering.inflight"});
    }

    @Override
    public String makeDeltaFileName(String instantTime) {
        return instantTime + ".deltacommit";
    }

    @Override
    public String getCommitFromCommitFile(String commitFileName) {
        return commitFileName.split("\\.")[0];
    }

    @Override
    public String makeFileNameAsComplete(String fileName) {
        return fileName.replace(".inflight", "");
    }

    @Override
    public String makeFileNameAsInflight(String fileName) {
        return StringUtils.join((String[])new String[]{fileName, ".inflight"});
    }

    @Override
    public String makeIndexCommitFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".indexing"});
    }

    @Override
    public String makeInflightIndexFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".indexing.inflight"});
    }

    @Override
    public String makeRequestedIndexFileName(String instant) {
        return StringUtils.join((String[])new String[]{instant, ".indexing.requested"});
    }

    @Override
    public String makeSchemaFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".schemacommit"});
    }

    @Override
    public String makeInflightSchemaFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".schemacommit.inflight"});
    }

    @Override
    public String makeRequestSchemaFileName(String instantTime) {
        return StringUtils.join((String[])new String[]{instantTime, ".schemacommit.requested"});
    }

    private String getPendingFileName(HoodieInstant instant) {
        String action = instant.getAction();
        String timestamp = instant.requestedTime();
        if ("commit".equals(action)) {
            if (instant.isInflight()) {
                return this.makeInflightCommitFileName(timestamp);
            }
            if (instant.isRequested()) {
                return this.makeRequestedCommitFileName(timestamp);
            }
        } else if ("clean".equals(action)) {
            if (instant.isInflight()) {
                return this.makeInflightCleanerFileName(timestamp);
            }
            if (instant.isRequested()) {
                return this.makeRequestedCleanerFileName(timestamp);
            }
        } else if ("rollback".equals(action)) {
            if (instant.isInflight()) {
                return this.makeInflightRollbackFileName(timestamp);
            }
            if (instant.isRequested()) {
                return this.makeRequestedRollbackFileName(timestamp);
            }
        } else {
            if ("savepoint".equals(action)) {
                return this.makeInflightSavePointFileName(timestamp);
            }
            if ("deltacommit".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightDeltaFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedDeltaFileName(timestamp);
                }
            } else if ("compaction".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightCompactionFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedCompactionFileName(timestamp);
                }
            } else if ("logcompaction".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightLogCompactionFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedLogCompactionFileName(timestamp);
                }
            } else if ("restore".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightRestoreFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedRestoreFileName(timestamp);
                }
            } else if ("replacecommit".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightReplaceFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedReplaceFileName(timestamp);
                }
            } else if ("clustering".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightClusteringFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedClusteringFileName(timestamp);
                }
            } else if ("indexing".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightIndexFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestedIndexFileName(timestamp);
                }
            } else if ("schemacommit".equals(action)) {
                if (instant.isInflight()) {
                    return this.makeInflightSchemaFileName(timestamp);
                }
                if (instant.isRequested()) {
                    return this.makeRequestSchemaFileName(timestamp);
                }
            }
        }
        throw new IllegalArgumentException("Cannot get file name for unknown action " + action);
    }

    private String getCompleteFileName(HoodieInstant instant, String completionTime) {
        ValidationUtils.checkArgument((!StringUtils.isNullOrEmpty((String)completionTime) ? 1 : 0) != 0, (String)"Completion time should not be empty");
        String timestampWithCompletionTime = instant.isLegacy() ? instant.requestedTime() : instant.requestedTime() + "_" + completionTime;
        switch (instant.getAction()) {
            case "commit": 
            case "compaction": {
                return this.makeCommitFileName(timestampWithCompletionTime);
            }
            case "clean": {
                return this.makeCleanerFileName(timestampWithCompletionTime);
            }
            case "rollback": {
                return this.makeRollbackFileName(timestampWithCompletionTime);
            }
            case "savepoint": {
                return this.makeSavePointFileName(timestampWithCompletionTime);
            }
            case "deltacommit": 
            case "logcompaction": {
                return this.makeDeltaFileName(timestampWithCompletionTime);
            }
            case "restore": {
                return this.makeRestoreFileName(timestampWithCompletionTime);
            }
            case "replacecommit": {
                return this.makeReplaceFileName(timestampWithCompletionTime);
            }
            case "indexing": {
                return this.makeIndexCommitFileName(timestampWithCompletionTime);
            }
            case "schemacommit": {
                return this.makeSchemaFileName(timestampWithCompletionTime);
            }
        }
        throw new IllegalArgumentException("Cannot get complete instant's file name for unknown action " + instant.getAction());
    }

    @Override
    public String getFileName(HoodieInstant instant) {
        if (instant.isCompleted()) {
            return this.getCompleteFileName(instant, instant.getCompletionTime());
        }
        return this.getPendingFileName(instant);
    }

    @Override
    public String getFileName(String completionTime, HoodieInstant instant) {
        ValidationUtils.checkState((boolean)instant.isCompleted());
        return this.getCompleteFileName(instant, completionTime);
    }
}

