/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.PriorityBasedFileSystemView;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.RocksDbBasedFileSystemView;
import org.apache.hudi.common.table.view.SpillableMapBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemViewManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemViewManager.class);
    private static final String HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS = "org.apache.hudi.common.table.view.HoodieMetaserverFileSystemView";
    private final StorageConfiguration<?> conf;
    private final FileSystemViewStorageConfig viewStorageConfig;
    private final Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator;
    private final ConcurrentHashMap<String, SyncableFileSystemView> globalViewMap;

    private FileSystemViewManager(HoodieEngineContext context, FileSystemViewStorageConfig viewStorageConfig, Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator) {
        this.conf = context.getStorageConf();
        this.viewStorageConfig = viewStorageConfig;
        this.viewCreator = viewCreator;
        this.globalViewMap = new ConcurrentHashMap();
    }

    public void clearFileSystemView(String basePath) {
        SyncableFileSystemView view = this.globalViewMap.remove(basePath);
        if (view != null) {
            view.close();
        }
    }

    public SyncableFileSystemView getFileSystemView(String basePath) {
        return this.globalViewMap.computeIfAbsent(basePath, path -> {
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.conf.newInstance()).setBasePath((String)path).build();
            return this.viewCreator.apply(metaClient, this.viewStorageConfig);
        });
    }

    public SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) {
        return this.globalViewMap.computeIfAbsent(metaClient.getBasePath().toString(), path -> this.viewCreator.apply(metaClient, this.viewStorageConfig));
    }

    public void close() {
        if (!this.globalViewMap.isEmpty()) {
            this.globalViewMap.values().forEach(SyncableFileSystemView::close);
            this.globalViewMap.clear();
        }
    }

    private static RocksDbBasedFileSystemView createRocksDBBasedFileSystemView(HoodieEngineContext engineContext, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, boolean metadataTableEnabled, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating RocksDB based view for basePath {}.", (Object)metaClient.getBasePath());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        HoodieTableMetadata tableMetadata = FileSystemViewManager.getTableMetadata(engineContext, metaClient, metadataTableEnabled, metadataCreator);
        return new RocksDbBasedFileSystemView(tableMetadata, metaClient, timeline, viewConf);
    }

    private static SpillableMapBasedFileSystemView createSpillableMapBasedFileSystemView(HoodieEngineContext engineContext, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, HoodieCommonConfig commonConfig, boolean metadataTableEnabled, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating SpillableMap based view for basePath {}.", (Object)metaClient.getBasePath());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        HoodieTableMetadata tableMetadata = FileSystemViewManager.getTableMetadata(engineContext, metaClient, metadataTableEnabled, metadataCreator);
        return new SpillableMapBasedFileSystemView(tableMetadata, metaClient, timeline, viewConf, commonConfig);
    }

    private static HoodieTableFileSystemView createInMemoryFileSystemView(HoodieEngineContext engineContext, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, boolean metadataTableEnabled, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating InMemory based view for basePath {}.", (Object)metaClient.getBasePath());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        HoodieTableMetadata tableMetadata = FileSystemViewManager.getTableMetadata(engineContext, metaClient, metadataTableEnabled, metadataCreator);
        if (metaClient.getMetaserverConfig().isMetaserverEnabled()) {
            return (HoodieTableFileSystemView)ReflectionUtils.loadClass((String)HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS, (Class[])new Class[]{HoodieTableMetaClient.class, HoodieTimeline.class, HoodieMetaserverConfig.class}, (Object[])new Object[]{metaClient, timeline, metaClient.getMetaserverConfig()});
        }
        return new HoodieTableFileSystemView(tableMetadata, metaClient, timeline, viewConf.isIncrementalTimelineSyncEnabled());
    }

    private static HoodieTableMetadata getTableMetadata(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, boolean metadataTableEnabled, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        if (metadataTableEnabled && metaClient.getTableConfig().isMetadataTableAvailable()) {
            ValidationUtils.checkArgument((metadataCreator != null ? 1 : 0) != 0, (String)"Metadata supplier is null. Cannot instantiate metadata file system view");
            return metadataCreator.apply(metaClient);
        }
        return new FileSystemBackedTableMetadata(engineContext, metaClient.getTableConfig(), metaClient.getStorage(), metaClient.getBasePath().toString());
    }

    public static HoodieTableFileSystemView createInMemoryFileSystemView(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieMetadataConfig metadataConfig) {
        return FileSystemViewManager.createInMemoryFileSystemViewWithTimeline(engineContext, metaClient, metadataConfig, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants());
    }

    public static HoodieTableFileSystemView createInMemoryFileSystemViewWithTimeline(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieMetadataConfig metadataConfig, HoodieTimeline timeline) {
        LOG.info("Creating InMemory based view for basePath {}.", (Object)metaClient.getBasePath());
        HoodieTableMetadata tableMetadata = FileSystemViewManager.getTableMetadata(engineContext, metaClient, metadataConfig.isEnabled(), unused -> HoodieTableMetadata.create(engineContext, metaClient.getStorage(), metadataConfig, metaClient.getBasePath().toString()));
        if (metaClient.getMetaserverConfig().isMetaserverEnabled()) {
            return (HoodieTableFileSystemView)ReflectionUtils.loadClass((String)HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS, (Class[])new Class[]{HoodieTableMetaClient.class, HoodieTimeline.class, HoodieMetaserverConfig.class}, (Object[])new Object[]{metaClient, timeline, metaClient.getMetaserverConfig()});
        }
        return new HoodieTableFileSystemView(tableMetadata, metaClient, timeline);
    }

    private static RemoteHoodieTableFileSystemView createRemoteFileSystemView(FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        LOG.info("Creating remote view for basePath {}. Server={}:{}, Timeout={}", new Object[]{metaClient.getBasePath(), viewConf.getRemoteViewServerHost(), viewConf.getRemoteViewServerPort(), viewConf.getRemoteTimelineClientTimeoutSecs()});
        return new RemoteHoodieTableFileSystemView(metaClient, viewConf);
    }

    public static FileSystemViewManager createViewManagerWithTableMetadata(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig) {
        return FileSystemViewManager.createViewManager(context, metadataConfig, config, commonConfig, metaClient -> HoodieTableMetadata.create(context, metaClient.getStorage(), metadataConfig, metaClient.getBasePath().toString(), true));
    }

    public static FileSystemViewManager createViewManager(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig) {
        return FileSystemViewManager.createViewManager(context, metadataConfig, config, commonConfig, null);
    }

    public static FileSystemViewManager createViewManager(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating View Manager with storage type {}.", (Object)config.getStorageType());
        boolean metadataTableEnabled = metadataConfig.isEnabled();
        switch (config.getStorageType()) {
            case EMBEDDED_KV_STORE: {
                LOG.debug("Creating embedded rocks-db based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConf) -> FileSystemViewManager.createRocksDBBasedFileSystemView(context, viewConf, metaClient, metadataTableEnabled, metadataCreator));
            }
            case SPILLABLE_DISK: {
                LOG.debug("Creating Spillable Disk based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConf) -> FileSystemViewManager.createSpillableMapBasedFileSystemView(context, viewConf, metaClient, commonConfig, metadataTableEnabled, metadataCreator));
            }
            case MEMORY: {
                LOG.debug("Creating in-memory based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> FileSystemViewManager.createInMemoryFileSystemView(context, viewConfig, metaClient, metadataTableEnabled, metadataCreator));
            }
            case REMOTE_ONLY: {
                LOG.debug("Creating remote only table view");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> FileSystemViewManager.createRemoteFileSystemView(viewConfig, metaClient));
            }
            case REMOTE_FIRST: {
                LOG.debug("Creating remote first table view");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> {
                    RemoteHoodieTableFileSystemView remoteFileSystemView = FileSystemViewManager.createRemoteFileSystemView(viewConfig, metaClient);
                    SecondaryViewCreator secondaryViewSupplier = new SecondaryViewCreator((FileSystemViewStorageConfig)viewConfig, (HoodieTableMetaClient)metaClient, commonConfig, metadataTableEnabled, metadataCreator);
                    return new PriorityBasedFileSystemView(remoteFileSystemView, secondaryViewSupplier, context);
                });
            }
        }
        throw new IllegalArgumentException("Unknown file system view type :" + (Object)((Object)config.getStorageType()));
    }

    static class SecondaryViewCreator
    implements SerializableFunctionUnchecked<HoodieEngineContext, SyncableFileSystemView> {
        private final FileSystemViewStorageConfig viewConfig;
        private final HoodieTableMetaClient metaClient;
        private final HoodieCommonConfig commonConfig;
        private final boolean metadataTableEnabled;
        private final SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator;

        SecondaryViewCreator(FileSystemViewStorageConfig viewConfig, HoodieTableMetaClient metaClient, HoodieCommonConfig commonConfig, boolean metadataTableEnabled, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
            this.viewConfig = viewConfig;
            this.metaClient = metaClient;
            this.commonConfig = commonConfig;
            this.metadataTableEnabled = metadataTableEnabled;
            this.metadataCreator = metadataCreator;
        }

        @Override
        public SyncableFileSystemView apply(HoodieEngineContext engineContext) {
            switch (this.viewConfig.getSecondaryStorageType()) {
                case MEMORY: {
                    return FileSystemViewManager.createInMemoryFileSystemView(engineContext, this.viewConfig, this.metaClient, this.metadataTableEnabled, this.metadataCreator);
                }
                case EMBEDDED_KV_STORE: {
                    return FileSystemViewManager.createRocksDBBasedFileSystemView(engineContext, this.viewConfig, this.metaClient, this.metadataTableEnabled, this.metadataCreator);
                }
                case SPILLABLE_DISK: {
                    return FileSystemViewManager.createSpillableMapBasedFileSystemView(engineContext, this.viewConfig, this.metaClient, this.commonConfig, this.metadataTableEnabled, this.metadataCreator);
                }
            }
            throw new IllegalArgumentException("Secondary Storage type can only be in-memory or spillable. Was :" + (Object)((Object)this.viewConfig.getSecondaryStorageType()));
        }
    }
}

