/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionPlanMigrator;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionV1MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionV2MigrationHandler;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;

public class CompactionUtils {
    public static final Integer COMPACTION_METADATA_VERSION_1 = CompactionV1MigrationHandler.VERSION;
    public static final Integer COMPACTION_METADATA_VERSION_2;
    public static final Integer LATEST_COMPACTION_METADATA_VERSION;

    public static HoodieCompactionOperation buildFromFileSlice(String partitionPath, FileSlice fileSlice, Option<Function<Pair<String, FileSlice>, Map<String, Double>>> metricsCaptureFunction) {
        HoodieCompactionOperation.Builder builder = HoodieCompactionOperation.newBuilder();
        builder.setPartitionPath(partitionPath);
        builder.setFileId(fileSlice.getFileId());
        builder.setBaseInstantTime(fileSlice.getBaseInstantTime());
        builder.setDeltaFilePaths(fileSlice.getLogFiles().map(lf -> lf.getPath().getName()).collect(Collectors.toList()));
        if (fileSlice.getBaseFile().isPresent()) {
            builder.setDataFilePath(((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
            builder.setBootstrapFilePath((String)((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile().map(BaseFile::getPath).orElse(null));
        }
        if (metricsCaptureFunction.isPresent()) {
            builder.setMetrics((Map)((Function)metricsCaptureFunction.get()).apply(Pair.of(partitionPath, fileSlice)));
        }
        return builder.build();
    }

    public static HoodieCompactionPlan buildFromFileSlices(List<Pair<String, FileSlice>> partitionFileSlicePairs, Option<Map<String, String>> extraMetadata, Option<Function<Pair<String, FileSlice>, Map<String, Double>>> metricsCaptureFunction) {
        HoodieCompactionPlan.Builder builder = HoodieCompactionPlan.newBuilder();
        extraMetadata.ifPresent(builder::setExtraMetadata);
        builder.setOperations(partitionFileSlicePairs.stream().map(pfPair -> CompactionUtils.buildFromFileSlice((String)pfPair.getKey(), (FileSlice)pfPair.getValue(), metricsCaptureFunction)).collect(Collectors.toList()));
        builder.setVersion(LATEST_COMPACTION_METADATA_VERSION);
        return builder.build();
    }

    public static HoodieCompactionOperation buildHoodieCompactionOperation(CompactionOperation op) {
        return HoodieCompactionOperation.newBuilder().setFileId(op.getFileId()).setBaseInstantTime(op.getBaseInstantTime()).setPartitionPath(op.getPartitionPath()).setBootstrapFilePath((String)op.getBootstrapFilePath().orElse(null)).setDataFilePath(op.getDataFileName().isPresent() ? (String)op.getDataFileName().get() : null).setDeltaFilePaths(op.getDeltaFileNames()).setMetrics(op.getMetrics()).build();
    }

    public static CompactionOperation buildCompactionOperation(HoodieCompactionOperation hc) {
        return CompactionOperation.convertFromAvroRecordInstance(hc);
    }

    public static List<Pair<HoodieInstant, HoodieCompactionPlan>> getAllPendingCompactionPlans(HoodieTableMetaClient metaClient) {
        Function<HoodieTableMetaClient, HoodieTimeline> getFilteredTimelineByActionType = hoodieTableMetaClient -> hoodieTableMetaClient.getActiveTimeline().filterPendingCompactionTimeline();
        Function<String, HoodieInstant> requestedInstantSupplier = metaClient.getInstantGenerator()::getCompactionRequestedInstant;
        return CompactionUtils.getCompactionPlansByTimeline(metaClient, getFilteredTimelineByActionType, requestedInstantSupplier);
    }

    public static List<Pair<HoodieInstant, HoodieCompactionPlan>> getAllPendingLogCompactionPlans(HoodieTableMetaClient metaClient) {
        Function<HoodieTableMetaClient, HoodieTimeline> filteredTimelineSupplier = hoodieTableMetaClient -> hoodieTableMetaClient.getActiveTimeline().filterPendingLogCompactionTimeline();
        Function<String, HoodieInstant> requestedInstantSupplier = metaClient.getInstantGenerator()::getLogCompactionRequestedInstant;
        return CompactionUtils.getCompactionPlansByTimeline(metaClient, filteredTimelineSupplier, requestedInstantSupplier);
    }

    private static List<Pair<HoodieInstant, HoodieCompactionPlan>> getCompactionPlansByTimeline(HoodieTableMetaClient metaClient, Function<HoodieTableMetaClient, HoodieTimeline> filteredTimelineSupplier, Function<String, HoodieInstant> requestedInstantWrapper) {
        List<HoodieInstant> filteredInstants = filteredTimelineSupplier.apply(metaClient).getInstants();
        return filteredInstants.stream().map(instant -> Pair.of(instant, CompactionUtils.getCompactionPlan(metaClient, (HoodieInstant)requestedInstantWrapper.apply(instant.requestedTime())))).collect(Collectors.toList());
    }

    public static HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, String compactionInstant) {
        HoodieInstant compactionRequestedInstant = metaClient.getInstantGenerator().getCompactionRequestedInstant(compactionInstant);
        return CompactionUtils.getCompactionPlan(metaClient, compactionRequestedInstant);
    }

    public static HoodieCompactionPlan getLogCompactionPlan(HoodieTableMetaClient metaClient, String logCompactionInstant) {
        HoodieInstant logCompactionRequestedInstant = metaClient.getInstantGenerator().getLogCompactionRequestedInstant(logCompactionInstant);
        return CompactionUtils.getCompactionPlan(metaClient, logCompactionRequestedInstant);
    }

    public static HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, HoodieInstant requestedInstant) {
        return CompactionUtils.getCompactionPlanInternal(metaClient, () -> metaClient.getActiveTimeline().readCompactionPlan(requestedInstant));
    }

    public static HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, InputStream planContent) {
        return CompactionUtils.getCompactionPlanInternal(metaClient, () -> TimelineMetadataUtils.deserializeAvroMetadata(planContent, HoodieCompactionPlan.class));
    }

    private static HoodieCompactionPlan getCompactionPlanInternal(HoodieTableMetaClient metaClient, ThrowingSupplier<HoodieCompactionPlan, IOException> planSupplier) {
        CompactionPlanMigrator migrator = new CompactionPlanMigrator(metaClient);
        try {
            HoodieCompactionPlan compactionPlan = planSupplier.get();
            return migrator.upgradeToLatest(compactionPlan, compactionPlan.getVersion());
        }
        catch (IOException e) {
            throw new HoodieException((Throwable)e);
        }
    }

    public static Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> getAllPendingCompactionOperations(HoodieTableMetaClient metaClient) {
        List<Pair<HoodieInstant, HoodieCompactionPlan>> pendingCompactionPlanWithInstants = CompactionUtils.getAllPendingCompactionPlans(metaClient);
        return CompactionUtils.getAllPendingCompactionOperationsInPendingCompactionPlans(pendingCompactionPlanWithInstants);
    }

    public static Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> getAllPendingLogCompactionOperations(HoodieTableMetaClient metaClient) {
        List<Pair<HoodieInstant, HoodieCompactionPlan>> pendingLogCompactionPlanWithInstants = CompactionUtils.getAllPendingLogCompactionPlans(metaClient);
        return CompactionUtils.getAllPendingCompactionOperationsInPendingCompactionPlans(pendingLogCompactionPlanWithInstants);
    }

    public static Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> getAllPendingCompactionOperationsInPendingCompactionPlans(List<Pair<HoodieInstant, HoodieCompactionPlan>> pendingLogCompactionPlanWithInstants) {
        HashMap<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> fgIdToPendingCompactionsWithInstantMap = new HashMap<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>>();
        pendingLogCompactionPlanWithInstants.stream().flatMap(instantPlanPair -> CompactionUtils.getPendingCompactionOperations((HoodieInstant)instantPlanPair.getKey(), (HoodieCompactionPlan)((Object)((Object)instantPlanPair.getValue())))).forEach(pair -> {
            HoodieCompactionOperation anotherOperation;
            HoodieCompactionOperation operation;
            if (fgIdToPendingCompactionsWithInstantMap.containsKey(pair.getKey()) && !(operation = (HoodieCompactionOperation)((Object)((Object)((Pair)pair.getValue()).getValue()))).equals((Object)(anotherOperation = (HoodieCompactionOperation)((Object)((Object)((Pair)fgIdToPendingCompactionsWithInstantMap.get(pair.getKey())).getValue()))))) {
                String msg = "Hudi File Id (" + pair.getKey() + ") has more than 1 pending operation. Instants: " + pair.getValue() + ", " + fgIdToPendingCompactionsWithInstantMap.get(pair.getKey());
                throw new IllegalStateException(msg);
            }
            fgIdToPendingCompactionsWithInstantMap.put((HoodieFileGroupId)pair.getKey(), (Pair<String, HoodieCompactionOperation>)pair.getValue());
        });
        return fgIdToPendingCompactionsWithInstantMap;
    }

    public static Stream<Pair<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>>> getPendingCompactionOperations(HoodieInstant instant, HoodieCompactionPlan compactionPlan) {
        List<HoodieCompactionOperation> ops = compactionPlan.getOperations();
        if (null != ops) {
            return ops.stream().map(op -> Pair.of(new HoodieFileGroupId(op.getPartitionPath(), op.getFileId()), Pair.of(instant.requestedTime(), op)));
        }
        return Stream.empty();
    }

    public static List<HoodieInstant> getPendingCompactionInstantTimes(HoodieTableMetaClient metaClient) {
        return metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants();
    }

    public static Option<Pair<HoodieTimeline, HoodieInstant>> getCompletedDeltaCommitsSinceLatestCompaction(HoodieActiveTimeline activeTimeline) {
        return CompactionUtils.getDeltaCommitsSinceLatestCompaction(activeTimeline).map(pair -> Pair.of(((HoodieTimeline)pair.getLeft()).filterCompletedInstants(), pair.getRight()));
    }

    public static Option<Pair<HoodieTimeline, HoodieInstant>> getDeltaCommitsSinceLatestCompaction(HoodieActiveTimeline activeTimeline) {
        Option<HoodieInstant> lastCompaction = activeTimeline.getCommitTimeline().filterCompletedInstants().lastInstant();
        HoodieTimeline deltaCommits = activeTimeline.getDeltaCommitTimeline();
        if (lastCompaction.isPresent()) {
            HoodieInstant latestInstant = (HoodieInstant)lastCompaction.get();
            return Option.of(Pair.of(deltaCommits.findInstantsModifiedAfterByCompletionTime(latestInstant.requestedTime()), latestInstant));
        }
        if (deltaCommits.countInstants() > 0) {
            HoodieInstant latestInstant = (HoodieInstant)deltaCommits.firstInstant().get();
            return Option.of(Pair.of(deltaCommits, latestInstant));
        }
        return Option.empty();
    }

    public static Option<Pair<HoodieTimeline, HoodieInstant>> getDeltaCommitsSinceLatestCompactionRequest(HoodieActiveTimeline activeTimeline) {
        Option<HoodieInstant> lastCompaction = activeTimeline.getCommitTimeline().filterCompletedInstants().lastInstant();
        Option<HoodieInstant> lastRequestCompaction = activeTimeline.getAllCommitsTimeline().filterPendingCompactionTimeline().lastInstant();
        if (lastRequestCompaction.isPresent()) {
            lastCompaction = lastRequestCompaction;
        }
        HoodieTimeline deltaCommits = activeTimeline.getDeltaCommitTimeline();
        if (lastCompaction.isPresent()) {
            HoodieInstant latestInstant = (HoodieInstant)lastCompaction.get();
            return Option.of(Pair.of(deltaCommits.findInstantsAfter(latestInstant.requestedTime(), Integer.MAX_VALUE), lastCompaction.get()));
        }
        if (deltaCommits.countInstants() > 0) {
            HoodieInstant latestInstant = (HoodieInstant)deltaCommits.firstInstant().get();
            return Option.of(Pair.of(deltaCommits.findInstantsAfterOrEquals(latestInstant.requestedTime(), Integer.MAX_VALUE), latestInstant));
        }
        return Option.empty();
    }

    public static Option<HoodieInstant> getEarliestInstantToRetainForCompaction(HoodieActiveTimeline activeTimeline, int maxDeltaCommits) {
        Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfoOption = CompactionUtils.getDeltaCommitsSinceLatestCompaction(activeTimeline);
        if (deltaCommitsInfoOption.isPresent()) {
            Pair deltaCommitsInfo = (Pair)deltaCommitsInfoOption.get();
            HoodieTimeline deltaCommitTimeline = (HoodieTimeline)deltaCommitsInfo.getLeft();
            int numDeltaCommits = deltaCommitTimeline.countInstants();
            if (numDeltaCommits < maxDeltaCommits) {
                return Option.of(deltaCommitsInfo.getRight());
            }
            List instants = deltaCommitTimeline.getInstantsAsStream().limit(numDeltaCommits - maxDeltaCommits + 1).collect(Collectors.toList());
            return Option.of(instants.get(instants.size() - 1));
        }
        return Option.empty();
    }

    static {
        LATEST_COMPACTION_METADATA_VERSION = COMPACTION_METADATA_VERSION_2 = CompactionV2MigrationHandler.VERSION;
    }

    @FunctionalInterface
    private static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

