/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import javax.annotation.Nonnull;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;

public abstract class Either<L, R> {
    @Nonnull
    protected abstract Object getValue();

    public final boolean isLeft() {
        return this instanceof EitherLeft;
    }

    public final boolean isRight() {
        return this instanceof EitherRight;
    }

    public R asRight() {
        ValidationUtils.checkArgument((boolean)this.isRight(), (String)"Trying to access non-existent value of Either");
        EitherRight right = (EitherRight)TypeUtils.unsafeCast(this);
        return right.getValue();
    }

    public L asLeft() {
        ValidationUtils.checkArgument((boolean)this.isLeft(), (String)"Trying to access non-existent value of Either");
        EitherLeft left = (EitherLeft)TypeUtils.unsafeCast(this);
        return left.getValue();
    }

    public static <L, R> Either<L, R> right(R right) {
        return new EitherRight(right);
    }

    public static <L, R> Either<L, R> left(L left) {
        return new EitherLeft(left);
    }

    public static class EitherLeft<L, R>
    extends Either<L, R> {
        private final L value;

        private EitherLeft(@Nonnull L value) {
            this.value = value;
        }

        @Override
        @Nonnull
        protected L getValue() {
            return this.value;
        }
    }

    public static class EitherRight<L, R>
    extends Either<L, R> {
        private final R value;

        private EitherRight(@Nonnull R right) {
            this.value = right;
        }

        @Override
        @Nonnull
        protected R getValue() {
            return this.value;
        }
    }
}

