/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LocalAvroSchemaCache
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAvroSchemaCache.class);
    private final Map<Integer, Schema> versionIdToSchema = new HashMap<Integer, Schema>();
    private final Map<Schema, Integer> schemaToVersionId = new HashMap<Schema, Integer>();
    private int nextVersionId = 0;

    private LocalAvroSchemaCache() {
    }

    public static LocalAvroSchemaCache getInstance() {
        return new LocalAvroSchemaCache();
    }

    public Integer cacheSchema(Schema schema) {
        Integer versionId = this.schemaToVersionId.get(schema);
        if (versionId == null) {
            versionId = this.nextVersionId++;
            this.schemaToVersionId.put(schema, versionId);
            this.versionIdToSchema.put(versionId, schema);
        }
        return versionId;
    }

    public Option<Schema> getSchema(Integer versionId) {
        return Option.ofNullable((Object)this.versionIdToSchema.get(versionId));
    }

    @Override
    public void close() {
        this.schemaToVersionId.clear();
        this.versionIdToSchema.clear();
    }
}

