/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.exception.HoodieException;

public class NetworkUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getHostname() {
        InetAddress localAddress;
        Object object;
        try {
            DatagramSocket s = new DatagramSocket();
            object = null;
            try {
                s.connect(InetAddress.getByName("8.8.8.8"), 10002);
                localAddress = s.getLocalAddress();
                if (NetworkUtils.validAddress(localAddress)) {
                    String string = localAddress.getHostAddress();
                    return string;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (s != null) {
                    if (object != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new HoodieException("Unable to find server port", (Throwable)e);
        }
        try {
            NetworkInterface ni;
            List addresses;
            ArrayList<NetworkInterface> activeNetworkIFs = Collections.list(NetworkInterface.getNetworkInterfaces());
            Collections.reverse(activeNetworkIFs);
            object = activeNetworkIFs.iterator();
            do {
                if (!object.hasNext()) return localAddress.getHostAddress();
            } while ((addresses = Collections.list((ni = (NetworkInterface)object.next()).getInetAddresses()).stream().filter(NetworkUtils::validAddress).collect(Collectors.toList())).size() <= 0);
            InetAddress address = addresses.stream().filter(addr -> addr instanceof Inet4Address).findAny().orElse((InetAddress)addresses.get(0));
            try {
                return InetAddress.getByAddress(address.getAddress()).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new HoodieException("Unable to fetch raw IP address for: " + address);
            }
        }
        catch (SocketException e) {
            throw new HoodieException("Unable to find server port", (Throwable)e);
        }
    }

    private static boolean validAddress(InetAddress address) {
        return !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
    }
}

