/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.util.BufferedRandomAccessFile;
import org.apache.hudi.common.util.collection.BitCaskDiskMap;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyFileIterable<T, R>
implements Iterable<R> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyFileIterable.class);
    private final String filePath;
    private final Map<T, BitCaskDiskMap.ValueMetadata> inMemoryMetadataOfSpilledData;
    private final boolean isCompressionEnabled;
    private final CustomSerializer<R> serializer;
    private transient Thread shutdownThread = null;

    public LazyFileIterable(String filePath, Map<T, BitCaskDiskMap.ValueMetadata> map, CustomSerializer<R> serializer, boolean isCompressionEnabled) {
        this.filePath = filePath;
        this.inMemoryMetadataOfSpilledData = map;
        this.isCompressionEnabled = isCompressionEnabled;
        this.serializer = serializer;
    }

    @Override
    public ClosableIterator<R> iterator() {
        try {
            return new LazyFileIterator<T, R>(this.filePath, this.inMemoryMetadataOfSpilledData, this.serializer);
        }
        catch (IOException io) {
            throw new HoodieException("Unable to initialize iterator for file on disk", (Throwable)io);
        }
    }

    public class LazyFileIterator<T, R>
    implements ClosableIterator<R> {
        private final String filePath;
        private BufferedRandomAccessFile readOnlyFileHandle;
        private final Iterator<Map.Entry<T, BitCaskDiskMap.ValueMetadata>> metadataIterator;
        private final CustomSerializer<R> serializer;

        public LazyFileIterator(String filePath, Map<T, BitCaskDiskMap.ValueMetadata> map, CustomSerializer<R> serializer) throws IOException {
            this.filePath = filePath;
            this.readOnlyFileHandle = new BufferedRandomAccessFile(filePath, "r", 131072);
            this.serializer = serializer;
            this.readOnlyFileHandle.seek(0L);
            this.metadataIterator = map.entrySet().stream().sorted((o1, o2) -> ((BitCaskDiskMap.ValueMetadata)o1.getValue()).getOffsetOfValue().compareTo(((BitCaskDiskMap.ValueMetadata)o2.getValue()).getOffsetOfValue())).collect(Collectors.toList()).iterator();
            this.addShutdownHook();
        }

        @Override
        public boolean hasNext() {
            boolean available = this.metadataIterator.hasNext();
            if (!available) {
                this.close();
            }
            return available;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("next() called on EOF'ed stream. File :" + this.filePath);
            }
            Map.Entry<T, BitCaskDiskMap.ValueMetadata> entry = this.metadataIterator.next();
            return BitCaskDiskMap.get(entry.getValue(), this.readOnlyFileHandle, this.serializer, LazyFileIterable.this.isCompressionEnabled);
        }

        @Override
        public void remove() {
            this.metadataIterator.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super R> action) {
            action.accept(this.next());
        }

        @Override
        public void close() {
            this.closeHandle();
            Runtime.getRuntime().removeShutdownHook(LazyFileIterable.this.shutdownThread);
        }

        private void closeHandle() {
            if (this.readOnlyFileHandle != null) {
                try {
                    this.readOnlyFileHandle.close();
                    this.readOnlyFileHandle = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void addShutdownHook() {
            LazyFileIterable.this.shutdownThread = new Thread(() -> {
                LOG.warn("Failed to properly close LazyFileIterable in application.");
                this.closeHandle();
            });
            Runtime.getRuntime().addShutdownHook(LazyFileIterable.this.shutdownThread);
        }
    }
}

