/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.ByteArraySeekableDataInputStream;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileUtils;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieNativeAvroHFileReader
extends HoodieAvroHFileReaderImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieNativeAvroHFileReader.class);
    private static final Set<String> PRELOADED_META_INFO_KEYS = new HashSet<String>(Arrays.asList("minRecordKey", "maxRecordKey", "schema"));
    private final HoodieStorage storage;
    private final Option<StoragePath> path;
    private final Option<byte[]> bytesContent;
    private final Map<String, byte[]> metaInfoMap;
    private final Lazy<Schema> schema;
    private boolean isMetaInfoLoaded = false;
    private long numKeyValueEntries = -1L;

    public HoodieNativeAvroHFileReader(HoodieStorage storage, StoragePath path, Option<Schema> schemaOption) {
        this.storage = storage;
        this.path = Option.of((Object)path);
        this.bytesContent = Option.empty();
        this.metaInfoMap = new HashMap<String, byte[]>();
        this.schema = (Lazy)schemaOption.map(Lazy::eagerly).orElseGet(() -> Lazy.lazily(this::fetchSchema));
    }

    public HoodieNativeAvroHFileReader(HoodieStorage storage, byte[] content, Option<Schema> schemaOption) {
        this.storage = storage;
        this.path = Option.empty();
        this.bytesContent = Option.of((Object)content);
        this.metaInfoMap = new HashMap<String, byte[]>();
        this.schema = (Lazy)schemaOption.map(Lazy::eagerly).orElseGet(() -> Lazy.lazily(this::fetchSchema));
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        if (!Objects.equals(readerSchema, requestedSchema)) {
            throw new UnsupportedOperationException("Schema projections are not supported in HFile reader");
        }
        HFileReader reader = this.newHFileReader();
        return new RecordIterator(reader, this.getSchema(), readerSchema);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        try {
            return new String[]{StringUtils.fromUTF8Bytes((byte[])this.getHFileMetaInfoFromCache("minRecordKey")), StringUtils.fromUTF8Bytes((byte[])this.getHFileMetaInfoFromCache("maxRecordKey"))};
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot read min and max record keys from HFile.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BloomFilter readBloomFilter() {
        try (HFileReader reader = this.newHFileReader();){
            ByteBuffer byteBuffer = (ByteBuffer)reader.getMetaBlock("bloomFilter").get();
            BloomFilter bloomFilter = BloomFilterFactory.fromByteBuffer(byteBuffer, StringUtils.fromUTF8Bytes((byte[])((byte[])reader.getMetaInfo(new UTF8StringKey("bloomFilterTypeCode")).get())));
            return bloomFilter;
        }
        catch (IOException e) {
            throw new HoodieException("Could not read bloom filter from " + this.path, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Pair<String, Long>> filterRowKeys(Set<String> candidateRowKeys) {
        try (HFileReader reader = this.newHFileReader();){
            reader.seekTo();
            Set<Pair<String, Long>> set = new TreeSet<String>(candidateRowKeys).stream().filter(k -> {
                try {
                    return reader.seekTo((Key)new UTF8StringKey(k)) == 0;
                }
                catch (IOException e) {
                    LOG.error("Failed to check key availability: " + k);
                    return false;
                }
            }).map(key -> Pair.of(key, -1L)).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to filter row keys in HFiles", e);
        }
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        final HFileReader reader = this.newHFileReader();
        return new ClosableIterator<String>(){

            @Override
            public boolean hasNext() {
                try {
                    return reader.next();
                }
                catch (IOException e) {
                    throw new HoodieException("Error while scanning for keys", (Throwable)e);
                }
            }

            @Override
            public String next() {
                try {
                    return ((KeyValue)reader.getKeyValue().get()).getKey().getContentInString();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new HoodieIOException("Error closing the HFile reader", e);
                }
            }
        };
    }

    @Override
    public Schema getSchema() {
        return this.schema.get();
    }

    @Override
    public void close() {
        this.isMetaInfoLoaded = false;
        this.metaInfoMap.clear();
    }

    @Override
    public long getTotalRecords() {
        try {
            this.loadAllMetaInfoIntoCacheIfNeeded();
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot get the number of entries from HFile", e);
        }
        ValidationUtils.checkArgument((this.numKeyValueEntries >= 0L ? 1 : 0) != 0, (String)"Number of entries in HFile must be >= 0");
        return this.numKeyValueEntries;
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeysIterator(List<String> sortedKeys, Schema schema) throws IOException {
        HFileReader reader = this.newHFileReader();
        RecordByKeyIterator iterator = new RecordByKeyIterator(reader, sortedKeys, this.getSchema(), schema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema schema) throws IOException {
        HFileReader reader = this.newHFileReader();
        RecordByKeyPrefixIterator iterator = new RecordByKeyPrefixIterator(reader, sortedKeyPrefixes, this.getSchema(), schema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    private Schema fetchSchema() {
        try {
            return new Schema.Parser().parse(StringUtils.fromUTF8Bytes((byte[])this.getHFileMetaInfoFromCache("schema")));
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read schema from HFile", e);
        }
    }

    private static GenericRecord getRecordFromKeyValue(KeyValue keyValue, Schema writerSchema, Schema readerSchema) throws IOException {
        byte[] bytes = keyValue.getBytes();
        return HoodieNativeAvroHFileReader.deserialize(bytes, keyValue.getKeyContentOffset(), keyValue.getKeyContentLength(), bytes, keyValue.getValueOffset(), keyValue.getValueLength(), writerSchema, readerSchema);
    }

    private byte[] getHFileMetaInfoFromCache(String key) throws IOException {
        if (!PRELOADED_META_INFO_KEYS.contains(key)) {
            throw new IllegalStateException("HoodieNativeAvroHFileReader#getHFileMetaInfoFromCache should only be called on supported meta info keys; this key is not supported: " + key);
        }
        this.loadAllMetaInfoIntoCacheIfNeeded();
        return this.metaInfoMap.get(key);
    }

    private synchronized void loadAllMetaInfoIntoCacheIfNeeded() throws IOException {
        if (!this.isMetaInfoLoaded) {
            try (HFileReader reader = this.newHFileReader();){
                this.numKeyValueEntries = reader.getNumKeyValueEntries();
                for (String metaInfoKey : PRELOADED_META_INFO_KEYS) {
                    Option metaInfo = reader.getMetaInfo(new UTF8StringKey(metaInfoKey));
                    if (!metaInfo.isPresent()) continue;
                    this.metaInfoMap.put(metaInfoKey, (byte[])metaInfo.get());
                }
                this.isMetaInfoLoaded = true;
            }
            catch (Exception e) {
                throw new IOException("Unable to construct HFile reader", e);
            }
        }
    }

    private HFileReader newHFileReader() throws IOException {
        SeekableDataInputStream inputStream;
        long fileSize;
        if (this.path.isPresent()) {
            fileSize = this.storage.getPathInfo((StoragePath)this.path.get()).getLength();
            inputStream = this.storage.openSeekable((StoragePath)this.path.get(), false);
        } else {
            fileSize = ((byte[])this.bytesContent.get()).length;
            inputStream = new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream((byte[])this.bytesContent.get()));
        }
        return new HFileReaderImpl(inputStream, fileSize);
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> sortedKeys, Schema readerSchema) throws IOException {
        HFileReader reader = this.newHFileReader();
        return new RecordByKeyIterator(reader, sortedKeys, this.getSchema(), this.schema.get());
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema readerSchema) throws IOException {
        HFileReader reader = this.newHFileReader();
        return new RecordByKeyPrefixIterator(reader, sortedKeyPrefixes, this.getSchema(), readerSchema);
    }

    private static class RecordByKeyPrefixIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> sortedKeyPrefixesIterator;
        private Iterator<IndexedRecord> recordsIterator;
        private final HFileReader reader;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;
        private boolean isFirstKeyPrefix = true;

        RecordByKeyPrefixIterator(HFileReader reader, List<String> sortedKeyPrefixes, Schema writerSchema, Schema readerSchema) throws IOException {
            this.sortedKeyPrefixesIterator = sortedKeyPrefixes.iterator();
            this.reader = reader;
            this.reader.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.recordsIterator != null && this.recordsIterator.hasNext()) {
                        this.next = this.recordsIterator.next();
                        return true;
                    }
                    if (!this.sortedKeyPrefixesIterator.hasNext()) break;
                    this.recordsIterator = RecordByKeyPrefixIterator.getRecordByKeyPrefixIteratorInternal(this.reader, this.isFirstKeyPrefix, this.sortedKeyPrefixesIterator.next(), this.writerSchema, this.readerSchema);
                    this.isFirstKeyPrefix = false;
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to read next record from HFile", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the HFile reader and scanner", e);
            }
        }

        private static Iterator<IndexedRecord> getRecordByKeyPrefixIteratorInternal(final HFileReader reader, boolean isFirstKeyPrefix, String keyPrefix, final Schema writerSchema, final Schema readerSchema) throws IOException {
            final UTF8StringKey lookUpKeyPrefix = new UTF8StringKey(keyPrefix);
            if (!isFirstKeyPrefix) {
                Option keyValue = reader.getKeyValue();
                if (!keyValue.isPresent()) {
                    return Collections.emptyIterator();
                }
                if (!HFileUtils.isPrefixOfKey((Key)lookUpKeyPrefix, (Key)((KeyValue)keyValue.get()).getKey())) {
                    if (lookUpKeyPrefix.compareTo(((KeyValue)keyValue.get()).getKey()) < 0) {
                        return Collections.emptyIterator();
                    }
                    if (reader.seekTo((Key)lookUpKeyPrefix) >= 1 && !reader.next()) {
                        return Collections.emptyIterator();
                    }
                }
            } else if (reader.seekTo((Key)lookUpKeyPrefix) >= 1 && !reader.next()) {
                return Collections.emptyIterator();
            }
            class KeyPrefixIterator
            implements Iterator<IndexedRecord> {
                private IndexedRecord next = null;
                private boolean eof = false;

                KeyPrefixIterator() {
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.eof) {
                        return false;
                    }
                    try {
                        KeyValue keyValue = (KeyValue)reader.getKeyValue().get();
                        if (!HFileUtils.isPrefixOfKey((Key)lookUpKeyPrefix, (Key)keyValue.getKey())) {
                            return false;
                        }
                        byte[] bytes = keyValue.getBytes();
                        this.next = HoodieAvroHFileReaderImplBase.deserialize(bytes, keyValue.getKeyContentOffset(), keyValue.getKeyContentLength(), bytes, keyValue.getValueOffset(), keyValue.getValueLength(), writerSchema, readerSchema);
                        this.eof = !reader.next();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("Failed to deserialize payload", e);
                    }
                    return true;
                }

                @Override
                public IndexedRecord next() {
                    IndexedRecord next = this.next;
                    this.next = null;
                    return next;
                }
            }
            return new KeyPrefixIterator();
        }
    }

    private static class RecordByKeyIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> sortedKeyIterator;
        private final HFileReader reader;
        private final Schema readerSchema;
        private final Schema writerSchema;
        private IndexedRecord next = null;

        RecordByKeyIterator(HFileReader reader, List<String> sortedKeys, Schema writerSchema, Schema readerSchema) throws IOException {
            this.sortedKeyIterator = sortedKeys.iterator();
            this.reader = reader;
            this.reader.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next != null) {
                    return true;
                }
                while (this.sortedKeyIterator.hasNext()) {
                    UTF8StringKey key = new UTF8StringKey(this.sortedKeyIterator.next());
                    if (this.reader.seekTo((Key)key) != 0) continue;
                    KeyValue keyValue = (KeyValue)this.reader.getKeyValue().get();
                    this.next = HoodieAvroHFileReaderImplBase.deserialize(key.getBytes(), key.getContentOffset(), key.getContentLength(), keyValue.getBytes(), keyValue.getValueOffset(), keyValue.getValueLength(), this.writerSchema, this.readerSchema);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to read next record from HFile ", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the HFile reader", e);
            }
        }
    }

    private static class RecordIterator
    implements ClosableIterator<IndexedRecord> {
        private final HFileReader reader;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;
        private boolean eof = false;

        RecordIterator(HFileReader reader, Schema writerSchema, Schema readerSchema) {
            this.reader = reader;
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.eof) {
                    return false;
                }
                if (this.next != null) {
                    return true;
                }
                boolean hasRecords = !this.reader.isSeeked() ? this.reader.seekTo() : this.reader.next();
                if (!hasRecords) {
                    this.eof = true;
                    return false;
                }
                this.next = HoodieNativeAvroHFileReader.getRecordFromKeyValue((KeyValue)this.reader.getKeyValue().get(), this.writerSchema, this.readerSchema);
                return true;
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to read next record from hfile ", io);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the HFile reader", e);
            }
        }
    }
}

