/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.lang.reflect.Field;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class BaseHoodieTableFileIndexTest {
    @Test
    public void testGetMetadataConfigReturnsFieldValue() throws Exception {
        BaseHoodieTableFileIndex fileIndex = (BaseHoodieTableFileIndex)Mockito.mock(BaseHoodieTableFileIndex.class, (Answer)Mockito.CALLS_REAL_METHODS);
        HoodieMetadataConfig testConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexBloomFilter(true).withMetadataIndexColumnStats(true).build();
        Field metadataConfigField = BaseHoodieTableFileIndex.class.getDeclaredField("metadataConfig");
        metadataConfigField.setAccessible(true);
        metadataConfigField.set(fileIndex, testConfig);
        HoodieMetadataConfig result = fileIndex.getMetadataConfig();
        Assertions.assertNotNull((Object)result, (String)"Metadata config should not be null");
        Assertions.assertSame((Object)testConfig, (Object)result, (String)"Should return the same metadata config instance");
        Assertions.assertEquals((Object)true, (Object)result.isEnabled(), (String)"Metadata should be enabled");
        Assertions.assertEquals((Object)true, (Object)result.isBloomFilterIndexEnabled(), (String)"Bloom filter index should be enabled");
        Assertions.assertEquals((Object)true, (Object)result.isColumnStatsIndexEnabled(), (String)"Column stats index should be enabled");
    }
}

