/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.nio.ByteBuffer;
import org.apache.hudi.common.util.AvroJavaTypeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAvroJavaTypeConverter {
    private final AvroJavaTypeConverter converter = new AvroJavaTypeConverter();

    TestAvroJavaTypeConverter() {
    }

    @Test
    void testCastToStringWithNullValue() {
        Assertions.assertNull((Object)this.converter.castToString(null));
    }

    @Test
    void testCastToStringWithByteBuffer() {
        String testString = "Hello, World!";
        ByteBuffer buffer = ByteBuffer.wrap(testString.getBytes());
        Assertions.assertEquals((Object)testString, (Object)this.converter.castToString((Object)buffer));
    }

    @Test
    void testCastToStringWithEmptyByteBuffer() {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[0]);
        Assertions.assertEquals((Object)"", (Object)this.converter.castToString((Object)buffer));
    }

    @Test
    void testCastToStringWithStringValue() {
        String testString = "test string";
        Assertions.assertEquals((Object)testString, (Object)this.converter.castToString((Object)testString));
    }

    @Test
    void testCastToStringWithIntegerValue() {
        Integer value = 123;
        Assertions.assertEquals((Object)"123", (Object)this.converter.castToString((Object)value));
    }

    @Test
    void testCastToStringWithBooleanValue() {
        Boolean value = true;
        Assertions.assertEquals((Object)"true", (Object)this.converter.castToString((Object)value));
    }

    @Test
    void testCastToStringWithDoubleValue() {
        Double value = 3.14;
        Assertions.assertEquals((Object)"3.14", (Object)this.converter.castToString((Object)value));
    }

    @Test
    void testCastToBooleanWithBooleanTrue() {
        Assertions.assertTrue((boolean)this.converter.castToBoolean((Object)true));
    }

    @Test
    void testCastToBooleanWithBooleanFalse() {
        Assertions.assertFalse((boolean)this.converter.castToBoolean((Object)false));
    }

    @Test
    void testCastToBooleanWithInvalidType() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.converter.castToBoolean((Object)"true"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("cannot be cast to boolean"));
    }
}

