/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.avro.AvroRecordSizeEstimator;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroRecordSizeEstimator {
    @Test
    void testEstimatingRecord() throws IOException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        GenericData.Record record = new GenericData.Record(schema);
        record.put("name", (Object)"lily");
        record.put("favorite_number", (Object)100);
        record.put("favorite_color", (Object)"red");
        AvroRecordSizeEstimator estimator = new AvroRecordSizeEstimator(schema);
        BufferedRecord bufferedRecord = new BufferedRecord("id", (Comparable)Integer.valueOf(100), (Object)record, Integer.valueOf(1), null);
        long size = estimator.sizeEstimate((Object)bufferedRecord);
        Assertions.assertTrue((size < 400L && size > 0L ? 1 : 0) != 0);
        HoodieMetadataRecord metadataRecord = new HoodieMetadataRecord("__all_partitions__", Integer.valueOf(1), new HashMap(), null, null, null, null);
        bufferedRecord = new BufferedRecord("__all_partitions__", (Comparable)Integer.valueOf(0), (Object)metadataRecord, Integer.valueOf(1), null);
        size = estimator.sizeEstimate((Object)bufferedRecord);
        Assertions.assertTrue((size < 400L && size > 0L ? 1 : 0) != 0);
    }
}

