/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieAvroSchemaException;
import org.apache.hudi.exception.SchemaBackwardsCompatibilityException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.schema.MessageType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestAvroSchemaUtils {
    private static final String SOURCE_SCHEMA = "{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n        \"name\" : \"f1\",\n        \"type\" : [ \"null\", {\n           \"type\" : \"fixed\",\n           \"name\" : \"f1\",\n           \"namespace\" : \"\",\n           \"size\" : 5,\n           \"logicalType\" : \"decimal\",\n           \"precision\" : 10,\n           \"scale\" : 2\n           }],\n       \"default\" : null\n    },\n    {\n         \"name\" : \"arrayInt\",\n          \"type\" : [ \"null\", {\n            \"type\" : \"array\",\n            \"items\" : [ \"null\", \"int\" ]\n           } ],\n          \"default\" : null\n    },\n    {\n         \"name\" : \"mapStrInt\",\n         \"type\" : [ \"null\", {\n           \"type\" : \"map\",\n           \"values\" : [ \"null\", \"int\" ]\n         } ],\n         \"default\" : null\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          },\n          {\n            \"name\": \"long\",\n            \"type\": [\"null\", \"long\"]\n          }\n        ]\n      }\n    },\n    { \n      \"name\" : \"f_enum\",\n      \"type\" : [ \"null\", {\n        \"type\" : \"enum\",\n        \"name\" : \"Visibility\",\n        \"namespace\" : \"common.Types\",\n        \"symbols\" : [ \"UNKNOWN\", \"PUBLIC\", \"PRIVATE\", \"SHARED\" ]\n         }]\n   }\n  ]\n}\n";
    private static final String PROJECTED_NESTED_SCHEMA_STRICT = "{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n        \"name\" : \"f1\",\n        \"type\" : [ \"null\", {\n           \"type\" : \"fixed\",\n           \"name\" : \"fixed\",\n           \"namespace\" : \"example.schema.source.f1\",\n           \"size\" : 5,\n           \"logicalType\" : \"decimal\",\n           \"precision\" : 10,\n           \"scale\" : 2\n           }],\n       \"default\" : null\n      },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          }\n        ]\n      }\n    }\n  ]\n}\n";
    private static final String PROJECTED_NESTED_SCHEMA_WITH_PROMOTION = "{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"long\"]\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          }\n        ]  \n      }\n    }\n  ]\n}\n";
    private static final Schema FULL_SCHEMA = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"fields\" : [ {\n    \"name\" : \"a\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"b\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"c\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  } ]\n}");
    private static final Schema SHORT_SCHEMA = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"fields\" : [ {\n    \"name\" : \"a\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"b\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  } ]\n}\n");
    private static final Schema BROKEN_SCHEMA = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"broken\",\n  \"fields\" : [ {\n    \"name\" : \"a\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"b\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"c\",\n    \"type\" : [ \"null\", \"boolean\" ],\n    \"default\" : null\n  } ]\n}");

    @Test
    public void testCreateNewSchemaFromFieldsWithReference_NullSchema() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AvroSchemaUtils.createNewSchemaFromFieldsWithReference(null, Collections.emptyList()));
    }

    @Test
    public void testCreateNewSchemaFromFieldsWithReference_NullObjectProps() {
        String schemaStr = "{ \"type\": \"record\", \"name\": \"TestRecord\", \"fields\": [] }";
        Schema schema = new Schema.Parser().parse(schemaStr);
        Schema newSchema = AvroSchemaUtils.createNewSchemaFromFieldsWithReference((Schema)schema, Collections.emptyList());
        Assertions.assertEquals((Object)"TestRecord", (Object)newSchema.getName());
        Assertions.assertEquals((int)0, (int)newSchema.getFields().size());
    }

    @Test
    public void testCreateNewSchemaFromFieldsWithReference_WithObjectProps() {
        String schemaStr = "{ \"type\": \"record\", \"name\": \"TestRecord\", \"fields\": [], \"prop1\": \"value1\" }";
        Schema schema = new Schema.Parser().parse(schemaStr);
        schema.addProp("prop1", "value1");
        Schema.Field newField = new Schema.Field("newField", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema newSchema = AvroSchemaUtils.createNewSchemaFromFieldsWithReference((Schema)schema, Collections.singletonList(newField));
        Assertions.assertEquals((Object)"TestRecord", (Object)newSchema.getName());
        Assertions.assertEquals((int)1, (int)newSchema.getFields().size());
        Assertions.assertEquals((Object)"value1", (Object)newSchema.getProp("prop1"));
        Assertions.assertEquals((Object)"newField", (Object)((Schema.Field)newSchema.getFields().get(0)).name());
    }

    @Test
    public void testIsStrictProjection() {
        Schema sourceSchema = new Schema.Parser().parse(SOURCE_SCHEMA);
        Schema projectedNestedSchema = new Schema.Parser().parse(PROJECTED_NESTED_SCHEMA_STRICT);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)projectedNestedSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)projectedNestedSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)Schema.createArray((Schema)sourceSchema), (Schema)Schema.createArray((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)Schema.createMap((Schema)sourceSchema), (Schema)Schema.createMap((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), sourceSchema}), (Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), projectedNestedSchema})));
        MessageType messageType = new AvroSchemaConverter().convert(sourceSchema);
        Schema converted = new AvroSchemaConverter().convert(messageType);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)converted));
    }

    @Test
    public void testIsCompatibleProjection() {
        Schema sourceSchema = new Schema.Parser().parse(SOURCE_SCHEMA);
        Schema projectedNestedSchema = new Schema.Parser().parse(PROJECTED_NESTED_SCHEMA_WITH_PROMOTION);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)sourceSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)sourceSchema, (Schema)projectedNestedSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)projectedNestedSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)projectedNestedSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)Schema.createArray((Schema)sourceSchema), (Schema)Schema.createArray((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)Schema.createMap((Schema)sourceSchema), (Schema)Schema.createMap((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), sourceSchema}), (Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), projectedNestedSchema})));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIsCompatibleProjectionNotAllowed(boolean shouldValidate) {
        Assertions.assertThrows(SchemaCompatibilityException.class, () -> AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)SHORT_SCHEMA, (boolean)shouldValidate, (boolean)false, Collections.emptySet()));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIsCompatibleProjectionAllowed(boolean shouldValidate) {
        AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)SHORT_SCHEMA, (boolean)shouldValidate, (boolean)true, Collections.emptySet());
    }

    @ParameterizedTest(name="[{index}] oldSize={0}, oldPrecision={1}, oldScale={2} -> newSize={3}, newPrecision={4}, newScale={5}")
    @MethodSource(value={"provideCompatibleDecimalSchemas"})
    void testCompatibleDecimalSchemas(int oldSize, int oldPrecision, int oldScale, int newSize, int newPrecision, int newScale) {
        Schema oldSchema = this.createFixedDecimalSchema(oldSize, oldPrecision, oldScale);
        Schema newSchema = this.createFixedDecimalSchema(newSize, newPrecision, newScale);
        Assertions.assertDoesNotThrow(() -> AvroSchemaUtils.checkSchemaCompatible((Schema)oldSchema, (Schema)newSchema, (boolean)true, (boolean)false, Collections.emptySet()), (String)"Schemas should be compatible");
    }

    @ParameterizedTest(name="[{index}] oldSize={0}, oldPrecision={1}, oldScale={2} -> newSize={3}, newPrecision={4}, newScale={5}")
    @MethodSource(value={"provideIncompatibleDecimalSchemas"})
    void testIncompatibleDecimalSchemas(int oldSize, int oldPrecision, int oldScale, int newSize, int newPrecision, int newScale) {
        Schema oldSchema = this.createFixedDecimalSchema(oldSize, oldPrecision, oldScale);
        Schema newSchema = this.createFixedDecimalSchema(newSize, newPrecision, newScale);
        Assertions.assertThrows(Exception.class, () -> AvroSchemaUtils.checkSchemaCompatible((Schema)oldSchema, (Schema)newSchema, (boolean)true, (boolean)false, Collections.emptySet()), (String)"Schemas should be incompatible");
    }

    private static Stream<Arguments> provideCompatibleDecimalSchemas() {
        return Stream.of(Arguments.of((Object[])new Object[]{8, 10, 2, 8, 10, 2}), Arguments.of((Object[])new Object[]{8, 10, 2, 8, 15, 2}), Arguments.of((Object[])new Object[]{16, 20, 5, 16, 25, 10}));
    }

    private static Stream<Arguments> provideIncompatibleDecimalSchemas() {
        return Stream.of(Arguments.of((Object[])new Object[]{8, 15, 2, 8, 10, 2}), Arguments.of((Object[])new Object[]{8, 10, 2, 8, 10, 5}), Arguments.of((Object[])new Object[]{16, 25, 3, 16, 20, 3}), Arguments.of((Object[])new Object[]{8, 18, 4, 8, 15, 6}));
    }

    private Schema createFixedDecimalSchema(int size, int precision, int scale) {
        Schema fixedSchema = (Schema)SchemaBuilder.fixed((String)"FixedDecimal").size(size);
        Schema decimalSchema = LogicalTypes.decimal((int)precision, (int)scale).addToSchema(fixedSchema);
        return (Schema)SchemaBuilder.record((String)"FixedDecimalSchema").fields().name("decimalField").type(decimalSchema).noDefault().endRecord();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIsCompatiblePartitionDropCols(boolean shouldValidate) {
        AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)SHORT_SCHEMA, (boolean)shouldValidate, (boolean)false, Collections.singleton("c"));
    }

    @Test
    public void testBrokenSchema() {
        Assertions.assertThrows(SchemaBackwardsCompatibilityException.class, () -> AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)BROKEN_SCHEMA, (boolean)true, (boolean)false, Collections.emptySet()));
    }

    @Test
    public void testAppendFieldsToSchemaDedupNested() {
        Schema fullSchema = new Schema.Parser().parse("{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          },\n          {\n            \"name\": \"long\",\n            \"type\": [\"null\", \"long\"]\n          }\n        ]\n      }\n    },\n    {\n      \"name\": \"other\",\n      \"type\": [\"null\", \"int\"]\n    }\n  ]\n}\n");
        Schema missingFieldSchema = new Schema.Parser().parse("{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          }\n        ]\n      }\n    },\n    {\n      \"name\": \"other\",\n      \"type\": [\"null\", \"int\"]\n    }\n  ]\n}\n");
        Option missingField = AvroSchemaUtils.findNestedField((Schema)fullSchema, (String)"nested_record.long");
        Assertions.assertTrue((boolean)missingField.isPresent());
        Assertions.assertEquals((Object)fullSchema, (Object)AvroSchemaUtils.appendFieldsToSchemaDedupNested((Schema)missingFieldSchema, Collections.singletonList(missingField.get())));
    }

    @Test
    public void testFindNestedFieldType() {
        Schema sourceSchema = new Schema.Parser().parse(SOURCE_SCHEMA);
        Option field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"number");
        Assertions.assertTrue((boolean)field.isPresent());
        Assertions.assertEquals((Object)Schema.Type.INT, (Object)field.get());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"nested_record.string");
        Assertions.assertTrue((boolean)field.isPresent());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)field.get());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"nested_record.long");
        Assertions.assertTrue((boolean)field.isPresent());
        Assertions.assertEquals((Object)Schema.Type.LONG, (Object)field.get());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, null);
        Assertions.assertTrue((boolean)field.isEmpty());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"");
        Assertions.assertTrue((boolean)field.isEmpty());
        Assertions.assertThrows(HoodieAvroSchemaException.class, () -> AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"long"));
        Assertions.assertThrows(HoodieAvroSchemaException.class, () -> AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"nested_record.bool"));
        Assertions.assertThrows(HoodieAvroSchemaException.class, () -> AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"non_present_field.also_not_present"));
    }

    private static Schema parse(String json) {
        return new Schema.Parser().parse(json);
    }

    @Test
    void testAreSchemasProjectionEquivalentRecordSchemas() {
        Schema s1 = TestAvroSchemaUtils.parse("{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"f1\",\"type\":\"int\"}]}");
        Schema s2 = TestAvroSchemaUtils.parse("{\"type\":\"record\",\"name\":\"R2\",\"fields\":[{\"name\":\"f1\",\"type\":\"int\"}]}");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentDifferentFieldCountInRecords() {
        Schema s1 = TestAvroSchemaUtils.parse("{\"type\":\"record\",\"name\":\"R1\",\"fields\":[{\"name\":\"a\",\"type\":\"int\"}]}");
        Schema s2 = TestAvroSchemaUtils.parse("{\"type\":\"record\",\"name\":\"R2\",\"fields\":[]}");
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentNestedRecordSchemas() {
        Schema s1 = TestAvroSchemaUtils.parse("{\"type\":\"record\",\"name\":\"Outer1\",\"fields\":[{\"name\":\"inner\",\"type\":{\"type\":\"record\",\"name\":\"Inner1\",\"fields\":[{\"name\":\"x\",\"type\":\"string\"}]}}]}");
        Schema s2 = TestAvroSchemaUtils.parse("{\"type\":\"record\",\"name\":\"Outer2\",\"fields\":[{\"name\":\"inner\",\"type\":{\"type\":\"record\",\"name\":\"Inner2\",\"fields\":[{\"name\":\"x\",\"type\":\"string\"}]}}]}");
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentArraySchemas() {
        Schema s1 = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Schema s2 = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentDifferentElementTypeInArray() {
        Schema s1 = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Schema s2 = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentMapSchemas() {
        Schema s1 = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        Schema s2 = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentDifferentMapValueTypes() {
        Schema s1 = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        Schema s2 = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        s1.addProp("prop1", "value1");
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentNullableSchemaComparison() {
        Schema s1 = AvroSchemaUtils.createNullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        Schema s2 = Schema.create((Schema.Type)Schema.Type.INT);
        s2.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentListVsString() {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema listSchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)listSchema, (Schema)stringSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)stringSchema, (Schema)listSchema));
    }

    @Test
    void testAreSchemasProjectionEquivalentMapVsString() {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema mapSchema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)mapSchema, (Schema)stringSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)stringSchema, (Schema)mapSchema));
    }

    @Test
    void testAreSchemasProjectionEquivalentEqualFixedSchemas() {
        Schema s1 = Schema.createFixed((String)"F", null, null, (int)16);
        Schema s2 = Schema.createFixed((String)"F", null, null, (int)16);
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentDifferentFixedSize() {
        Schema s1 = Schema.createFixed((String)"F", null, null, (int)8);
        Schema s2 = Schema.createFixed((String)"F", null, null, (int)4);
        s1.addProp("prop1", "value1");
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentEnums() {
        Schema s1 = Schema.createEnum((String)"E", null, null, Arrays.asList("A", "B", "C"));
        Schema s2 = Schema.createEnum((String)"E", null, null, Arrays.asList("A", "B", "C"));
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentDifferentEnumSymbols() {
        Schema s1 = Schema.createEnum((String)"E", null, null, Arrays.asList("X", "Y"));
        Schema s2 = Schema.createEnum((String)"E", null, null, Arrays.asList("A", "B"));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentEnumSymbolSubset() {
        Schema s1 = Schema.createEnum((String)"E", null, null, Arrays.asList("A", "B"));
        Schema s2 = Schema.createEnum((String)"E", null, null, Arrays.asList("A", "B", "C"));
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s2, (Schema)s1));
    }

    @Test
    void testAreSchemasProjectionEquivalentEqualDecimalLogicalTypes() {
        Schema s1 = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)12, (int)2).addToSchema(s1);
        Schema s2 = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)12, (int)2).addToSchema(s2);
        s1.addProp("prop1", "value1");
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentDifferentPrecision() {
        Schema s1 = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)12, (int)2).addToSchema(s1);
        Schema s2 = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)13, (int)2).addToSchema(s2);
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentLogicalVsNoLogicalType() {
        Schema s1 = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)10, (int)2).addToSchema(s1);
        Schema s2 = Schema.create((Schema.Type)Schema.Type.BYTES);
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s1, (Schema)s2));
    }

    @Test
    void testAreSchemasProjectionEquivalentSameReferenceSchema() {
        Schema s = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertTrue((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s, (Schema)s));
    }

    @Test
    void testAreSchemasProjectionEquivalentNullSchemaComparison() {
        Schema s = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent(null, (Schema)s));
        Assertions.assertFalse((boolean)AvroSchemaUtils.areSchemasProjectionEquivalent((Schema)s, null));
    }

    @Test
    void testPruneRecordFields() {
        String dataSchemaStr = "{ \"type\": \"record\", \"name\": \"Person\", \"fields\": [{ \"name\": \"name\", \"type\": \"string\" },{ \"name\": \"age\", \"type\": \"int\" },{ \"name\": \"email\", \"type\": [\"null\", \"string\"], \"default\": null }]}";
        String requiredSchemaStr = "{ \"type\": \"record\", \"name\": \"Person\", \"fields\": [{ \"name\": \"name\", \"type\": \"string\" }]}";
        Schema dataSchema = TestAvroSchemaUtils.parse(dataSchemaStr);
        Schema requiredSchema = TestAvroSchemaUtils.parse(requiredSchemaStr);
        Schema pruned = AvroSchemaUtils.pruneDataSchema((Schema)dataSchema, (Schema)requiredSchema, Collections.emptySet());
        Assertions.assertEquals((int)1, (int)pruned.getFields().size());
        Assertions.assertEquals((Object)"name", (Object)((Schema.Field)pruned.getFields().get(0)).name());
    }

    @Test
    void testPruningPreserveNullable() {
        String dataSchemaStr = "{\"type\": \"record\",\"name\": \"Container\",\"fields\": [  {    \"name\": \"foo\",    \"type\": [\"null\", {      \"type\": \"record\",      \"name\": \"Foo\",      \"fields\": [        {\"name\": \"field1\", \"type\": \"string\"},        {\"name\": \"field2\", \"type\": \"int\"}      ]    }],    \"default\": null  }]}";
        String requiredFooStr = "{\"type\": \"record\",\"name\": \"Foo\",\"fields\": [  {\"name\": \"field1\", \"type\": \"string\"}]}";
        Schema dataSchema = TestAvroSchemaUtils.parse(dataSchemaStr);
        Schema requiredSchema = TestAvroSchemaUtils.parse(requiredFooStr);
        Schema fooFieldSchema = dataSchema.getField("foo").schema();
        Schema pruned = AvroSchemaUtils.pruneDataSchema((Schema)fooFieldSchema, (Schema)requiredSchema, Collections.emptySet());
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)pruned.getType());
        Schema prunedRecord = (Schema)pruned.getTypes().stream().filter(s -> s.getType() == Schema.Type.RECORD).collect(Collectors.toList()).get(0);
        AssertionsKt.assertNotNull((Object)prunedRecord.getField("field1"));
        Assertions.assertNull((Object)prunedRecord.getField("field2"));
    }

    @Test
    void testArrayElementPruning() {
        String dataSchemaStr = "{ \"type\": \"array\", \"items\": { \"type\": \"record\", \"name\": \"Item\", \"fields\": [{\"name\": \"a\", \"type\": \"int\"}, {\"name\": \"b\", \"type\": \"string\"}]}}";
        String requiredSchemaStr = "{ \"type\": \"array\", \"items\": { \"type\": \"record\", \"name\": \"Item\", \"fields\": [{\"name\": \"b\", \"type\": \"string\"}]}}";
        Schema dataSchema = TestAvroSchemaUtils.parse(dataSchemaStr);
        Schema requiredSchema = TestAvroSchemaUtils.parse(requiredSchemaStr);
        Schema pruned = AvroSchemaUtils.pruneDataSchema((Schema)dataSchema, (Schema)requiredSchema, Collections.emptySet());
        Schema itemSchema = pruned.getElementType();
        Assertions.assertEquals((int)1, (int)itemSchema.getFields().size());
        Assertions.assertEquals((Object)"b", (Object)((Schema.Field)itemSchema.getFields().get(0)).name());
    }

    @Test
    void testMapValuePruning() {
        String dataSchemaStr = "{ \"type\": \"map\", \"values\": { \"type\": \"record\", \"name\": \"Entry\", \"fields\": [{\"name\": \"x\", \"type\": \"int\"}, {\"name\": \"y\", \"type\": \"string\"}]}}";
        String requiredSchemaStr = "{ \"type\": \"map\", \"values\": { \"type\": \"record\", \"name\": \"Entry\", \"fields\": [{\"name\": \"y\", \"type\": \"string\"}]}}";
        Schema dataSchema = TestAvroSchemaUtils.parse(dataSchemaStr);
        Schema requiredSchema = TestAvroSchemaUtils.parse(requiredSchemaStr);
        Schema pruned = AvroSchemaUtils.pruneDataSchema((Schema)dataSchema, (Schema)requiredSchema, Collections.emptySet());
        Schema valueSchema = pruned.getValueType();
        Assertions.assertEquals((int)1, (int)valueSchema.getFields().size());
        Assertions.assertEquals((Object)"y", (Object)((Schema.Field)valueSchema.getFields().get(0)).name());
    }

    @Test
    void testPruningExcludedFieldIsPreservedIfMissingInDataSchema() {
        String dataSchemaStr = "{ \"type\": \"record\", \"name\": \"Rec\", \"fields\": [{\"name\": \"existing\", \"type\": \"int\"}]}";
        String requiredSchemaStr = "{ \"type\": \"record\", \"name\": \"Rec\", \"fields\": [{\"name\": \"existing\", \"type\": \"int\"},{\"name\": \"missing\", \"type\": \"string\", \"default\": \"default\"}]}";
        Schema dataSchema = TestAvroSchemaUtils.parse(dataSchemaStr);
        Schema requiredSchema = TestAvroSchemaUtils.parse(requiredSchemaStr);
        Set<String> mandatoryFields = Collections.singleton("missing");
        Schema pruned = AvroSchemaUtils.pruneDataSchema((Schema)dataSchema, (Schema)requiredSchema, mandatoryFields);
        Assertions.assertEquals((int)2, (int)pruned.getFields().size());
        AssertionsKt.assertNotNull((Object)pruned.getField("missing"));
        Assertions.assertEquals((Object)"string", (Object)pruned.getField("missing").schema().getType().getName());
    }

    @Test
    void testPruningMandatoryFieldsOnlyApplyToTopLevel() {
        String dataSchemaStr = "{ \"type\": \"record\", \"name\": \"Rec\", \"fields\": [{\"name\": \"existing\", \"type\": \"int\"},{\"name\": \"nestedRecord\", \"type\": {  \"type\": \"record\", \"name\": \"NestedRec\", \"fields\": [    {\"name\": \"nestedField\", \"type\": \"string\"}  ]}}]}";
        String requiredSchemaStr = "{ \"type\": \"record\", \"name\": \"Rec\", \"fields\": [{\"name\": \"existing\", \"type\": \"int\"},{\"name\": \"topLevelMissing\", \"type\": \"string\", \"default\": \"default\"},{\"name\": \"nestedRecord\", \"type\": {  \"type\": \"record\", \"name\": \"NestedRec\", \"fields\": [    {\"name\": \"nestedField\", \"type\": \"string\"},    {\"name\": \"nestedMissing\", \"type\": \"int\", \"default\": 0}  ]}}]}";
        Schema dataSchema = TestAvroSchemaUtils.parse(dataSchemaStr);
        Schema requiredSchema = TestAvroSchemaUtils.parse(requiredSchemaStr);
        HashSet<String> mandatoryFields = new HashSet<String>(Arrays.asList("topLevelMissing", "nestedMissing"));
        Schema pruned = AvroSchemaUtils.pruneDataSchema((Schema)dataSchema, (Schema)requiredSchema, mandatoryFields);
        Assertions.assertEquals((int)3, (int)pruned.getFields().size());
        AssertionsKt.assertNotNull((Object)pruned.getField("topLevelMissing"));
        Assertions.assertEquals((Object)"string", (Object)pruned.getField("topLevelMissing").schema().getType().getName());
        AssertionsKt.assertNotNull((Object)pruned.getField("nestedRecord"));
        Schema nestedSchema = pruned.getField("nestedRecord").schema();
        Assertions.assertEquals((int)1, (int)nestedSchema.getFields().size());
        AssertionsKt.assertNotNull((Object)nestedSchema.getField("nestedField"));
        Assertions.assertNull((Object)nestedSchema.getField("nestedMissing"));
    }
}

