/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestHoodieAvroReaderContext {
    private static final Schema SKELETON_SCHEMA = TestHoodieAvroReaderContext.getSkeletonSchema();
    private static final Schema LIMITED_SKELETON_SCHEMA = TestHoodieAvroReaderContext.getLimitedSkeletonSchema();
    private static final Schema BASE_SCHEMA = TestHoodieAvroReaderContext.getBaseSchema();
    private static final Schema LIMITED_BASE_SCHEMA = TestHoodieAvroReaderContext.getLimitedBaseSchema();
    private static final Schema FULL_MERGED_SCHEMA = AvroSchemaUtils.mergeSchemas((Schema)SKELETON_SCHEMA, (Schema)BASE_SCHEMA);
    private static final Schema LIMTIED_MERGED_SCHEMA = AvroSchemaUtils.mergeSchemas((Schema)LIMITED_SKELETON_SCHEMA, (Schema)LIMITED_BASE_SCHEMA);
    private final StorageConfiguration<?> storageConfig = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
    private final HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);

    TestHoodieAvroReaderContext() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.tableConfig.getPayloadClass()).thenReturn((Object)DefaultHoodieRecordPayload.class.getName());
    }

    @Test
    void bootstrapIteratorWithLimitedFields() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        IndexedRecord skeletonRecord1 = this.createSkeletonRecord("s-100", "s-101", 1);
        IndexedRecord baseRecord1 = this.createBaseRecord("b-100", "b-101", 1.3);
        IndexedRecord expectedRecord1 = this.createLimitedMergedRecord("s-101", "b-100", 1.3);
        IndexedRecord skeletonRecord2 = this.createSkeletonRecord("s-200", "s-201", 2);
        IndexedRecord baseRecord2 = this.createBaseRecord("b-200", "b-201", 2.9);
        IndexedRecord expectedRecord2 = this.createLimitedMergedRecord("s-201", "b-200", 2.9);
        IndexedRecord skeletonRecord3 = this.createSkeletonRecord("s-300", "s-301", 3);
        IndexedRecord baseRecord3 = this.createBaseRecord("b-300", "b-301", 3.2);
        IndexedRecord expectedRecord3 = this.createLimitedMergedRecord("s-301", "b-300", 3.2);
        ClosableIterator skeletonIterator = ClosableIterator.wrap(Arrays.asList(skeletonRecord1, skeletonRecord2, skeletonRecord3).iterator());
        ClosableIterator baseIterator = ClosableIterator.wrap(Arrays.asList(baseRecord1, baseRecord2, baseRecord3).iterator());
        ArrayList actual = new ArrayList();
        try (ClosableIterator iter = avroReaderContext.mergeBootstrapReaders(skeletonIterator, LIMITED_SKELETON_SCHEMA, baseIterator, LIMITED_BASE_SCHEMA, Collections.emptyList());){
            iter.forEachRemaining(actual::add);
        }
        Assertions.assertEquals(Arrays.asList(expectedRecord1, expectedRecord2, expectedRecord3), actual);
    }

    @Test
    void bootstrapIteratorWithAllFields() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        IndexedRecord skeletonRecord1 = this.createSkeletonRecord("s-100", "s-101", 1);
        IndexedRecord baseRecord1 = this.createBaseRecord("b-100", "b-101", 1.3);
        IndexedRecord expectedRecord1 = this.createFullMergedRecord("s-100", "s-101", 1, "b-100", "b-101", 1.3);
        IndexedRecord skeletonRecord2 = this.createSkeletonRecord("s-200", "s-201", 2);
        IndexedRecord baseRecord2 = this.createBaseRecord("b-200", "b-201", 2.9);
        IndexedRecord expectedRecord2 = this.createFullMergedRecord("s-200", "s-201", 2, "b-200", "b-201", 2.9);
        IndexedRecord skeletonRecord3 = this.createSkeletonRecord("s-300", "s-301", 3);
        IndexedRecord baseRecord3 = this.createBaseRecord("b-300", "b-301", 3.2);
        IndexedRecord expectedRecord3 = this.createFullMergedRecord("s-300", "s-301", 3, "b-300", "b-301", 3.2);
        ClosableIterator skeletonIterator = ClosableIterator.wrap(Arrays.asList(skeletonRecord1, skeletonRecord2, skeletonRecord3).iterator());
        ClosableIterator baseIterator = ClosableIterator.wrap(Arrays.asList(baseRecord1, baseRecord2, baseRecord3).iterator());
        ArrayList actual = new ArrayList();
        try (ClosableIterator iter = avroReaderContext.mergeBootstrapReaders(skeletonIterator, SKELETON_SCHEMA, baseIterator, BASE_SCHEMA, Collections.emptyList());){
            iter.forEachRemaining(actual::add);
        }
        Assertions.assertEquals(Arrays.asList(expectedRecord1, expectedRecord2, expectedRecord3), actual);
    }

    @Test
    void bootstrapIteratorWithEmptyIterators() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        ArrayList actual = new ArrayList();
        try (ClosableIterator iter = avroReaderContext.mergeBootstrapReaders(ClosableIterator.wrap(Collections.emptyIterator()), SKELETON_SCHEMA, ClosableIterator.wrap(Collections.emptyIterator()), BASE_SCHEMA, Collections.emptyList());){
            iter.forEachRemaining(actual::add);
        }
        Assertions.assertEquals(Collections.emptyList(), actual);
    }

    @Test
    void bootstrapIteratorFailsDueToMismatchedIterators() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        IndexedRecord skeletonRecord1 = this.createSkeletonRecord("s-100", "s-101", 1);
        IndexedRecord baseRecord1 = this.createBaseRecord("b-100", "b-101", 1.3);
        IndexedRecord skeletonRecord2 = this.createSkeletonRecord("s-200", "s-201", 2);
        ClosableIterator skeletonIterator = ClosableIterator.wrap(Arrays.asList(skeletonRecord1, skeletonRecord2).iterator());
        ClosableIterator baseIterator = ClosableIterator.wrap(Collections.singletonList(baseRecord1).iterator());
        ArrayList actual = new ArrayList();
        Assertions.assertThrows(IllegalStateException.class, () -> {
            try (ClosableIterator iter = avroReaderContext.mergeBootstrapReaders(skeletonIterator, SKELETON_SCHEMA, baseIterator, BASE_SCHEMA, Collections.emptyList());){
                iter.forEachRemaining(actual::add);
            }
        });
    }

    @Test
    void getField() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        IndexedRecord indexedRecord = this.createSkeletonRecord("field1", "field2", 3);
        Assertions.assertEquals((Object)"field2", (Object)avroReaderContext.getRecordContext().getValue((Object)indexedRecord, SKELETON_SCHEMA, "skeleton_field_2"));
    }

    @Test
    void getFieldNotInSchema() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        IndexedRecord indexedRecord = this.createSkeletonRecord("field1", "field2", 3);
        Assertions.assertNull((Object)avroReaderContext.getRecordContext().getValue((Object)indexedRecord, SKELETON_SCHEMA, "missing_field"));
    }

    @Test
    void getNestedField() {
        Mockito.when((Object)this.tableConfig.populateMetaFields()).thenReturn((Object)true);
        HoodieAvroReaderContext avroReaderContext = new HoodieAvroReaderContext(this.storageConfig, this.tableConfig, Option.empty(), Option.empty());
        IndexedRecord indexedRecord = this.createBaseRecord("compound", "field2", 3.2);
        Assertions.assertEquals((Object)3.2, (Object)avroReaderContext.getRecordContext().getValue((Object)indexedRecord, BASE_SCHEMA, "base_field_3.nested_field"));
    }

    @Test
    void getRecordKeyWithSingleKey() {
        Mockito.when((Object)this.tableConfig.populateMetaFields()).thenReturn((Object)false);
        Mockito.when((Object)this.tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"skeleton_field_1"}));
        HoodieAvroReaderContext avroReaderContext = new HoodieAvroReaderContext(this.storageConfig, this.tableConfig, Option.empty(), Option.empty());
        String recordKey = "record_key";
        IndexedRecord indexedRecord = this.createSkeletonRecord(recordKey, "field2", 3);
        Assertions.assertEquals((Object)recordKey, (Object)avroReaderContext.getRecordContext().getRecordKey((Object)indexedRecord, SKELETON_SCHEMA));
    }

    @Test
    void getRecordKeyWithMultipleKeys() {
        Mockito.when((Object)this.tableConfig.populateMetaFields()).thenReturn((Object)false);
        Mockito.when((Object)this.tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"base_field_1", "base_field_3.nested_field"}));
        HoodieAvroReaderContext avroReaderContext = new HoodieAvroReaderContext(this.storageConfig, this.tableConfig, Option.empty(), Option.empty());
        String recordKey = "base_field_1:compound,base_field_3.nested_field:3.2";
        IndexedRecord indexedRecord = this.createBaseRecord("compound", "field2", 3.2);
        Assertions.assertEquals((Object)recordKey, (Object)avroReaderContext.getRecordContext().getRecordKey((Object)indexedRecord, BASE_SCHEMA));
    }

    @Test
    void getRecordKeyFromMetadataFields() {
        HoodieAvroReaderContext avroReaderContext = this.getReaderContextWithMetaFields();
        Schema schemaWithMetaFields = HoodieAvroUtils.addMetadataFields((Schema)SKELETON_SCHEMA);
        String recordKey = "record_key";
        GenericData.Record indexedRecord = new GenericData.Record(schemaWithMetaFields);
        indexedRecord.put(0, (Object)"commit_time");
        indexedRecord.put(1, (Object)"commit_seqno");
        indexedRecord.put(2, (Object)recordKey);
        indexedRecord.put(5, (Object)"field1");
        indexedRecord.put(6, (Object)"field2");
        indexedRecord.put(7, (Object)3);
        Assertions.assertEquals((Object)recordKey, (Object)avroReaderContext.getRecordContext().getRecordKey((Object)indexedRecord, schemaWithMetaFields));
    }

    @Test
    void testConstructEngineRecordWithFieldValues() {
        HoodieAvroReaderContext readerContext = this.getReaderContextWithMetaFields();
        Schema schema = TestHoodieAvroReaderContext.getSkeletonSchema();
        Object[] fieldVals = new Object[]{"String1", "String2", 1};
        IndexedRecord row = (IndexedRecord)readerContext.getRecordContext().constructEngineRecord(schema, fieldVals);
        Assertions.assertEquals((Object)fieldVals[0], (Object)row.get(0));
        Assertions.assertEquals((Object)fieldVals[1], (Object)row.get(1));
        Assertions.assertEquals((Object)fieldVals[2], (Object)row.get(2));
    }

    @Test
    void testConstructEngineRecordWithNoUpdate() {
        HoodieAvroReaderContext readerContext = this.getReaderContextWithMetaFields();
        Schema schema = TestHoodieAvroReaderContext.getSkeletonSchema();
        IndexedRecord engineRecord = this.createSkeletonRecord("String1", "String2", 1);
        BufferedRecord baseRecord = new BufferedRecord("key1", (Comparable)Integer.valueOf(1), (Object)engineRecord, Integer.valueOf(0), null);
        HashMap updates = new HashMap();
        IndexedRecord output = (IndexedRecord)readerContext.getRecordContext().mergeWithEngineRecord(schema, updates, baseRecord);
        Assertions.assertEquals((Object)"String1", (Object)output.get(0));
        Assertions.assertEquals((Object)"String2", (Object)output.get(1));
        Assertions.assertEquals((Object)1, (Object)output.get(2));
    }

    @Test
    void testConstructEngineRecordWithUpdates() {
        HoodieAvroReaderContext readerContext = this.getReaderContextWithMetaFields();
        Schema schema = TestHoodieAvroReaderContext.getSkeletonSchema();
        IndexedRecord engineRecord = this.createSkeletonRecord("String1", "String2", 1);
        BufferedRecord baseRecord = new BufferedRecord("key1", (Comparable)Integer.valueOf(1), (Object)engineRecord, Integer.valueOf(0), null);
        HashMap<Integer, Object> updates = new HashMap<Integer, Object>();
        updates.put(0, "String1_0");
        updates.put(2, 2);
        IndexedRecord output = (IndexedRecord)readerContext.getRecordContext().mergeWithEngineRecord(schema, updates, baseRecord);
        Assertions.assertEquals((Object)"String1_0", (Object)output.get(0));
        Assertions.assertEquals((Object)"String2", (Object)output.get(1));
        Assertions.assertEquals((Object)2, (Object)output.get(2));
    }

    private HoodieAvroReaderContext getReaderContextWithMetaFields() {
        Mockito.when((Object)this.tableConfig.populateMetaFields()).thenReturn((Object)true);
        return new HoodieAvroReaderContext(this.storageConfig, this.tableConfig, Option.empty(), Option.empty());
    }

    private static Schema getSkeletonSchema() {
        Schema skeletonDataSchema = Schema.createRecord((String)"skeleton_full_schema", null, null, (boolean)false);
        Schema.Field skeletonField1 = new Schema.Field("skeleton_field_1", Schema.create((Schema.Type)Schema.Type.STRING));
        Schema.Field skeletonField2 = new Schema.Field("skeleton_field_2", Schema.create((Schema.Type)Schema.Type.STRING));
        Schema.Field skeletonField3 = new Schema.Field("skeleton_field_3", Schema.create((Schema.Type)Schema.Type.INT));
        skeletonDataSchema.setFields(Arrays.asList(skeletonField1, skeletonField2, skeletonField3));
        return skeletonDataSchema;
    }

    private static Schema getLimitedSkeletonSchema() {
        Schema skeletonDataSchema = Schema.createRecord((String)"skeleton_limited_schema", null, null, (boolean)false);
        Schema.Field skeletonField2 = new Schema.Field("skeleton_field_2", Schema.create((Schema.Type)Schema.Type.STRING));
        skeletonDataSchema.setFields(Collections.singletonList(skeletonField2));
        return skeletonDataSchema;
    }

    private static Schema getBaseSchema() {
        Schema baseDataSchema = Schema.createRecord((String)"base_full_schema", null, null, (boolean)false);
        Schema.Field baseField1 = new Schema.Field("base_field_1", Schema.create((Schema.Type)Schema.Type.STRING));
        Schema.Field baseField2 = new Schema.Field("base_field_2", Schema.create((Schema.Type)Schema.Type.STRING));
        Schema.Field baseField3 = new Schema.Field("base_field_3", Schema.createRecord((String)"nested", null, null, (boolean)false, Collections.singletonList(new Schema.Field("nested_field", Schema.create((Schema.Type)Schema.Type.DOUBLE)))));
        baseDataSchema.setFields(Arrays.asList(baseField1, baseField2, baseField3));
        return baseDataSchema;
    }

    private static Schema getLimitedBaseSchema() {
        Schema baseDataSchema = Schema.createRecord((String)"base_limited_schema", null, null, (boolean)false);
        Schema.Field baseField1 = new Schema.Field("base_field_1", Schema.create((Schema.Type)Schema.Type.STRING));
        Schema.Field baseField3 = new Schema.Field("base_field_3", Schema.createRecord((String)"nested", null, null, (boolean)false, Collections.singletonList(new Schema.Field("nested_field", Schema.create((Schema.Type)Schema.Type.DOUBLE)))));
        baseDataSchema.setFields(Arrays.asList(baseField1, baseField3));
        return baseDataSchema;
    }

    private IndexedRecord createSkeletonRecord(String field1, String field2, int field3) {
        GenericData.Record record = new GenericData.Record(SKELETON_SCHEMA);
        record.put(0, (Object)field1);
        record.put(1, (Object)field2);
        record.put(2, (Object)field3);
        return record;
    }

    private IndexedRecord createBaseRecord(String field1, String field2, double field3) {
        GenericData.Record nested = new GenericData.Record(((Schema.Field)BASE_SCHEMA.getFields().get(2)).schema());
        nested.put(0, (Object)field3);
        GenericData.Record record = new GenericData.Record(BASE_SCHEMA);
        record.put(0, (Object)field1);
        record.put(1, (Object)field2);
        record.put(2, (Object)nested);
        return record;
    }

    private IndexedRecord createFullMergedRecord(String skeletonField1, String skeletonField2, int skeletonField3, String baseField1, String baseField2, double baseField3) {
        GenericData.Record nested = new GenericData.Record(((Schema.Field)FULL_MERGED_SCHEMA.getFields().get(5)).schema());
        nested.put(0, (Object)baseField3);
        GenericData.Record record = new GenericData.Record(FULL_MERGED_SCHEMA);
        record.put(0, (Object)skeletonField1);
        record.put(1, (Object)skeletonField2);
        record.put(2, (Object)skeletonField3);
        record.put(3, (Object)baseField1);
        record.put(4, (Object)baseField2);
        record.put(5, (Object)nested);
        return record;
    }

    private IndexedRecord createLimitedMergedRecord(String skeletonField2, String baseField1, double baseField3) {
        GenericData.Record nested = new GenericData.Record(((Schema.Field)LIMTIED_MERGED_SCHEMA.getFields().get(2)).schema());
        nested.put(0, (Object)baseField3);
        GenericData.Record record = new GenericData.Record(LIMTIED_MERGED_SCHEMA);
        record.put(0, (Object)skeletonField2);
        record.put(1, (Object)baseField1);
        record.put(2, (Object)nested);
        return record;
    }
}

