/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.util.UUID;
import org.apache.hudi.common.bloom.HoodieDynamicBoundedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInternalDynamicBloomFilter {
    @Test
    public void testBoundedSize() {
        int[] batchSizes = new int[]{1000, 10000, 10000, 100000, 100000, 10000};
        int indexForMaxGrowth = 3;
        int maxSize = batchSizes[0] * 100;
        HoodieDynamicBoundedBloomFilter filter = new HoodieDynamicBoundedBloomFilter(batchSizes[0], 1.0E-6, 1, maxSize);
        int lastKnownBloomSize = 0;
        for (int index = 0; index < batchSizes.length; ++index) {
            for (int i = 0; i < batchSizes[index]; ++i) {
                String key = UUID.randomUUID().toString();
                filter.add(key);
            }
            String serString = filter.serializeToString();
            if (index != 0) {
                int curLength = serString.length();
                if (index > indexForMaxGrowth) {
                    Assertions.assertEquals((int)curLength, (int)lastKnownBloomSize, (String)"Length should not increase after hitting max entries");
                } else {
                    Assertions.assertTrue((curLength > lastKnownBloomSize ? 1 : 0) != 0, (String)"Length should increase until max entries are reached");
                }
            }
            lastKnownBloomSize = serString.length();
        }
    }

    @Test
    public void testInternalDynamicBloomFilterRescale() {
        HoodieDynamicBoundedBloomFilter filter = new HoodieDynamicBoundedBloomFilter(1000, 1.0E-6, 1, 10000);
        Assertions.assertEquals((int)1, (int)filter.getMatrixLength());
        HoodieDynamicBoundedBloomFilter rescaledToSize2Filter = filter.rescaleFromTarget(2);
        Assertions.assertEquals((int)2, (int)rescaledToSize2Filter.getMatrixLength());
        HoodieDynamicBoundedBloomFilter rescaledToSize4Filter = rescaledToSize2Filter.rescaleFromTarget(4);
        Assertions.assertEquals((int)4, (int)rescaledToSize4Filter.getMatrixLength());
    }
}

