/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigProperty
extends HoodieConfig {
    public static ConfigProperty<String> FAKE_STRING_CONFIG = ConfigProperty.key((String)"test.fake.string.config").defaultValue((Object)"1").supportedVersions(new String[]{"a.b.c", "d.e.f"}).withAlternatives(new String[]{"test.fake.string.alternative.config"}).withDocumentation("Fake config only for testing");
    public static ConfigProperty<String> FAKE_BOOLEAN_CONFIG = ConfigProperty.key((String)"test.fake.boolean.config").defaultValue((Object)"false").withDocumentation("Fake config only for testing");
    public static ConfigProperty<String> FAKE_BOOLEAN_CONFIG_NO_DEFAULT = ConfigProperty.key((String)"test.fake.boolean.config").noDefaultValue().withDocumentation("Fake config only for testing");
    public static ConfigProperty<Integer> FAKE_INTEGER_CONFIG = ConfigProperty.key((String)"test.fake.integer.config").defaultValue((Object)0).withInferFunction(p -> {
        if (p.contains(FAKE_STRING_CONFIG) && p.getString(FAKE_STRING_CONFIG).equals("5")) {
            return Option.of((Object)100);
        }
        return Option.empty();
    }).withDocumentation("Fake config only for testing");
    public static ConfigProperty<String> FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER = ConfigProperty.key((String)"test.fake.string.config.no_default_with_infer").noDefaultValue().withInferFunction(p -> {
        if (p.getStringOrDefault(FAKE_STRING_CONFIG).equals("value1")) {
            return Option.of((Object)"value2");
        }
        return Option.of((Object)"value3");
    }).withDocumentation("Fake config with infer function and without default only for testing");
    public static ConfigProperty<String> FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY = ConfigProperty.key((String)"test.fake.string.config.no_default_with_infer_empty").noDefaultValue().withInferFunction(p -> {
        if (p.getStringOrDefault(FAKE_STRING_CONFIG).equals("value1")) {
            return Option.of((Object)"value10");
        }
        return Option.empty();
    }).withDocumentation("Fake config with infer function that ca return empty value and without default only for testing");

    @Test
    public void testGetTypedValue() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        Assertions.assertNull((Object)hoodieConfig.getInt(FAKE_STRING_CONFIG));
        hoodieConfig.setValue(FAKE_STRING_CONFIG, "5");
        Assertions.assertEquals((int)5, (Integer)hoodieConfig.getInt(FAKE_STRING_CONFIG));
        Assertions.assertEquals((Object)false, (Object)hoodieConfig.getBoolean(FAKE_BOOLEAN_CONFIG));
        hoodieConfig.setValue(FAKE_BOOLEAN_CONFIG, "true");
        Assertions.assertEquals((Object)true, (Object)hoodieConfig.getBoolean(FAKE_BOOLEAN_CONFIG));
    }

    @Test
    public void testGetBooleanShouldReturnFalseWhenDefaultValueFalseButNotSet() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        Assertions.assertEquals((Object)false, (Object)hoodieConfig.getBoolean(FAKE_BOOLEAN_CONFIG));
    }

    @Test
    public void testGetBooleanShouldReturnNullWhenNoDefaultValuePresent() {
        HoodieConfig hoodieConfig = new HoodieConfig();
        Assertions.assertNull((Object)hoodieConfig.getBoolean(FAKE_BOOLEAN_CONFIG_NO_DEFAULT));
    }

    @Test
    public void testGetOrDefault() {
        Properties props = new Properties();
        props.put("test.unknown.config", "abc");
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        Assertions.assertEquals((Object)"1", (Object)hoodieConfig.getStringOrDefault(FAKE_STRING_CONFIG));
        Assertions.assertEquals((Object)"2", (Object)hoodieConfig.getStringOrDefault(FAKE_STRING_CONFIG, "2"));
    }

    @Test
    public void testAlternatives() {
        Properties props = new Properties();
        props.put("test.fake.string.alternative.config", "1");
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        Assertions.assertTrue((boolean)hoodieConfig.contains(FAKE_STRING_CONFIG));
        Assertions.assertEquals((Object)"1", (Object)hoodieConfig.getString(FAKE_STRING_CONFIG));
    }

    @Test
    public void testInference() {
        HoodieConfig hoodieConfig1 = new HoodieConfig();
        hoodieConfig1.setDefaultValue(FAKE_INTEGER_CONFIG);
        Assertions.assertEquals((int)0, (Integer)hoodieConfig1.getInt(FAKE_INTEGER_CONFIG));
        HoodieConfig hoodieConfig2 = new HoodieConfig();
        hoodieConfig2.setValue(FAKE_STRING_CONFIG, "5");
        hoodieConfig2.setDefaultValue(FAKE_INTEGER_CONFIG);
        Assertions.assertEquals((int)100, (Integer)hoodieConfig2.getInt(FAKE_INTEGER_CONFIG));
        HoodieConfig hoodieConfig3 = new HoodieConfig();
        hoodieConfig3.setValue(FAKE_STRING_CONFIG, "value1");
        hoodieConfig3.setDefaultValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER);
        hoodieConfig3.setDefaultValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY);
        Assertions.assertEquals((Object)"value2", (Object)hoodieConfig3.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER));
        Assertions.assertEquals((Object)"value10", (Object)hoodieConfig3.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY));
        HoodieConfig hoodieConfig4 = new HoodieConfig();
        hoodieConfig4.setValue(FAKE_STRING_CONFIG, "other");
        hoodieConfig4.setDefaultValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER);
        Assertions.assertEquals((Object)"value3", (Object)hoodieConfig4.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER));
        Assertions.assertEquals(null, (Object)hoodieConfig4.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY));
        HoodieConfig hoodieConfig5 = new HoodieConfig();
        hoodieConfig5.setValue(FAKE_STRING_CONFIG, "other");
        hoodieConfig5.setValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER, "value4");
        hoodieConfig5.setDefaultValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER);
        Assertions.assertEquals((Object)"value4", (Object)hoodieConfig5.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER));
    }

    @Test
    public void testSetDefaults() {
        this.setDefaults(((Object)((Object)this)).getClass().getName());
        Assertions.assertEquals((int)4, (int)this.getProps().size());
    }

    @Test
    public void testAdvancedValue() {
        Assertions.assertFalse((boolean)FAKE_BOOLEAN_CONFIG.isAdvanced());
        Assertions.assertFalse((boolean)FAKE_BOOLEAN_CONFIG_NO_DEFAULT.isAdvanced());
        Assertions.assertTrue((boolean)FAKE_BOOLEAN_CONFIG.markAdvanced().isAdvanced());
        Assertions.assertTrue((boolean)FAKE_BOOLEAN_CONFIG_NO_DEFAULT.markAdvanced().isAdvanced());
    }

    @Test
    void testEnumConfigs() {
        ConfigProperty testConfig = ConfigProperty.key((String)"test.config").defaultValue((Object)TestEnum.TEST_VAL_B.name()).withDocumentation(TestEnum.class);
        String[] lines = testConfig.doc().split("\n");
        Assertions.assertEquals((Object)"org.apache.hudi.common.config.TestConfigProperty$TestEnum: Test enum description.", (Object)lines[0]);
        Assertions.assertEquals((Object)"    TEST_VAL_A: Test val a", (Object)lines[1]);
        Assertions.assertEquals((Object)"    TEST_VAL_B(default): Test val b", (Object)lines[2]);
        Assertions.assertEquals((Object)"    OTHER_VAL: Other val", (Object)lines[3]);
    }

    @Test
    void testGetSupportedVersions() {
        Assertions.assertEquals(Arrays.stream(new String[]{"a.b.c", "d.e.f"}).collect(Collectors.toList()), (Object)FAKE_STRING_CONFIG.getSupportedVersions());
        Assertions.assertEquals((Object)Collections.EMPTY_LIST, (Object)FAKE_INTEGER_CONFIG.getSupportedVersions());
    }

    @EnumDescription(value="Test enum description.")
    public static enum TestEnum {
        TEST_VAL_A,
        TEST_VAL_B,
        OTHER_VAL;

    }
}

