/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Properties;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieMetadataConfig {
    TestHoodieMetadataConfig() {
    }

    @Test
    void testGetRecordPreparationParallelism() {
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().build();
        Assertions.assertEquals((int)0, (int)config.getRecordPreparationParallelism());
        Properties props = new Properties();
        props.put(HoodieMetadataConfig.RECORD_PREPARATION_PARALLELISM.key(), "100");
        HoodieMetadataConfig configWithCustomValue = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
        Assertions.assertEquals((int)100, (int)configWithCustomValue.getRecordPreparationParallelism());
        Properties propsZero = new Properties();
        propsZero.put(HoodieMetadataConfig.RECORD_PREPARATION_PARALLELISM.key(), "0");
        HoodieMetadataConfig configWithZeroValue = HoodieMetadataConfig.newBuilder().fromProperties(propsZero).build();
        Assertions.assertEquals((int)0, (int)configWithZeroValue.getRecordPreparationParallelism());
        Properties propsNegative = new Properties();
        propsNegative.put(HoodieMetadataConfig.RECORD_PREPARATION_PARALLELISM.key(), "-50");
        HoodieMetadataConfig configWithNegativeValue = HoodieMetadataConfig.newBuilder().fromProperties(propsNegative).build();
        Assertions.assertEquals((int)-50, (int)configWithNegativeValue.getRecordPreparationParallelism());
    }

    @Test
    void testStreamingWritesCoalesceDivisorForDataTableWrites() {
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().build();
        Assertions.assertEquals((int)5000, (int)config.getStreamingWritesCoalesceDivisorForDataTableWrites());
        Properties props = new Properties();
        props.put(HoodieMetadataConfig.STREAMING_WRITE_DATATABLE_WRITE_STATUSES_COALESCE_DIVISOR.key(), "1");
        HoodieMetadataConfig configWithCustomValue = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
        Assertions.assertEquals((int)1, (int)configWithCustomValue.getStreamingWritesCoalesceDivisorForDataTableWrites());
        Properties propsZero = new Properties();
        propsZero.put(HoodieMetadataConfig.STREAMING_WRITE_DATATABLE_WRITE_STATUSES_COALESCE_DIVISOR.key(), "10000");
        HoodieMetadataConfig configWithZeroValue = HoodieMetadataConfig.newBuilder().fromProperties(propsZero).build();
        Assertions.assertEquals((int)10000, (int)configWithZeroValue.getStreamingWritesCoalesceDivisorForDataTableWrites());
    }

    @Test
    void testGlobalRLI() {
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().build();
        Assertions.assertFalse((boolean)config.isGlobalRecordLevelIndexEnabled());
        Properties props = new Properties();
        props.put("hoodie.metadata.record.index.enable", "true");
        HoodieMetadataConfig configWithCustomValue = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
        Assertions.assertTrue((boolean)configWithCustomValue.isGlobalRecordLevelIndexEnabled());
        props = new Properties();
        props.put(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), "true");
        configWithCustomValue = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
        Assertions.assertTrue((boolean)configWithCustomValue.isGlobalRecordLevelIndexEnabled());
    }
}

