/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Properties;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieStorageConfig {
    @Test
    void testHoodieStorageConfig() {
        String bloomFilterType = BloomFilterTypeCode.SIMPLE.name();
        Assertions.assertNotEquals((Object)((String)HoodieStorageConfig.BLOOM_FILTER_TYPE.defaultValue()).toUpperCase(), (Object)bloomFilterType.toUpperCase());
        Properties props = new Properties();
        props.put(HoodieStorageConfig.BLOOM_FILTER_TYPE.key(), bloomFilterType);
        HoodieStorageConfig config = HoodieStorageConfig.newBuilder().fromProperties(props).build();
        Assertions.assertEquals((Object)bloomFilterType, (Object)config.getBloomFilterType());
    }

    @Test
    void testBloomFilterBuilderWithAllValues() {
        String expectedFilterType = BloomFilterTypeCode.SIMPLE.name();
        int expectedNumEntries = 80000;
        double expectedFpp = 5.0E-9;
        int expectedDynamicMaxEntries = 150000;
        HoodieStorageConfig storageConfig = HoodieStorageConfig.newBuilder().withBloomFilterType(expectedFilterType).withBloomFilterNumEntries(expectedNumEntries).withBloomFilterFpp(expectedFpp).withBloomFilterDynamicMaxEntries(expectedDynamicMaxEntries).build();
        Assertions.assertEquals((Object)expectedFilterType, (Object)storageConfig.getString(HoodieStorageConfig.BLOOM_FILTER_TYPE));
        Assertions.assertEquals((int)expectedNumEntries, (Integer)storageConfig.getInt(HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE));
        Assertions.assertEquals((double)expectedFpp, (Double)storageConfig.getDouble(HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE));
        Assertions.assertEquals((int)expectedDynamicMaxEntries, (Integer)storageConfig.getInt(HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES));
    }

    @Test
    void testBloomFilterBuilderWithDefaultValues() {
        HoodieStorageConfig storageConfig = HoodieStorageConfig.newBuilder().build();
        Assertions.assertEquals((Object)HoodieStorageConfig.BLOOM_FILTER_TYPE.defaultValue(), (Object)storageConfig.getString(HoodieStorageConfig.BLOOM_FILTER_TYPE));
        Assertions.assertEquals((Object)HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE.defaultValue(), (Object)storageConfig.getString(HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE));
        Assertions.assertEquals((Object)HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE.defaultValue(), (Object)storageConfig.getString(HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE));
        Assertions.assertEquals((Object)HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES.defaultValue(), (Object)storageConfig.getString(HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES));
    }
}

