/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Properties;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class TestHoodieTimeGeneratorConfig {
    TestHoodieTimeGeneratorConfig() {
    }

    @ParameterizedTest
    @CsvSource(value={"org.apache.hudi.client.transaction.lock.InProcessLockProvider,1", "org.apache.hudi.client.transaction.lock.ZookeeperBasedLockProvider,200", ",1", "any_string,200"})
    void testMaxSkewDefaults(String lockProvider, long expected) {
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieCommonConfig.BASE_PATH.key(), "/tmp/path");
        if (!StringUtils.isNullOrEmpty((String)lockProvider)) {
            properties.setProperty("hoodie.write.lock.provider", lockProvider);
        }
        HoodieTimeGeneratorConfig config = HoodieTimeGeneratorConfig.newBuilder().fromProperties((Properties)properties).build();
        Assertions.assertEquals((long)expected, (long)config.getMaxExpectedClockSkewMs());
    }
}

