/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.common.data.CloseValidationIterator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class TestHoodieListData {
    TestHoodieListData() {
    }

    private static Stream<Arguments> distinctWithKey() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)"k1", (Object)1), Pair.of((Object)"k2", (Object)2)), Arrays.asList(Pair.of((Object)"k1", (Object)1), Pair.of((Object)"k1", (Object)10), Pair.of((Object)"k1", (Object)100), Pair.of((Object)"k2", (Object)2))}));
    }

    @ParameterizedTest
    @MethodSource
    void distinctWithKey(List<Pair<String, Integer>> expected, List<Pair<String, Integer>> originalList) {
        List distinctList = HoodieListData.eager(originalList).distinctWithKey(Pair::getLeft, 1).collectAsList();
        Assertions.assertEquals(expected, (Object)distinctList);
    }

    @Test
    void testEagerSemantic() {
        List<String> sourceList = Arrays.asList("quick", "brown", "fox");
        HoodieListData originalListData = HoodieListData.eager(sourceList);
        HoodieData lengthsListData = originalListData.map(String::length);
        List expectedLengths = sourceList.stream().map(String::length).collect(Collectors.toList());
        Assertions.assertEquals(expectedLengths, (Object)lengthsListData.collectAsList());
        Assertions.assertEquals((long)3L, (long)originalListData.count());
        Assertions.assertEquals(sourceList, (Object)originalListData.collectAsList());
    }

    @Test
    public void testGetNumPartitions() {
        HoodieListData listData = HoodieListData.eager(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()));
        Assertions.assertEquals((int)1, (int)listData.getNumPartitions());
    }

    @Test
    public void testIsEmpty() {
        HoodieListData listData = HoodieListData.eager(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()));
        Assertions.assertFalse((boolean)listData.isEmpty());
        HoodieListData emptyListData = HoodieListData.eager(Collections.emptyList());
        Assertions.assertTrue((boolean)emptyListData.isEmpty());
        listData = HoodieListData.lazy(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()));
        Assertions.assertFalse((boolean)listData.isEmpty());
        emptyListData = HoodieListData.lazy(Collections.emptyList());
        Assertions.assertTrue((boolean)emptyListData.isEmpty());
    }

    @Test
    void testCloseableIterator() {
        ClosableIterator iterator = (ClosableIterator)Mockito.spy((Object)ClosableIterator.wrap(Arrays.asList("value1", "value2").iterator()));
        HoodieListData listData = HoodieListData.lazy((Iterator)iterator);
        List values = listData.collectAsList();
        Assertions.assertEquals(Arrays.asList("value1", "value2"), (Object)values);
        ((ClosableIterator)Mockito.verify((Object)iterator)).close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testMapPartitionsWithCloseable(boolean isLazy) {
        String partition1 = "partition1";
        String partition2 = "partition2";
        HoodieListData input = new HoodieListData(Stream.of(partition1, partition2), isLazy);
        CloseValidationIterator<String> iterator = new CloseValidationIterator<String>(Collections.singletonList("value").iterator());
        Assertions.assertEquals((int)1, (int)input.mapPartitions((SerializableFunction & Serializable)partition -> iterator, true).collectAsList().size());
        Assertions.assertTrue((boolean)iterator.isClosed());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testFlatMapWithCloseable(boolean isLazy) {
        String partition1 = "partition1";
        String partition2 = "partition2";
        CloseValidationIterator<String> iterator1 = new CloseValidationIterator<String>(Collections.singletonList("value").iterator());
        CloseValidationIterator<String> iterator2 = new CloseValidationIterator<String>(Collections.singletonList("value").iterator());
        HoodieListData input = new HoodieListData(Stream.of(partition1, partition2), isLazy);
        Assertions.assertEquals((int)2, (int)input.flatMap((SerializableFunction & Serializable)partition -> partition.equals(partition1) ? iterator1 : iterator2).collectAsList().size());
        Assertions.assertTrue((boolean)iterator1.isClosed());
        Assertions.assertTrue((boolean)iterator2.isClosed());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testFlatMapToPairWithCloseable(boolean isLazy) {
        String partition1 = "partition1";
        String partition2 = "partition2";
        HoodieListData input = new HoodieListData(Stream.of(partition1, partition2), isLazy);
        CloseValidationIterator<Pair> iterator1 = new CloseValidationIterator<Pair>(Collections.singletonList(Pair.of((Object)"1", (Object)"value")).iterator());
        CloseValidationIterator<Pair> iterator2 = new CloseValidationIterator<Pair>(Collections.singletonList(Pair.of((Object)"2", (Object)"value")).iterator());
        Assertions.assertEquals((int)2, (int)input.flatMapToPair((SerializableFunction & Serializable)partition -> partition.equals(partition1) ? iterator1 : iterator2).collectAsList().size());
        Assertions.assertTrue((boolean)iterator1.isClosed());
        Assertions.assertTrue((boolean)iterator2.isClosed());
    }
}

