/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import org.apache.hudi.common.util.DefaultJavaTypeConverter;
import org.apache.hudi.common.util.JavaTypeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDefaultJavaTypeConverter {
    private final JavaTypeConverter typeHandler = new DefaultJavaTypeConverter();

    TestDefaultJavaTypeConverter() {
    }

    @Test
    void testCastToBoolean_withBooleanTrue() {
        Assertions.assertTrue((boolean)this.typeHandler.castToBoolean((Object)true));
    }

    @Test
    void testCastToBoolean_withBooleanFalse() {
        Assertions.assertFalse((boolean)this.typeHandler.castToBoolean((Object)false));
    }

    @Test
    void testCastToBoolean_withInvalidType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.typeHandler.castToBoolean((Object)"true"), (String)"cannot be cast to boolean");
    }

    @Test
    void testCastToString_withNonNullValue() {
        Assertions.assertEquals((Object)"123", (Object)this.typeHandler.castToString((Object)123));
        Assertions.assertEquals((Object)"true", (Object)this.typeHandler.castToString((Object)true));
    }

    @Test
    void testCastToString_withNullValue() {
        Assertions.assertNull((Object)this.typeHandler.castToString(null));
    }
}

