/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hudi.common.fs.SizeAwareDataInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSizeAwareDataInputStream {
    private SizeAwareDataInputStream sizeAwareDataInputStream;
    private ByteArrayInputStream byteArrayInputStream;

    @BeforeEach
    void setUp() {
        byte[] data = new byte[]{0, 0, 0, 1, 2, 3, 4, 5};
        this.byteArrayInputStream = new ByteArrayInputStream(data);
        this.sizeAwareDataInputStream = new SizeAwareDataInputStream(new DataInputStream(this.byteArrayInputStream));
    }

    @Test
    void testReadInt() throws IOException {
        int value = this.sizeAwareDataInputStream.readInt();
        Assertions.assertEquals((int)1, (int)value);
        Assertions.assertEquals((int)4, (int)this.sizeAwareDataInputStream.getNumberOfBytesRead());
    }

    @Test
    void testReadFully() throws IOException {
        byte[] buffer = new byte[4];
        this.sizeAwareDataInputStream.readFully(buffer);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 1}, (byte[])buffer);
        Assertions.assertEquals((int)4, (int)this.sizeAwareDataInputStream.getNumberOfBytesRead());
    }

    @Test
    void testReadFullyWithOffset() throws IOException {
        byte[] buffer = new byte[6];
        this.sizeAwareDataInputStream.readFully(buffer, 2, 4);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0, 0, 0, 1}, (byte[])buffer);
        Assertions.assertEquals((int)4, (int)this.sizeAwareDataInputStream.getNumberOfBytesRead());
    }

    @Test
    void testSkipBytes() throws IOException {
        int skipped = this.sizeAwareDataInputStream.skipBytes(2);
        Assertions.assertEquals((int)2, (int)skipped);
        Assertions.assertEquals((int)2, (int)this.sizeAwareDataInputStream.getNumberOfBytesRead());
    }

    @Test
    void testSkipBytesBeyondAvailable() throws IOException {
        this.sizeAwareDataInputStream.readInt();
        int skipped = this.sizeAwareDataInputStream.skipBytes(10);
        Assertions.assertEquals((int)4, (int)skipped);
        Assertions.assertEquals((int)8, (int)this.sizeAwareDataInputStream.getNumberOfBytesRead());
    }

    @Test
    void testExceptionHandling() {
        byte[] buffer = new byte[10];
        Assertions.assertThrows(EOFException.class, () -> this.sizeAwareDataInputStream.readFully(buffer));
        Assertions.assertEquals((int)0, (int)this.sizeAwareDataInputStream.getNumberOfBytesRead(), (String)"Number of bytes read should remain consistent after exception.");
    }
}

