/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.storage.StoragePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileSlice {
    private static final String PARTITION_PATH = "test_partition";
    private static final String FILE_ID = "test_file_id";
    private static final String BASE_INSTANT = "001";

    @Test
    void testGetLatestInstantTime() {
        String baseInstant = "003";
        String deltaInstant2 = "002";
        String deltaInstant4 = "004";
        FileSlice fileSlice = new FileSlice("par1", baseInstant, "fg1");
        MatcherAssert.assertThat((Object)fileSlice.getLatestInstantTime(), (Matcher)CoreMatchers.is((Object)baseInstant));
        fileSlice.addLogFile(new HoodieLogFile(new StoragePath(TestFileSlice.getLogFileName(deltaInstant2))));
        MatcherAssert.assertThat((Object)fileSlice.getLatestInstantTime(), (Matcher)CoreMatchers.is((Object)baseInstant));
        fileSlice.addLogFile(new HoodieLogFile(new StoragePath(TestFileSlice.getLogFileName(deltaInstant4))));
        MatcherAssert.assertThat((Object)fileSlice.getLatestInstantTime(), (Matcher)CoreMatchers.is((Object)deltaInstant4));
    }

    private static String getLogFileName(String instantTime) {
        return ".fg1_" + instantTime + ".log.1_1-0-1";
    }

    @Test
    public void testGetAllFilesWithBaseFileOnly() {
        HoodieBaseFile baseFile = new HoodieBaseFile("file://test_partition/test_base_file.parquet");
        FileSlice fileSlice = new FileSlice(new HoodieFileGroupId(PARTITION_PATH, FILE_ID), BASE_INSTANT, baseFile, Collections.emptyList());
        List allFiles = fileSlice.getAllFileNames();
        Assertions.assertEquals((int)1, (int)allFiles.size());
        Assertions.assertTrue((boolean)allFiles.contains(baseFile.getFileName()));
    }

    @Test
    public void testGetAllFilesWithLogFilesOnly() {
        HoodieLogFile logFile1 = new HoodieLogFile(new StoragePath("test_partition/.test_file_id_002.log.1"));
        HoodieLogFile logFile2 = new HoodieLogFile(new StoragePath("test_partition/.test_file_id_003.log.2"));
        FileSlice fileSlice = new FileSlice(new HoodieFileGroupId(PARTITION_PATH, FILE_ID), BASE_INSTANT, null, Arrays.asList(logFile1, logFile2));
        List allFiles = fileSlice.getAllFileNames();
        Assertions.assertEquals((int)2, (int)allFiles.size());
        Assertions.assertTrue((boolean)allFiles.contains(logFile1.getFileName()));
        Assertions.assertTrue((boolean)allFiles.contains(logFile2.getFileName()));
    }

    @Test
    public void testGetAllFilesWithBaseFileAndLogFiles() {
        HoodieBaseFile baseFile = new HoodieBaseFile("file://test_partition/test_base_file.parquet");
        HoodieLogFile logFile1 = new HoodieLogFile(new StoragePath("test_partition/.test_file_id_004.log.1"));
        HoodieLogFile logFile2 = new HoodieLogFile(new StoragePath("test_partition/.test_file_id_005.log.2"));
        FileSlice fileSlice = new FileSlice(new HoodieFileGroupId(PARTITION_PATH, FILE_ID), BASE_INSTANT, baseFile, Arrays.asList(logFile1, logFile2));
        List allFiles = fileSlice.getAllFileNames();
        Assertions.assertEquals((int)3, (int)allFiles.size());
        Assertions.assertTrue((boolean)allFiles.contains(baseFile.getFileName()));
        Assertions.assertTrue((boolean)allFiles.contains(logFile1.getFileName()));
        Assertions.assertTrue((boolean)allFiles.contains(logFile2.getFileName()));
    }

    @Test
    public void testGetAllFilesEmptyFileSlice() {
        FileSlice fileSlice = new FileSlice(PARTITION_PATH, BASE_INSTANT, FILE_ID);
        List allFiles = fileSlice.getAllFileNames();
        Assertions.assertEquals((int)0, (int)allFiles.size());
    }
}

