/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieBaseFile {
    private final String fileName = "136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet";
    private final String pathStr = "file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet";
    private final String fileId = "136281f3-c24e-423b-a65a-95dbfbddce1d";
    private final String baseCommitTime = "100";
    private final int length = 10;
    private final short blockReplication = (short)2;
    private final long blockSize = 1000000L;

    @Test
    void createFromHoodieBaseFile() {
        StoragePathInfo pathInfo = new StoragePathInfo(new StoragePath("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet"), 10L, false, 2, 1000000L, 0L);
        HoodieBaseFile hoodieBaseFile = new HoodieBaseFile(pathInfo);
        this.assertFileGetters(pathInfo, new HoodieBaseFile(hoodieBaseFile), 10L, (Option<HoodieBaseFile>)Option.empty());
    }

    @Test
    void createFromFileStatus() {
        StoragePathInfo pathInfo = new StoragePathInfo(new StoragePath("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet"), 10L, false, 2, 1000000L, 0L);
        HoodieBaseFile hoodieBaseFile = new HoodieBaseFile(pathInfo);
        this.assertFileGetters(pathInfo, hoodieBaseFile, 10L, (Option<HoodieBaseFile>)Option.empty());
    }

    @Test
    void createFromFileStatusAndBootstrapBaseFile() {
        HoodieBaseFile bootstrapBaseFile = new HoodieBaseFile("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet");
        StoragePathInfo pathInfo = new StoragePathInfo(new StoragePath("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet"), 10L, false, 2, 1000000L, 0L);
        HoodieBaseFile hoodieBaseFile = new HoodieBaseFile(pathInfo, (BaseFile)bootstrapBaseFile);
        this.assertFileGetters(pathInfo, hoodieBaseFile, 10L, (Option<HoodieBaseFile>)Option.of((Object)bootstrapBaseFile));
    }

    @Test
    void createFromFilePath() {
        HoodieBaseFile hoodieBaseFile = new HoodieBaseFile("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet");
        this.assertFileGetters(null, hoodieBaseFile, -1L, (Option<HoodieBaseFile>)Option.empty());
    }

    @Test
    void createFromFilePathAndBootstrapBaseFile() {
        HoodieBaseFile bootstrapBaseFile = new HoodieBaseFile("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet");
        HoodieBaseFile hoodieBaseFile = new HoodieBaseFile("file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet", (BaseFile)bootstrapBaseFile);
        this.assertFileGetters(null, hoodieBaseFile, -1L, (Option<HoodieBaseFile>)Option.of((Object)bootstrapBaseFile));
    }

    @Test
    void createFromExternalFileStatus() {
        String fileName = "parquet_file_1.parquet";
        String storedPathString = "file:/tmp/hoodie/2021/01/01/" + fileName + "_" + "100" + "_hudiext";
        String expectedPathString = "file:/tmp/hoodie/2021/01/01/" + fileName;
        StoragePathInfo inputPathInfo = new StoragePathInfo(new StoragePath(storedPathString), 10L, false, 2, 1000000L, 0L);
        StoragePathInfo expectedPathInfo = new StoragePathInfo(new StoragePath(expectedPathString), 10L, false, 2, 1000000L, 0L);
        HoodieBaseFile hoodieBaseFile = new HoodieBaseFile(inputPathInfo);
        this.assertFileGetters(expectedPathInfo, hoodieBaseFile, 10L, (Option<HoodieBaseFile>)Option.empty(), fileName, expectedPathString, fileName);
    }

    private void assertFileGetters(StoragePathInfo pathInfo, HoodieBaseFile hoodieBaseFile, long fileLength, Option<HoodieBaseFile> bootstrapBaseFile) {
        this.assertFileGetters(pathInfo, hoodieBaseFile, fileLength, bootstrapBaseFile, "136281f3-c24e-423b-a65a-95dbfbddce1d", "file:/tmp/hoodie/2021/01/01/136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet", "136281f3-c24e-423b-a65a-95dbfbddce1d_1-0-1_100.parquet");
    }

    private void assertFileGetters(StoragePathInfo pathInfo, HoodieBaseFile hoodieBaseFile, long fileLength, Option<HoodieBaseFile> bootstrapBaseFile, String fileId, String pathStr, String fileName) {
        Assertions.assertEquals((Object)fileId, (Object)hoodieBaseFile.getFileId());
        Assertions.assertEquals((Object)"100", (Object)hoodieBaseFile.getCommitTime());
        Assertions.assertEquals(bootstrapBaseFile, (Object)hoodieBaseFile.getBootstrapBaseFile());
        Assertions.assertEquals((Object)fileName, (Object)hoodieBaseFile.getFileName());
        Assertions.assertEquals((Object)pathStr, (Object)hoodieBaseFile.getPath());
        Assertions.assertEquals((Object)new StoragePath(pathStr), (Object)hoodieBaseFile.getStoragePath());
        Assertions.assertEquals((long)fileLength, (long)hoodieBaseFile.getFileSize());
        Assertions.assertEquals((Object)pathInfo, (Object)hoodieBaseFile.getPathInfo());
    }
}

