/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHoodieCommitMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHoodieCommitMetadata.class);
    private static final List<String> EXPECTED_FIELD_NAMES = Arrays.asList("partitionToWriteStats", "compacted", "extraMetadata", "operationType");

    public static void verifyMetadataFieldNames(HoodieCommitMetadata commitMetadata, List<String> expectedFieldNameList) throws IOException {
        String serializedCommitMetadata = commitMetadata.toJsonString();
        List actualFieldNameList = CollectionUtils.toStream((Iterator)JsonUtils.getObjectMapper().readTree(serializedCommitMetadata).fieldNames()).collect(Collectors.toList());
        Assertions.assertEquals(expectedFieldNameList.stream().sorted().collect(Collectors.toList()), actualFieldNameList.stream().sorted().collect(Collectors.toList()));
    }

    @Test
    public void verifyFieldNamesInCommitMetadata() throws IOException {
        List<HoodieWriteStat> fakeHoodieWriteStats = HoodieTestUtils.generateFakeHoodieWriteStat(10);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        fakeHoodieWriteStats.forEach(stat -> commitMetadata.addWriteStat(stat.getPartitionPath(), stat));
        TestHoodieCommitMetadata.verifyMetadataFieldNames(commitMetadata, EXPECTED_FIELD_NAMES);
    }

    @Test
    public void testPerfStatPresenceInHoodieMetadata() throws Exception {
        List<HoodieWriteStat> fakeHoodieWriteStats = HoodieTestUtils.generateFakeHoodieWriteStat(100);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        fakeHoodieWriteStats.forEach(stat -> commitMetadata.addWriteStat(stat.getPartitionPath(), stat));
        Assertions.assertTrue((commitMetadata.getTotalCreateTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalUpsertTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalScanTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalLogFilesCompacted() > 0L ? 1 : 0) != 0);
        String serializedCommitMetadata = commitMetadata.toJsonString();
        HoodieCommitMetadata metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromJsonString((String)serializedCommitMetadata, HoodieCommitMetadata.class);
        Assertions.assertTrue((commitMetadata.getTotalCreateTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalUpsertTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((commitMetadata.getTotalScanTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((metadata.getTotalLogFilesCompacted() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompatibilityWithoutOperationType() throws Exception {
        String serializedCommitMetadata = FileIOUtils.readAsUTFString((InputStream)TestHoodieCommitMetadata.class.getResourceAsStream("/old-version.commit"));
        HoodieCommitMetadata metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromJsonString((String)serializedCommitMetadata, HoodieCommitMetadata.class);
        Assertions.assertSame((Object)metadata.getOperationType(), (Object)WriteOperationType.UNKNOWN);
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        Assertions.assertSame((Object)commitMetadata.getOperationType(), (Object)WriteOperationType.INSERT);
        serializedCommitMetadata = commitMetadata.toJsonString();
        metadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromJsonString((String)serializedCommitMetadata, HoodieCommitMetadata.class);
        Assertions.assertSame((Object)metadata.getOperationType(), (Object)WriteOperationType.INSERT);
    }

    @Test
    public void testGetFileSliceForFileGroupFromDeltaCommit() throws IOException {
        org.apache.hudi.avro.model.HoodieCommitMetadata commitMetadata = new org.apache.hudi.avro.model.HoodieCommitMetadata();
        org.apache.hudi.avro.model.HoodieWriteStat writeStat1 = this.createWriteStat("111", "111base", Arrays.asList("1.log", "2.log"));
        org.apache.hudi.avro.model.HoodieWriteStat writeStat2 = this.createWriteStat("111", "111base", Arrays.asList("3.log", "4.log"));
        org.apache.hudi.avro.model.HoodieWriteStat writeStat3 = this.createWriteStat("222", null, Collections.singletonList("5.log"));
        HashMap<String, List<org.apache.hudi.avro.model.HoodieWriteStat>> partitionToWriteStatsMap = new HashMap<String, List<org.apache.hudi.avro.model.HoodieWriteStat>>();
        partitionToWriteStatsMap.put("partition1", Arrays.asList(writeStat2, writeStat3));
        partitionToWriteStatsMap.put("partition2", Collections.singletonList(writeStat1));
        commitMetadata.setPartitionToWriteStats(partitionToWriteStatsMap);
        byte[] serializedCommitMetadata = (byte[])TimelineMetadataUtils.serializeAvroMetadata((SpecificRecordBase)commitMetadata, org.apache.hudi.avro.model.HoodieCommitMetadata.class).get();
        Option result = HoodieCommitMetadata.getFileSliceForFileGroupFromDeltaCommit((InputStream)new ByteArrayInputStream(serializedCommitMetadata), (HoodieFileGroupId)new HoodieFileGroupId("partition1", "111"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)"111base", (Object)((Pair)result.get()).getKey());
        Assertions.assertEquals((int)2, (int)((List)((Pair)result.get()).getValue()).size());
        Assertions.assertEquals((Object)"3.log", ((List)((Pair)result.get()).getValue()).get(0));
        Assertions.assertEquals((Object)"4.log", ((List)((Pair)result.get()).getValue()).get(1));
        result = HoodieCommitMetadata.getFileSliceForFileGroupFromDeltaCommit((InputStream)new ByteArrayInputStream(serializedCommitMetadata), (HoodieFileGroupId)new HoodieFileGroupId("partition1", "222"));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertTrue((boolean)((String)((Pair)result.get()).getKey()).isEmpty());
        Assertions.assertEquals((int)1, (int)((List)((Pair)result.get()).getValue()).size());
        Assertions.assertEquals((Object)"5.log", ((List)((Pair)result.get()).getValue()).get(0));
    }

    @Test
    public void testCommitMetadataSerde() throws Exception {
        org.apache.hudi.avro.model.HoodieCommitMetadata commitMetadata = new org.apache.hudi.avro.model.HoodieCommitMetadata();
        org.apache.hudi.avro.model.HoodieWriteStat writeStat1 = this.createWriteStat("111", "111base", Arrays.asList("1.log", "2.log"));
        org.apache.hudi.avro.model.HoodieWriteStat writeStat2 = this.createWriteStat("222", "222base", Arrays.asList("3.log", "4.log"));
        org.apache.hudi.avro.model.HoodieWriteStat writeStat3 = this.createWriteStat("333", null, Collections.singletonList("5.log"));
        HashMap<String, List<org.apache.hudi.avro.model.HoodieWriteStat>> partitionToWriteStatsMap = new HashMap<String, List<org.apache.hudi.avro.model.HoodieWriteStat>>();
        partitionToWriteStatsMap.put("partition1", Arrays.asList(writeStat1, writeStat2));
        partitionToWriteStatsMap.put("partition2", Collections.singletonList(writeStat3));
        commitMetadata.setPartitionToWriteStats(partitionToWriteStatsMap);
        byte[] serializedCommitMetadata = (byte[])TimelineMetadataUtils.serializeAvroMetadata((SpecificRecordBase)commitMetadata, org.apache.hudi.avro.model.HoodieCommitMetadata.class).get();
        HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        HoodieCommitMetadata commitMetadata1 = (HoodieCommitMetadata)HoodieTestUtils.COMMIT_METADATA_SER_DE.deserialize(instant, (InputStream)new ByteArrayInputStream(serializedCommitMetadata), () -> false, HoodieCommitMetadata.class);
        Assertions.assertEquals((int)2, (int)commitMetadata1.partitionToWriteStats.size());
        Assertions.assertEquals((int)2, (int)((List)commitMetadata1.partitionToWriteStats.get("partition1")).size());
        Assertions.assertEquals((int)2, (int)((List)commitMetadata1.partitionToWriteStats.get("partition1")).size());
        Assertions.assertEquals((Object)"111", (Object)((HoodieWriteStat)((List)commitMetadata1.partitionToWriteStats.get("partition1")).get(0)).getFileId());
        Assertions.assertEquals((Object)"222", (Object)((HoodieWriteStat)((List)commitMetadata1.partitionToWriteStats.get("partition1")).get(1)).getFileId());
        Assertions.assertEquals((Object)"333", (Object)((HoodieWriteStat)((List)commitMetadata1.partitionToWriteStats.get("partition2")).get(0)).getFileId());
        HoodieInstant legacyInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1", "1", true);
        CommitMetadataSerDeV1 v1SerDe = new CommitMetadataSerDeV1();
        byte[] v1Bytes = TimelineMetadataUtils.convertMetadataToByteArray((Object)commitMetadata1, (CommitMetadataSerDe)v1SerDe);
        HoodieCommitMetadata commitMetadata2 = (HoodieCommitMetadata)HoodieTestUtils.COMMIT_METADATA_SER_DE.deserialize(legacyInstant, (InputStream)new ByteArrayInputStream(v1Bytes), () -> false, HoodieCommitMetadata.class);
        Assertions.assertEquals((int)2, (int)commitMetadata2.partitionToWriteStats.size());
        Assertions.assertEquals((int)2, (int)((List)commitMetadata2.partitionToWriteStats.get("partition1")).size());
        Assertions.assertEquals((int)2, (int)((List)commitMetadata2.partitionToWriteStats.get("partition1")).size());
        Assertions.assertEquals((Object)"111", (Object)((HoodieWriteStat)((List)commitMetadata2.partitionToWriteStats.get("partition1")).get(0)).getFileId());
        Assertions.assertEquals((Object)"222", (Object)((HoodieWriteStat)((List)commitMetadata2.partitionToWriteStats.get("partition1")).get(1)).getFileId());
        Assertions.assertEquals((Object)"333", (Object)((HoodieWriteStat)((List)commitMetadata2.partitionToWriteStats.get("partition2")).get(0)).getFileId());
    }

    private org.apache.hudi.avro.model.HoodieWriteStat createWriteStat(String fileId, String baseFile, List<String> logFiles) {
        org.apache.hudi.avro.model.HoodieWriteStat writeStat = new org.apache.hudi.avro.model.HoodieWriteStat();
        writeStat.setFileId(fileId);
        writeStat.setBaseFile(baseFile);
        writeStat.setLogFiles(logFiles);
        return writeStat;
    }

    @Test
    public void testSchemaEqualityForHoodieCommitMetaData() {
        Schema avroSchema = org.apache.hudi.avro.model.HoodieCommitMetadata.SCHEMA$;
        Schema pojoSchema = ReflectData.get().getSchema(HoodieCommitMetadata.class);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isSchemaCompatible((Schema)this.replaceEnumWithString(pojoSchema), (Schema)avroSchema, (boolean)false, (boolean)false));
    }

    @Test
    public void testSchemaEqualityForHoodieReplaceCommitMetaData() {
        Schema avroSchema = org.apache.hudi.avro.model.HoodieReplaceCommitMetadata.SCHEMA$;
        Schema pojoSchema = ReflectData.get().getSchema(HoodieReplaceCommitMetadata.class);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isSchemaCompatible((Schema)this.replaceEnumWithString(pojoSchema), (Schema)avroSchema, (boolean)false, (boolean)false));
    }

    private Schema replaceEnumWithString(Schema schema) {
        if (schema.getType() == Schema.Type.ENUM) {
            return Schema.create((Schema.Type)Schema.Type.STRING);
        }
        if (schema.getType() == Schema.Type.RECORD) {
            ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
            for (Schema.Field field : schema.getFields()) {
                Schema newFieldSchema = this.replaceEnumWithString(field.schema());
                newFields.add(HoodieAvroUtils.createNewSchemaField((String)field.name(), (Schema)newFieldSchema, (String)field.doc(), (Object)field.defaultVal()));
            }
            return Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false, newFields);
        }
        if (schema.getType() == Schema.Type.UNION) {
            ArrayList<Schema> types = new ArrayList<Schema>();
            for (Schema type : schema.getTypes()) {
                types.add(this.replaceEnumWithString(type));
            }
            return Schema.createUnion(types);
        }
        if (schema.getType() == Schema.Type.ARRAY) {
            return Schema.createArray((Schema)this.replaceEnumWithString(schema.getElementType()));
        }
        if (schema.getType() == Schema.Type.MAP) {
            return Schema.createMap((Schema)this.replaceEnumWithString(schema.getValueType()));
        }
        return schema;
    }
}

