/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHoodieIndexMetadata {
    @Test
    void testSerDeWithIgnoredFields() throws Exception {
        String indexName = MetadataPartitionType.EXPRESSION_INDEX.getPartitionPath() + "idx";
        HoodieIndexDefinition def = HoodieIndexDefinition.newBuilder().withIndexName(indexName).withIndexType("column_stats").withIndexFunction("identity").withVersion(HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)HoodieTableVersion.current(), (String)indexName)).withSourceFields(Arrays.asList("a", "b", "c")).withIndexOptions(Collections.emptyMap()).build();
        MatcherAssert.assertThat((Object)def.getSourceFieldsKey(), (Matcher)CoreMatchers.is((Object)"a.b.c"));
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(Collections.singletonMap(indexName, def));
        String serialized = indexMetadata.toJson();
        Assertions.assertFalse((boolean)serialized.contains("sourceFieldsKey"), (String)"The field 'sourceFieldsKey' should be ignored in serialization");
        HoodieIndexMetadata deserialized = HoodieIndexMetadata.fromJson((String)serialized);
        Map indexDefinitionMap = deserialized.getIndexDefinitions();
        MatcherAssert.assertThat((Object)indexDefinitionMap.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HoodieIndexDefinition)indexDefinitionMap.values().iterator().next()).getSourceFieldsKey(), (Matcher)CoreMatchers.is((Object)"a.b.c"));
    }

    @Test
    void testHasIndex() {
        HashMap<String, HoodieIndexDefinition> indexes = new HashMap<String, HoodieIndexDefinition>();
        HoodieIndexDefinition colStatsIndex = HoodieIndexDefinition.newBuilder().withIndexName("column_stats").withIndexType("column_stats").withSourceFields(Arrays.asList("col1", "col2")).build();
        HoodieIndexDefinition secondaryIndex = HoodieIndexDefinition.newBuilder().withIndexName("secondary_index_price").withIndexType("secondary_index").withSourceFields(Collections.singletonList("price")).build();
        indexes.put("column_stats", colStatsIndex);
        indexes.put("secondary_index_price", secondaryIndex);
        HoodieIndexMetadata metadata = new HoodieIndexMetadata(indexes);
        Assertions.assertTrue((boolean)metadata.hasIndex("column_stats"));
        Assertions.assertTrue((boolean)metadata.hasIndex("secondary_index_price"));
        Assertions.assertFalse((boolean)metadata.hasIndex("non_existent_index"));
        Assertions.assertFalse((boolean)metadata.hasIndex(null));
        HoodieIndexMetadata emptyMetadata = new HoodieIndexMetadata();
        Assertions.assertFalse((boolean)emptyMetadata.hasIndex("any_index"));
    }

    @Test
    void testGetIndex() {
        HashMap<String, HoodieIndexDefinition> indexes = new HashMap<String, HoodieIndexDefinition>();
        HoodieIndexDefinition colStatsIndex = HoodieIndexDefinition.newBuilder().withIndexName("column_stats").withIndexType("column_stats").withSourceFields(Arrays.asList("col1", "col2")).build();
        HoodieIndexDefinition secondaryIndex = HoodieIndexDefinition.newBuilder().withIndexName("secondary_index_price").withIndexType("secondary_index").withSourceFields(Collections.singletonList("price")).build();
        indexes.put("column_stats", colStatsIndex);
        indexes.put("secondary_index_price", secondaryIndex);
        HoodieIndexMetadata metadata = new HoodieIndexMetadata(indexes);
        Option colStatsOpt = metadata.getIndex("column_stats");
        Assertions.assertTrue((boolean)colStatsOpt.isPresent());
        Assertions.assertEquals((Object)"column_stats", (Object)((HoodieIndexDefinition)colStatsOpt.get()).getIndexName());
        Assertions.assertEquals((Object)"column_stats", (Object)((HoodieIndexDefinition)colStatsOpt.get()).getIndexType());
        Option secondaryOpt = metadata.getIndex("secondary_index_price");
        Assertions.assertTrue((boolean)secondaryOpt.isPresent());
        Assertions.assertEquals((Object)"secondary_index_price", (Object)((HoodieIndexDefinition)secondaryOpt.get()).getIndexName());
        Assertions.assertEquals((Object)"secondary_index", (Object)((HoodieIndexDefinition)secondaryOpt.get()).getIndexType());
        Option nonExistentOpt = metadata.getIndex("non_existent_index");
        Assertions.assertFalse((boolean)nonExistentOpt.isPresent());
        Option nullOpt = metadata.getIndex(null);
        Assertions.assertFalse((boolean)nullOpt.isPresent());
        HoodieIndexMetadata emptyMetadata = new HoodieIndexMetadata();
        Option emptyOpt = emptyMetadata.getIndex("any_index");
        Assertions.assertFalse((boolean)emptyOpt.isPresent());
    }

    @Test
    void testNoColStatsNoPartitionStats() {
        HoodieIndexMetadata metadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        Mockito.when((Object)metadata.getIndex("column_stats")).thenReturn((Object)Option.empty());
        Mockito.when((Object)metadata.getIndex("partition_stats")).thenReturn((Object)Option.empty());
        Assertions.assertDoesNotThrow(() -> HoodieIndexMetadata.validateIndexMetadata((HoodieIndexMetadata)metadata));
    }

    @Test
    void testColStatsNoPartitionStats() {
        HoodieIndexMetadata metadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexDefinition colStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)metadata.getIndex("column_stats")).thenReturn((Object)Option.of((Object)colStats));
        Mockito.when((Object)metadata.getIndex("partition_stats")).thenReturn((Object)Option.empty());
        Assertions.assertDoesNotThrow(() -> HoodieIndexMetadata.validateIndexMetadata((HoodieIndexMetadata)metadata));
    }

    @Test
    void testColStatsPartitionStatsSameVersion() {
        HoodieIndexMetadata metadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexDefinition colStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        HoodieIndexDefinition partitionStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)metadata.getIndex("column_stats")).thenReturn((Object)Option.of((Object)colStats));
        Mockito.when((Object)metadata.getIndex("partition_stats")).thenReturn((Object)Option.of((Object)partitionStats));
        Mockito.when((Object)colStats.getVersion()).thenReturn((Object)HoodieIndexVersion.V1);
        Mockito.when((Object)partitionStats.getVersion()).thenReturn((Object)HoodieIndexVersion.V1);
        Assertions.assertDoesNotThrow(() -> HoodieIndexMetadata.validateIndexMetadata((HoodieIndexMetadata)metadata));
    }

    @Test
    void testColStatsPartitionStatsDifferentVersions() {
        HoodieIndexMetadata metadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexDefinition colStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        HoodieIndexDefinition partitionStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)metadata.getIndex("column_stats")).thenReturn((Object)Option.of((Object)colStats));
        Mockito.when((Object)metadata.getIndex("partition_stats")).thenReturn((Object)Option.of((Object)partitionStats));
        Mockito.when((Object)colStats.getVersion()).thenReturn((Object)HoodieIndexVersion.V1);
        Mockito.when((Object)partitionStats.getVersion()).thenReturn((Object)HoodieIndexVersion.V2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexMetadata.validateIndexMetadata((HoodieIndexMetadata)metadata));
    }
}

