/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.util.Utf8;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.stats.HoodieColumnRangeMetadata;
import org.apache.hudi.stats.ValueMetadata;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieWriteStat {
    @Test
    public void testSetPaths() {
        String instantTime = TimelineUtils.formatDate((java.util.Date)new java.util.Date());
        String basePathString = "/data/tables/some-hoodie-table";
        String partitionPathString = "2017/12/31";
        String fileName = UUID.randomUUID().toString();
        String writeToken = "1-0-1";
        StoragePath basePath = new StoragePath(basePathString);
        StoragePath partitionPath = new StoragePath(basePath, partitionPathString);
        StoragePath finalizeFilePath = new StoragePath(partitionPath, FSUtils.makeBaseFileName((String)instantTime, (String)writeToken, (String)fileName, (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setPath(basePath, finalizeFilePath);
        Assertions.assertEquals((Object)finalizeFilePath, (Object)new StoragePath(basePath, writeStat.getPath()));
        StoragePath prevBaseFilePath = new StoragePath(partitionPath, FSUtils.makeBaseFileName((String)instantTime, (String)"2-0-3", (String)fileName, (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()));
        writeStat.setPrevBaseFile(prevBaseFilePath.toString());
        Assertions.assertEquals((Object)prevBaseFilePath.toString(), (Object)writeStat.getPrevBaseFile());
        writeStat = new HoodieWriteStat();
        writeStat.setPath(basePath, finalizeFilePath);
        Assertions.assertEquals((Object)finalizeFilePath, (Object)new StoragePath(basePath, writeStat.getPath()));
        Assertions.assertNull((Object)writeStat.getTempPath());
    }

    @Test
    public void testRecordsStats() {
        AtomicInteger counter;
        Random random = new Random();
        String fileName = "file.parquet";
        String targetColNamePrefix = "col";
        ArrayList<Object> minMaxValues = new ArrayList<Object>();
        minMaxValues.add(Pair.of((Object)"abcdec", (Object)"zyxwvu"));
        minMaxValues.add(Pair.of((Object)new Utf8(StringUtils.getUTF8Bytes((String)"abcdec")), (Object)new Utf8(StringUtils.getUTF8Bytes((String)"zyxwvu"))));
        minMaxValues.add(Pair.of((Object)new Integer(-1000), (Object)new Integer(999999)));
        minMaxValues.add(Pair.of((Object)new Long(-100000L), (Object)Long.MAX_VALUE));
        minMaxValues.add(Pair.of((Object)false, (Object)true));
        minMaxValues.add(Pair.of((Object)new Double(0.123), (Object)new Double(10.123)));
        minMaxValues.add(Pair.of((Object)new Float(0.0123), (Object)new Float(200.123)));
        minMaxValues.add(Pair.of((Object)new Date(36000000L), (Object)new Date(216000000L)));
        minMaxValues.add(Pair.of((Object)LocalDate.ofEpochDay(36000000L), (Object)LocalDate.ofEpochDay(216000000L)));
        minMaxValues.add(Pair.of((Object)new Timestamp(36000000L), (Object)new Timestamp(216000000L)));
        minMaxValues.add(this.generateRandomMinMaxValue(random, (Functions.Function1<Random, Comparable>)(Functions.Function1 & Serializable)random1 -> new Timestamp(random1.nextInt(1000) * 60 * 60 * 1000)));
        byte[] bytes1 = new byte[10];
        byte[] bytes2 = new byte[10];
        random.nextBytes(bytes1);
        random.nextBytes(bytes2);
        ByteBuffer val1ByteBuffer = ByteBuffer.wrap(bytes1);
        ByteBuffer val2ByteBuffer = ByteBuffer.wrap(bytes2);
        ByteBuffer minValue = val1ByteBuffer;
        ByteBuffer maxValue = val2ByteBuffer;
        if (val1ByteBuffer.compareTo(val2ByteBuffer) >= 0) {
            minValue = val2ByteBuffer;
            maxValue = val1ByteBuffer;
        }
        minMaxValues.add(Pair.of((Object)minValue, (Object)maxValue));
        BigDecimal val1 = new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(random.nextFloat())));
        BigDecimal val2 = new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(random.nextFloat())));
        if (val1.compareTo(val2) > 0) {
            minMaxValues.add(Pair.of((Object)val2, (Object)val1));
        } else {
            minMaxValues.add(Pair.of((Object)val1, (Object)val2));
        }
        HashMap columnRangeMetadataMap = new HashMap();
        AtomicInteger finalCounter1 = counter = new AtomicInteger();
        minMaxValues.forEach(entry -> {
            String colName = targetColNamePrefix + "_" + finalCounter1.getAndIncrement();
            columnRangeMetadataMap.put(colName, HoodieColumnRangeMetadata.create((String)fileName, (String)colName, (Comparable)((Comparable)entry.getKey()), (Comparable)((Comparable)entry.getValue()), (long)5L, (long)1000L, (long)123456L, (long)123456L, (ValueMetadata)ValueMetadata.V1EmptyMetadata.get()));
        });
        HashMap clonedInput = new HashMap();
        clonedInput.putAll(columnRangeMetadataMap);
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.putRecordsStats(clonedInput);
        Map actualRecordStats = (Map)writeStat.getColumnStats().get();
        Assertions.assertEquals(columnRangeMetadataMap, (Object)actualRecordStats);
    }

    private Pair<Comparable, Comparable> generateRandomMinMaxValue(Random random, Functions.Function1<Random, Comparable> randomValueGenFunc) {
        Comparable value2;
        Comparable value1 = (Comparable)randomValueGenFunc.apply((Object)random);
        if (value1.compareTo(value2 = (Comparable)randomValueGenFunc.apply((Object)random)) > 0) {
            return Pair.of((Object)value2, (Object)value1);
        }
        return Pair.of((Object)value1, (Object)value2);
    }
}

