/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPartialUpdateAvroPayload {
    private Schema schema;
    String jsonSchema = "{\n  \"type\": \"record\",\n  \"name\": \"partialRecord\", \"namespace\":\"org.apache.hudi\",\n  \"fields\": [\n    {\"name\": \"_hoodie_commit_time\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"_hoodie_commit_seqno\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"_hoodie_record_key\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"_hoodie_partition_path\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"_hoodie_file_name\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"id\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"partition\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"ts\", \"type\": [\"null\", \"long\"]},\n    {\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false},\n    {\"name\": \"city\", \"type\": [\"null\", \"string\"]},\n    {\"name\": \"child\", \"type\": [\"null\", {\"type\": \"array\", \"items\": \"string\"}]}\n  ]\n}";

    @BeforeEach
    public void setUp() throws Exception {
        this.schema = new Schema.Parser().parse(this.jsonSchema);
    }

    @Test
    public void testActiveRecords() throws IOException {
        Properties properties = new Properties();
        properties.put("hoodie.payload.ordering.field", "ts");
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition1");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        record1.put("city", (Object)"NY0");
        record1.put("child", Arrays.asList("A"));
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition1");
        record2.put("ts", (Object)1L);
        record2.put("_hoodie_is_deleted", (Object)false);
        record2.put("city", null);
        record2.put("child", Arrays.asList("B"));
        GenericData.Record record3 = new GenericData.Record(this.schema);
        record3.put("id", (Object)"1");
        record3.put("partition", (Object)"partition1");
        record3.put("ts", (Object)2L);
        record3.put("_hoodie_is_deleted", (Object)false);
        record3.put("city", (Object)"NY0");
        record3.put("child", Arrays.asList("A"));
        GenericData.Record record4 = new GenericData.Record(this.schema);
        record4.put("id", (Object)"1");
        record4.put("partition", (Object)"partition1");
        record4.put("ts", (Object)1L);
        record4.put("_hoodie_is_deleted", (Object)false);
        record4.put("city", (Object)"NY0");
        record4.put("child", Arrays.asList("B"));
        PartialUpdateAvroPayload payload1 = new PartialUpdateAvroPayload((GenericRecord)record1, (Comparable)Long.valueOf(0L));
        PartialUpdateAvroPayload payload2 = new PartialUpdateAvroPayload((GenericRecord)record2, (Comparable)Long.valueOf(1L));
        Assertions.assertArrayEquals((byte[])payload1.preCombine((OverwriteWithLatestAvroPayload)payload2, this.schema, properties).getRecordBytes(), (byte[])new PartialUpdateAvroPayload((GenericRecord)record4, (Comparable)Long.valueOf(1L)).getRecordBytes());
        Assertions.assertArrayEquals((byte[])payload2.preCombine((OverwriteWithLatestAvroPayload)payload1, this.schema, properties).getRecordBytes(), (byte[])new PartialUpdateAvroPayload((GenericRecord)record4, (Comparable)Long.valueOf(1L)).getRecordBytes());
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema).get());
        Assertions.assertEquals((Object)record2, (Object)payload2.getInsertValue(this.schema).get());
        record1.put("ts", (Object)2L);
        payload1 = new PartialUpdateAvroPayload((GenericRecord)record1, (Comparable)Long.valueOf(2L));
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)record2, this.schema, properties).get(), (Object)record3);
        record1.put("ts", (Object)1L);
        Assertions.assertEquals((Object)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, properties).get(), (Object)record4);
        record1.put("ts", (Object)2L);
        payload1 = new PartialUpdateAvroPayload((GenericRecord)record1, (Comparable)Long.valueOf(2L));
        payload2 = new PartialUpdateAvroPayload((GenericRecord)record2, (Comparable)Long.valueOf(1L));
        Assertions.assertArrayEquals((byte[])payload1.preCombine((OverwriteWithLatestAvroPayload)payload2, this.schema, properties).getRecordBytes(), (byte[])new PartialUpdateAvroPayload((GenericRecord)record3, (Comparable)Long.valueOf(2L)).getRecordBytes());
        Assertions.assertArrayEquals((byte[])payload2.preCombine((OverwriteWithLatestAvroPayload)payload1, this.schema, properties).getRecordBytes(), (byte[])new PartialUpdateAvroPayload((GenericRecord)record3, (Comparable)Long.valueOf(2L)).getRecordBytes());
    }

    @Test
    public void testDeletedRecord() throws IOException {
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        record1.put("city", (Object)"NY0");
        record1.put("child", Collections.emptyList());
        GenericData.Record delRecord1 = new GenericData.Record(this.schema);
        delRecord1.put("id", (Object)"2");
        delRecord1.put("partition", (Object)"partition1");
        delRecord1.put("ts", (Object)1L);
        delRecord1.put("_hoodie_is_deleted", (Object)true);
        delRecord1.put("city", (Object)"NY0");
        delRecord1.put("child", Collections.emptyList());
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition0");
        record2.put("ts", (Object)2L);
        record2.put("_hoodie_is_deleted", (Object)false);
        record2.put("city", (Object)"NY0");
        record2.put("child", Collections.emptyList());
        PartialUpdateAvroPayload payload1 = new PartialUpdateAvroPayload((GenericRecord)record1, (Comparable)Long.valueOf(0L));
        PartialUpdateAvroPayload delPayload = new PartialUpdateAvroPayload((GenericRecord)delRecord1, (Comparable)Long.valueOf(1L));
        PartialUpdateAvroPayload payload2 = new PartialUpdateAvroPayload((GenericRecord)record2, (Comparable)Long.valueOf(2L));
        PartialUpdateAvroPayload mergedPayload = payload1.preCombine((OverwriteWithLatestAvroPayload)delPayload, this.schema, new Properties());
        Assertions.assertTrue((boolean)HoodieAvroUtils.bytesToAvro((byte[])mergedPayload.getRecordBytes(), (Schema)this.schema).get("_hoodie_is_deleted").equals(true));
        Assertions.assertArrayEquals((byte[])mergedPayload.getRecordBytes(), (byte[])delPayload.getRecordBytes());
        mergedPayload = delPayload.preCombine((OverwriteWithLatestAvroPayload)payload1, this.schema, new Properties());
        Assertions.assertTrue((boolean)HoodieAvroUtils.bytesToAvro((byte[])mergedPayload.getRecordBytes(), (Schema)this.schema).get("_hoodie_is_deleted").equals(true));
        Assertions.assertArrayEquals((byte[])mergedPayload.getRecordBytes(), (byte[])delPayload.getRecordBytes());
        mergedPayload = payload2.preCombine((OverwriteWithLatestAvroPayload)delPayload, this.schema, new Properties());
        Assertions.assertTrue((boolean)HoodieAvroUtils.bytesToAvro((byte[])mergedPayload.getRecordBytes(), (Schema)this.schema).get("_hoodie_is_deleted").equals(false));
        Assertions.assertArrayEquals((byte[])mergedPayload.getRecordBytes(), (byte[])payload2.getRecordBytes());
        mergedPayload = delPayload.preCombine((OverwriteWithLatestAvroPayload)payload2, this.schema, new Properties());
        Assertions.assertTrue((boolean)HoodieAvroUtils.bytesToAvro((byte[])mergedPayload.getRecordBytes(), (Schema)this.schema).get("_hoodie_is_deleted").equals(false));
        Assertions.assertArrayEquals((byte[])mergedPayload.getRecordBytes(), (byte[])payload2.getRecordBytes());
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema).get());
        Assertions.assertFalse((boolean)delPayload.getInsertValue(this.schema).isPresent());
        Properties properties = new Properties();
        properties.put("hoodie.payload.ordering.field", "ts");
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)delRecord1, this.schema, properties), (Object)Option.empty());
        Assertions.assertFalse((boolean)delPayload.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, properties).isPresent());
    }

    @Test
    public void testUseLatestRecordMetaValue() throws IOException {
        Properties properties = new Properties();
        properties.put("hoodie.payload.ordering.field", "ts");
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("_hoodie_commit_time", (Object)"20220915000000000");
        record1.put("_hoodie_commit_seqno", (Object)"20220915000000000_1_000");
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition1");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        record1.put("city", (Object)"NY0");
        record1.put("child", Arrays.asList("A"));
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("_hoodie_commit_time", (Object)"20220915000000001");
        record2.put("_hoodie_commit_seqno", (Object)"20220915000000001_2_000");
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition1");
        record2.put("ts", (Object)1L);
        record2.put("_hoodie_is_deleted", (Object)false);
        record2.put("city", null);
        record2.put("child", Arrays.asList("B"));
        PartialUpdateAvroPayload payload1 = new PartialUpdateAvroPayload((GenericRecord)record1, (Comparable)Long.valueOf(0L));
        PartialUpdateAvroPayload payload2 = new PartialUpdateAvroPayload((GenericRecord)record2, (Comparable)Long.valueOf(1L));
        GenericRecord mergedRecord1 = (GenericRecord)payload1.preCombine((OverwriteWithLatestAvroPayload)payload2, this.schema, properties).getInsertValue(this.schema, properties).get();
        Assertions.assertEquals((Object)mergedRecord1.get("_hoodie_commit_time").toString(), (Object)record1.get("_hoodie_commit_time").toString());
        Assertions.assertEquals((Object)mergedRecord1.get("_hoodie_commit_seqno").toString(), (Object)record1.get("_hoodie_commit_seqno").toString());
        GenericRecord mergedRecord2 = (GenericRecord)payload2.preCombine((OverwriteWithLatestAvroPayload)payload1, this.schema, properties).getInsertValue(this.schema, properties).get();
        Assertions.assertEquals((Object)mergedRecord2.get("_hoodie_commit_time").toString(), (Object)record2.get("_hoodie_commit_time").toString());
        Assertions.assertEquals((Object)mergedRecord2.get("_hoodie_commit_seqno").toString(), (Object)record2.get("_hoodie_commit_seqno").toString());
    }

    @Test
    public void testPartialUpdateGotchas() throws IOException {
        Properties properties = new Properties();
        properties.put("hoodie.payload.ordering.field", "ts");
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition1");
        record1.put("ts", (Object)1L);
        record1.put("_hoodie_is_deleted", (Object)false);
        record1.put("city", (Object)"NY0");
        record1.put("child", Arrays.asList("A"));
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition1");
        record2.put("ts", (Object)0L);
        record2.put("_hoodie_is_deleted", (Object)false);
        record2.put("city", (Object)"NY1");
        record2.put("child", Arrays.asList("B"));
        GenericData.Record record3 = new GenericData.Record(this.schema);
        record3.put("id", (Object)"1");
        record3.put("partition", (Object)"partition1");
        record3.put("ts", (Object)2L);
        record3.put("_hoodie_is_deleted", (Object)false);
        record3.put("city", null);
        record3.put("child", Arrays.asList("A"));
        GenericData.Record pureCombineOutput = new GenericData.Record(this.schema);
        pureCombineOutput.put("id", (Object)"1");
        pureCombineOutput.put("partition", (Object)"partition1");
        pureCombineOutput.put("ts", (Object)2L);
        pureCombineOutput.put("_hoodie_is_deleted", (Object)false);
        pureCombineOutput.put("city", (Object)"NY0");
        pureCombineOutput.put("child", Arrays.asList("A"));
        GenericData.Record outputWithPreCombineUsed = new GenericData.Record(this.schema);
        outputWithPreCombineUsed.put("id", (Object)"1");
        outputWithPreCombineUsed.put("partition", (Object)"partition1");
        outputWithPreCombineUsed.put("ts", (Object)2L);
        outputWithPreCombineUsed.put("_hoodie_is_deleted", (Object)false);
        outputWithPreCombineUsed.put("city", (Object)"NY1");
        outputWithPreCombineUsed.put("child", Arrays.asList("A"));
        PartialUpdateAvroPayload payload2 = new PartialUpdateAvroPayload((GenericRecord)record2, (Comparable)Long.valueOf(0L));
        PartialUpdateAvroPayload payload3 = new PartialUpdateAvroPayload((GenericRecord)record3, (Comparable)Long.valueOf(2L));
        IndexedRecord firstCombineOutput = (IndexedRecord)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, properties).get();
        IndexedRecord secondCombineOutput = (IndexedRecord)payload3.combineAndGetUpdateValue(firstCombineOutput, this.schema, properties).get();
        Assertions.assertEquals((Object)pureCombineOutput, (Object)secondCombineOutput);
        PartialUpdateAvroPayload payloadAfterPreCombine = payload3.preCombine((OverwriteWithLatestAvroPayload)payload2, this.schema, properties);
        IndexedRecord finalOutputWithPreCombine = (IndexedRecord)payloadAfterPreCombine.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, properties).get();
        Assertions.assertEquals((Object)outputWithPreCombineUsed, (Object)finalOutputWithPreCombine);
    }
}

