/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.SerializableIndexedRecord;
import org.apache.hudi.common.util.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSerializableIndexRecord {
    private final Schema schema = (Schema)SchemaBuilder.record((String)"test").fields().optionalString("field_1").requiredInt("field_2").endRecord();

    TestSerializableIndexRecord() {
    }

    @Test
    void testEqualsWithGenericRecord() {
        GenericData.Record record1 = new GenericRecordBuilder(this.schema).set("field_1", (Object)"value1").set("field_2", (Object)42).build();
        GenericData.Record record2 = new GenericRecordBuilder(this.schema).set("field_1", (Object)"value2").set("field_2", (Object)42).build();
        SerializableIndexedRecord serializableIndexedRecord = SerializableIndexedRecord.createInstance((IndexedRecord)record1);
        Assertions.assertEquals((Object)record1, (Object)serializableIndexedRecord.getRecord());
        Assertions.assertEquals((Object)serializableIndexedRecord, (Object)record1);
        Assertions.assertNotEquals((Object)record2, (Object)serializableIndexedRecord.getRecord());
        Assertions.assertNotEquals((Object)serializableIndexedRecord, (Object)record2);
        Assertions.assertNotEquals((Object)serializableIndexedRecord, null);
    }

    @Test
    void testEncodeDecode() throws IOException {
        GenericData.Record originalRecord = new GenericRecordBuilder(this.schema).set("field_1", (Object)"value1").set("field_2", (Object)42).build();
        SerializableIndexedRecord serializableIndexedRecord = SerializableIndexedRecord.createInstance((IndexedRecord)originalRecord);
        byte[] encoded = serializableIndexedRecord.encodeRecord();
        Assertions.assertEquals((Object)originalRecord, (Object)HoodieAvroUtils.bytesToAvro((byte[])encoded, (Schema)this.schema));
        byte[] reEncoded = serializableIndexedRecord.encodeRecord();
        Assertions.assertSame((Object)encoded, (Object)reEncoded);
        serializableIndexedRecord.decodeRecord(this.schema);
        Assertions.assertSame((Object)originalRecord, (Object)serializableIndexedRecord.getRecord());
        byte[] serialized = SerializationUtils.serialize((Object)serializableIndexedRecord);
        SerializableIndexedRecord deserialized = (SerializableIndexedRecord)SerializationUtils.deserialize((byte[])serialized);
        deserialized.decodeRecord(this.schema);
        IndexedRecord parsedRecord = deserialized.getRecord();
        Assertions.assertEquals((Object)originalRecord, (Object)parsedRecord);
        deserialized.decodeRecord(this.schema);
        Assertions.assertSame((Object)parsedRecord, (Object)deserialized.getRecord());
    }

    @Test
    void testFromAvroBytes() {
        GenericData.Record originalRecord = new GenericRecordBuilder(this.schema).set("field_1", (Object)"value1").set("field_2", (Object)42).build();
        byte[] encoded = HoodieAvroUtils.avroToBytes((IndexedRecord)originalRecord);
        SerializableIndexedRecord serializableIndexedRecord = SerializableIndexedRecord.fromAvroBytes((Schema)this.schema, (byte[])encoded);
        Assertions.assertEquals((Object)originalRecord, (Object)serializableIndexedRecord.getRecord());
        Assertions.assertNull((Object)SerializableIndexedRecord.fromAvroBytes((Schema)this.schema, (byte[])new byte[0]));
    }
}

