/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieDebeziumAvroPayloadException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPostgresDebeziumAvroPayload {
    private static final String KEY_FIELD_NAME = "Key";
    private Schema avroSchema;

    @BeforeEach
    void setUp() {
        this.avroSchema = Schema.createRecord(Arrays.asList(new Schema.Field(KEY_FIELD_NAME, Schema.create((Schema.Type)Schema.Type.INT), "", (Object)0), new Schema.Field("_change_operation_type", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), "", null), new Schema.Field("_event_lsn", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)}), "", null)));
    }

    @Test
    public void testInsert() throws IOException {
        GenericRecord insertRecord = this.createRecord(0, Operation.INSERT, 100L);
        PostgresDebeziumAvroPayload payload = new PostgresDebeziumAvroPayload(insertRecord, (Comparable)Long.valueOf(100L));
        this.validateRecord((Option<IndexedRecord>)payload.getInsertValue(this.avroSchema), 0, Operation.INSERT, 100L);
    }

    @Test
    public void testPreCombine() {
        GenericRecord insertRecord = this.createRecord(0, Operation.INSERT, 120L);
        PostgresDebeziumAvroPayload insertPayload = new PostgresDebeziumAvroPayload(insertRecord, (Comparable)Long.valueOf(120L));
        GenericRecord updateRecord = this.createRecord(0, Operation.UPDATE, 99L);
        PostgresDebeziumAvroPayload updatePayload = new PostgresDebeziumAvroPayload(updateRecord, (Comparable)Long.valueOf(99L));
        GenericRecord deleteRecord = this.createRecord(0, Operation.DELETE, 111L);
        PostgresDebeziumAvroPayload deletePayload = new PostgresDebeziumAvroPayload(deleteRecord, (Comparable)Long.valueOf(111L));
        Assertions.assertEquals((Object)insertPayload, (Object)insertPayload.preCombine((OverwriteWithLatestAvroPayload)updatePayload));
        Assertions.assertEquals((Object)deletePayload, (Object)deletePayload.preCombine((OverwriteWithLatestAvroPayload)updatePayload));
        Assertions.assertEquals((Object)insertPayload, (Object)deletePayload.preCombine((OverwriteWithLatestAvroPayload)insertPayload));
    }

    @Test
    public void testMergeWithUpdate() throws IOException {
        GenericRecord updateRecord = this.createRecord(1, Operation.UPDATE, 100L);
        PostgresDebeziumAvroPayload payload = new PostgresDebeziumAvroPayload(updateRecord, (Comparable)Long.valueOf(100L));
        GenericRecord existingRecord = this.createRecord(1, Operation.INSERT, 99L);
        Option mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 1, Operation.UPDATE, 100L);
        GenericRecord lateRecord = this.createRecord(1, Operation.UPDATE, 98L);
        payload = new PostgresDebeziumAvroPayload(lateRecord, (Comparable)Long.valueOf(98L));
        mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 1, Operation.INSERT, 99L);
    }

    @Test
    public void testMergeWithDelete() throws IOException {
        GenericRecord deleteRecord = this.createRecord(2, Operation.DELETE, 100L);
        PostgresDebeziumAvroPayload payload = new PostgresDebeziumAvroPayload(deleteRecord, (Comparable)Long.valueOf(100L));
        Assertions.assertTrue((boolean)payload.isDeleted(this.avroSchema, new Properties()));
        GenericRecord existingRecord = this.createRecord(2, Operation.UPDATE, 99L);
        Option mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        Assertions.assertFalse((boolean)mergedRecord.isPresent());
        GenericRecord lateRecord = this.createRecord(2, Operation.DELETE, 98L);
        payload = new PostgresDebeziumAvroPayload(lateRecord, (Comparable)Long.valueOf(98L));
        mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 2, Operation.UPDATE, 99L);
    }

    @Test
    public void testMergeWithDeleteUsingEmptyRecord() throws IOException {
        HoodieAvroRecord emptyRecord = new HoodieAvroRecord(new HoodieKey(), (HoodieRecordPayload)new PostgresDebeziumAvroPayload(Option.empty()));
        GenericRecord existingRecord = this.createRecord(2, Operation.UPDATE, 99L);
        Option mergedRecord = ((PostgresDebeziumAvroPayload)emptyRecord.getData()).combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema, (Properties)new TypedProperties());
        Assertions.assertFalse((boolean)mergedRecord.isPresent());
        GenericRecord insertedRecord = this.createRecord(1, Operation.INSERT, 100L);
        PostgresDebeziumAvroPayload insertPayload = new PostgresDebeziumAvroPayload(insertedRecord, (Comparable)Long.valueOf(100L));
        PostgresDebeziumAvroPayload combinedPayload = (PostgresDebeziumAvroPayload)insertPayload.preCombine((HoodieRecordPayload)emptyRecord.getData(), this.avroSchema, (Properties)new TypedProperties());
        Assertions.assertEquals((Object)insertPayload, (Object)combinedPayload);
    }

    @Test
    public void testMergeWithBootstrappedExistingRecords() throws IOException {
        GenericRecord incomingRecord = this.createRecord(3, Operation.UPDATE, 100L);
        PostgresDebeziumAvroPayload payload = new PostgresDebeziumAvroPayload(incomingRecord, (Comparable)Long.valueOf(100L));
        GenericRecord existingRecord = this.createRecord(3, null, null);
        Option mergedRecord = payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema);
        this.validateRecord((Option<IndexedRecord>)mergedRecord, 3, Operation.UPDATE, 100L);
    }

    @Test
    public void testInvalidIncomingRecord() {
        GenericRecord incomingRecord = this.createRecord(4, null, null);
        PostgresDebeziumAvroPayload payload = new PostgresDebeziumAvroPayload(incomingRecord, (Comparable)Long.valueOf(100L));
        GenericRecord existingRecord = this.createRecord(4, Operation.INSERT, 99L);
        Assertions.assertThrows(HoodieDebeziumAvroPayloadException.class, () -> payload.combineAndGetUpdateValue((IndexedRecord)existingRecord, this.avroSchema), (String)"should have thrown because LSN value of the incoming record is null");
    }

    @Test
    public void testMergeWithToastedValues() throws IOException {
        Schema avroSchema = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record("test_schema").namespace("test_namespace")).fields().name("_event_lsn").type().longType().noDefault().name("string_col").type().stringType().noDefault().name("byte_col").type().bytesType().noDefault().name("string_null_col_1").type().nullable().stringType().noDefault().name("byte_null_col_1").type().nullable().bytesType().noDefault().name("string_null_col_2").type().nullable().stringType().noDefault().name("byte_null_col_2").type().nullable().bytesType().noDefault().endRecord();
        GenericData.Record oldVal = new GenericData.Record(avroSchema);
        oldVal.put("_event_lsn", (Object)100L);
        oldVal.put("string_col", (Object)"valid string value");
        oldVal.put("byte_col", (Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"valid byte value")));
        oldVal.put("string_null_col_1", (Object)"valid string value");
        oldVal.put("byte_null_col_1", (Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"valid byte value")));
        oldVal.put("string_null_col_2", null);
        oldVal.put("byte_null_col_2", null);
        GenericData.Record newVal = new GenericData.Record(avroSchema);
        newVal.put("_event_lsn", (Object)105L);
        newVal.put("string_col", (Object)"__debezium_unavailable_value");
        newVal.put("byte_col", (Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"__debezium_unavailable_value")));
        newVal.put("string_null_col_1", null);
        newVal.put("byte_null_col_1", null);
        newVal.put("string_null_col_2", (Object)"valid string value");
        newVal.put("byte_null_col_2", (Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"valid byte value")));
        PostgresDebeziumAvroPayload payload = new PostgresDebeziumAvroPayload(Option.of((Object)newVal));
        GenericRecord outputRecord = (GenericRecord)payload.combineAndGetUpdateValue((IndexedRecord)oldVal, avroSchema).get();
        Assertions.assertEquals((Object)"valid string value", (Object)outputRecord.get("string_col"));
        Assertions.assertEquals((Object)"valid byte value", (Object)StringUtils.fromUTF8Bytes((byte[])((ByteBuffer)outputRecord.get("byte_col")).array()));
        Assertions.assertNull((Object)outputRecord.get("string_null_col_1"));
        Assertions.assertNull((Object)outputRecord.get("byte_null_col_1"));
        Assertions.assertEquals((Object)"valid string value", (Object)outputRecord.get("string_null_col_2").toString());
        Assertions.assertEquals((Object)"valid byte value", (Object)StringUtils.fromUTF8Bytes((byte[])((ByteBuffer)outputRecord.get("byte_null_col_2")).array()));
    }

    private GenericRecord createRecord(int primaryKeyValue, @Nullable Operation op, @Nullable Long lsnValue) {
        GenericData.Record record = new GenericData.Record(this.avroSchema);
        record.put(KEY_FIELD_NAME, (Object)primaryKeyValue);
        record.put("_change_operation_type", (Object)Objects.toString((Object)op, null));
        record.put("_event_lsn", (Object)lsnValue);
        return record;
    }

    private void validateRecord(Option<IndexedRecord> iRecord, int primaryKeyValue, Operation op, long lsnValue) {
        IndexedRecord record = (IndexedRecord)iRecord.get();
        Assertions.assertEquals((int)primaryKeyValue, (int)((Integer)record.get(0)));
        Assertions.assertEquals((Object)op.op, (Object)record.get(1).toString());
        Assertions.assertEquals((long)lsnValue, (long)((Long)record.get(2)));
    }

    private static enum Operation {
        INSERT("c"),
        UPDATE("u"),
        DELETE("d");

        public final String op;

        private Operation(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

