/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.properties;

import java.util.Properties;
import org.apache.hudi.common.config.OrderedProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOrderedProperties {
    @Test
    public void testPutPropertiesOrder() {
        OrderedProperties properties = new OrderedProperties();
        properties.put("key0", "true");
        properties.put("key1", "false");
        properties.put("key2", "true");
        properties.put("key3", "false");
        properties.put("key4", "true");
        properties.put("key5", "true");
        properties.put("key6", "false");
        properties.put("key7", "true");
        properties.put("key8", "false");
        properties.put("key9", "true");
        OrderedProperties typedProperties = new OrderedProperties((Properties)properties);
        this.assertTypeProperties(typedProperties, 0);
    }

    @Test
    void testPutAllPropertiesOrder() {
        OrderedProperties firstProp = new OrderedProperties();
        firstProp.put("key0", "true");
        firstProp.put("key1", "false");
        firstProp.put("key2", "true");
        OrderedProperties firstProperties = new OrderedProperties((Properties)firstProp);
        this.assertTypeProperties(firstProperties, 0);
        OrderedProperties secondProperties = new OrderedProperties();
        secondProperties.put((Object)"key3", (Object)"true");
        secondProperties.put((Object)"key4", (Object)"false");
        secondProperties.put((Object)"key5", (Object)"true");
        this.assertTypeProperties(secondProperties, 3);
        OrderedProperties thirdProperties = new OrderedProperties();
        thirdProperties.putAll((Properties)firstProp);
        thirdProperties.putAll((Properties)secondProperties);
        Assertions.assertEquals((int)3, (int)firstProp.stringPropertyNames().size());
        Assertions.assertEquals((int)3, (int)secondProperties.stringPropertyNames().size());
        Assertions.assertEquals((int)6, (int)thirdProperties.stringPropertyNames().size());
    }

    private void assertTypeProperties(OrderedProperties typedProperties, int start) {
        String[] props = typedProperties.stringPropertyNames().toArray(new String[0]);
        for (int i = start; i < props.length; ++i) {
            Assertions.assertEquals((Object)String.format("key%d", i), (Object)props[i]);
        }
    }
}

