/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.serialization;

import java.io.IOException;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroRecordContext;
import org.apache.hudi.avro.AvroRecordSerializer;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.serialization.RecordSerializer;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordSerializer;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestBufferedRecordSerializer {
    @Test
    void testAvroRecordSerAndDe() throws IOException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        GenericData.Record record = new GenericData.Record(schema);
        record.put("name", (Object)"lily");
        record.put("favorite_number", (Object)100);
        record.put("favorite_color", (Object)"red");
        AvroRecordSerializer avroRecordSerializer = new AvroRecordSerializer(integer -> schema);
        byte[] avroBytes = avroRecordSerializer.serialize((IndexedRecord)record);
        IndexedRecord result = avroRecordSerializer.deserialize(avroBytes, 1);
        Assertions.assertEquals((Object)record, (Object)result);
        avroRecordSerializer = new AvroRecordSerializer(integer -> HoodieMetadataRecord.SCHEMA$);
        HoodieMetadataRecord metadataRecord = new HoodieMetadataRecord("__all_partitions__", Integer.valueOf(1), new HashMap(), null, null, null, null);
        avroBytes = avroRecordSerializer.serialize((IndexedRecord)metadataRecord);
        result = avroRecordSerializer.deserialize(avroBytes, 1);
        for (int i = 0; i < metadataRecord.getSchema().getFields().size(); ++i) {
            Assertions.assertEquals((Object)metadataRecord.get(i), (Object)result.get(i));
        }
    }

    @Test
    void testBufferedRecordSerAndDe() throws IOException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        GenericData.Record record = new GenericData.Record(schema);
        record.put("name", (Object)"lily");
        record.put("favorite_number", (Object)100);
        record.put("favorite_color", (Object)"red");
        BufferedRecord bufferedRecord = new BufferedRecord("id", (Comparable)Integer.valueOf(100), (Object)record, Integer.valueOf(1), null);
        AvroRecordSerializer avroRecordSerializer = new AvroRecordSerializer(integer -> schema);
        BufferedRecordSerializer bufferedRecordSerializer = new BufferedRecordSerializer((RecordSerializer)avroRecordSerializer);
        byte[] bytes = bufferedRecordSerializer.serialize(bufferedRecord);
        BufferedRecord result = bufferedRecordSerializer.deserialize(bytes);
        Assertions.assertEquals((Object)bufferedRecord, (Object)result);
        avroRecordSerializer = new AvroRecordSerializer(integer -> HoodieMetadataRecord.SCHEMA$);
        bufferedRecordSerializer = new BufferedRecordSerializer((RecordSerializer)avroRecordSerializer);
        HoodieMetadataRecord metadataRecord = new HoodieMetadataRecord("__all_partitions__", Integer.valueOf(1), new HashMap(), null, null, null, null);
        bufferedRecord = new BufferedRecord("__all_partitions__", (Comparable)Integer.valueOf(0), (Object)metadataRecord, Integer.valueOf(1), null);
        bytes = bufferedRecordSerializer.serialize(bufferedRecord);
        result = bufferedRecordSerializer.deserialize(bytes);
        Assertions.assertEquals((Object)bufferedRecord.getRecordKey(), (Object)result.getRecordKey());
        Assertions.assertEquals((Object)bufferedRecord.getOrderingValue(), (Object)result.getOrderingValue());
        Assertions.assertEquals((Integer)bufferedRecord.getSchemaId(), (Integer)result.getSchemaId());
        Assertions.assertEquals((Object)bufferedRecord.isDelete(), (Object)result.isDelete());
        Assertions.assertEquals((Object)bufferedRecord.getHoodieOperation(), (Object)result.getHoodieOperation());
        for (int i = 0; i < metadataRecord.getSchema().getFields().size(); ++i) {
            Assertions.assertEquals((Object)metadataRecord.get(i), (Object)((IndexedRecord)result.getRecord()).get(i));
        }
        Assertions.assertEquals((Object)((IndexedRecord)bufferedRecord.getRecord()).toString(), (Object)((IndexedRecord)result.getRecord()).toString());
    }

    @ParameterizedTest
    @EnumSource(value=HoodieOperation.class, names={"UPDATE_BEFORE", "DELETE"})
    void testDeleteRecordSerAndDe(HoodieOperation hoodieOperation) throws IOException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        DeleteRecord record = DeleteRecord.create((String)"id", (String)"partition", (Comparable)Integer.valueOf(100));
        BufferedRecord bufferedRecord = BufferedRecords.fromDeleteRecord((DeleteRecord)record, (RecordContext)AvroRecordContext.getFieldAccessorInstance());
        bufferedRecord.setHoodieOperation(hoodieOperation);
        AvroRecordSerializer avroRecordSerializer = new AvroRecordSerializer(integer -> schema);
        BufferedRecordSerializer bufferedRecordSerializer = new BufferedRecordSerializer((RecordSerializer)avroRecordSerializer);
        byte[] bytes = bufferedRecordSerializer.serialize(bufferedRecord);
        BufferedRecord result = bufferedRecordSerializer.deserialize(bytes);
        Assertions.assertEquals((Object)bufferedRecord.getRecordKey(), (Object)result.getRecordKey());
        Assertions.assertEquals((Object)bufferedRecord.getOrderingValue(), (Object)result.getOrderingValue());
        Assertions.assertEquals((Integer)bufferedRecord.getSchemaId(), (Integer)result.getSchemaId());
        Assertions.assertEquals((Object)bufferedRecord.isDelete(), (Object)result.isDelete());
        Assertions.assertEquals((Object)bufferedRecord.getHoodieOperation(), (Object)result.getHoodieOperation());
        Assertions.assertNull((Object)result.getRecord());
    }
}

