/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.serialization;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDefaultSerializer {
    TestDefaultSerializer() {
    }

    @Test
    void roundTripValidation() throws IOException {
        String partition = "1";
        String fileId1 = UUID.randomUUID().toString();
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        FileSlice fileSlice = new FileSlice(new HoodieFileGroupId(partition, fileId1), instant1.requestedTime(), new HoodieBaseFile("/tmp/" + FSUtils.makeBaseFileName((String)instant1.requestedTime(), (String)"1-0-1", (String)fileId1, (String)"parquet")), Collections.emptyList());
        DefaultSerializer serializer = new DefaultSerializer();
        byte[] serializedValue = serializer.serialize((Serializable)fileSlice);
        FileSlice output = (FileSlice)serializer.deserialize(serializedValue);
        Assertions.assertEquals((Object)fileSlice, (Object)output);
    }
}

