/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.serialization;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.serialization.HoodieFileGroupSerializer;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieFileGroupSerializer {
    TestHoodieFileGroupSerializer() {
    }

    @Test
    void serializerReusesTimelineInstance() throws IOException {
        String partition = "1";
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        FileSlice fileSlice1 = new FileSlice(new HoodieFileGroupId(partition, fileId1), instant1.requestedTime(), new HoodieBaseFile("/tmp/" + FSUtils.makeBaseFileName((String)instant1.requestedTime(), (String)"1-0-1", (String)fileId1, (String)"parquet")), Collections.emptyList());
        FileSlice fileSlice2 = new FileSlice(new HoodieFileGroupId(partition, fileId2), instant1.requestedTime(), new HoodieBaseFile("/tmp/" + FSUtils.makeBaseFileName((String)instant1.requestedTime(), (String)"1-0-1", (String)fileId2, (String)"parquet")), Collections.emptyList());
        MockHoodieTimeline mockTimeline1 = new MockHoodieTimeline(Collections.singletonList(instant1));
        HoodieFileGroup hoodieFileGroup1 = new HoodieFileGroup(partition, fileId1, (HoodieTimeline)mockTimeline1);
        hoodieFileGroup1.addFileSlice(fileSlice1);
        HoodieFileGroup hoodieFileGroup2 = new HoodieFileGroup(partition, fileId2, (HoodieTimeline)mockTimeline1);
        hoodieFileGroup2.addFileSlice(fileSlice2);
        String fileId3 = UUID.randomUUID().toString();
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "002", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        MockHoodieTimeline mockTimeline2 = new MockHoodieTimeline(Collections.singletonList(instant2));
        FileSlice fileSlice3 = new FileSlice(new HoodieFileGroupId(partition, fileId3), instant1.requestedTime(), new HoodieBaseFile("/tmp/" + FSUtils.makeBaseFileName((String)instant2.requestedTime(), (String)"1-0-1", (String)fileId3, (String)"parquet")), Collections.emptyList());
        HoodieFileGroup hoodieFileGroup3 = new HoodieFileGroup(partition, fileId3, (HoodieTimeline)mockTimeline2);
        hoodieFileGroup3.addFileSlice(fileSlice3);
        List<HoodieFileGroup> inputs = Arrays.asList(hoodieFileGroup1, hoodieFileGroup2, hoodieFileGroup3);
        HoodieFileGroupSerializer serializer = new HoodieFileGroupSerializer();
        byte[] serializedValue = serializer.serialize(inputs);
        List outputs = serializer.deserialize(serializedValue);
        Assertions.assertEquals(inputs, (Object)outputs);
        Assertions.assertSame((Object)((Object)mockTimeline1), (Object)((HoodieFileGroup)outputs.get(0)).getTimeline());
        Assertions.assertSame((Object)((Object)mockTimeline1), (Object)((HoodieFileGroup)outputs.get(1)).getTimeline());
        Assertions.assertSame((Object)((Object)mockTimeline2), (Object)((HoodieFileGroup)outputs.get(2)).getTimeline());
    }
}

