/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.serialization;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.serialization.HoodieFileSliceSerializer;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieFileSliceSerializer {
    private static final String LOG_FILE_PATH_FORMAT = "file:///tmp/basePath/partitionPath/.fileId%s_100.log.%s_1-0-1";
    private static final short BLOCK_REPLICATION = 1;
    private static final StoragePath BASE_FILE_STORAGE_PATH_1 = new StoragePath("fileId-1/baseFilepath.parquet");
    private static final StoragePath BASE_FILE_STORAGE_PATH_2 = new StoragePath("fileId-1/baseFilepath.parquet");
    private static final StoragePath LOG_FILE_STORAGE_PATH_1 = new StoragePath(String.format("file:///tmp/basePath/partitionPath/.fileId%s_100.log.%s_1-0-1", "1", "0"));
    private static final StoragePath LOG_FILE_STORAGE_PATH_2 = new StoragePath(String.format("file:///tmp/basePath/partitionPath/.fileId%s_100.log.%s_1-0-1", "2", "2"));

    TestHoodieFileSliceSerializer() {
    }

    @Test
    void testSerDe() throws IOException {
        HoodieFileSliceSerializer hoodieFileSliceSerializer = new HoodieFileSliceSerializer();
        HoodieBaseFile baseFile1 = new HoodieBaseFile(new StoragePathInfo(BASE_FILE_STORAGE_PATH_1, 100L, false, 1, 1024L, 0L));
        HoodieLogFile logFile1 = new HoodieLogFile(new StoragePathInfo(LOG_FILE_STORAGE_PATH_1, 100L, false, 1, 1024L, 0L));
        HoodieLogFile logFile2 = new HoodieLogFile("/dummy/base/" + FSUtils.makeLogFileName((String)"fileId-1", (String)".log", (String)"001", (int)2, (String)"1-0-1"));
        HoodieBaseFile baseFile2 = new HoodieBaseFile(new StoragePathInfo(BASE_FILE_STORAGE_PATH_2, 100L, false, 1, 1024L, 0L));
        HoodieLogFile logFile3 = new HoodieLogFile(new StoragePathInfo(LOG_FILE_STORAGE_PATH_2, 100L, false, 1, 1024L, 0L));
        HoodieLogFile logFile4 = new HoodieLogFile("/dummy/base/" + FSUtils.makeLogFileName((String)"fileId-2", (String)".log", (String)"002", (int)2, (String)"1-0-1"));
        List<FileSlice> fileSliceList = Arrays.asList(new FileSlice(new HoodieFileGroupId("partition1", "fileId-1"), "001", baseFile1, Arrays.asList(logFile1, logFile2)), new FileSlice(new HoodieFileGroupId("partition2", "fileId-2"), "001", baseFile2, Arrays.asList(logFile3, logFile4)), new FileSlice("partition3", "002", "fileId-3"));
        byte[] serializedBytes = hoodieFileSliceSerializer.serialize(fileSliceList);
        List deserialized = hoodieFileSliceSerializer.deserialize(serializedBytes);
        Assertions.assertEquals(fileSliceList, (Object)deserialized);
    }
}

