/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.table.PartitionPathParser;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestPartitionPathParser {
    TestPartitionPathParser() {
    }

    private static Stream<Arguments> partitionPathCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"2025/01/03/22", new String[]{"timestamp_field"}, new Object[]{new Timestamp(1735941600000L)}}), Arguments.of((Object[])new Object[]{"2025-01-03-22", new String[]{"timestamp_field"}, new Object[]{new Timestamp(1735941600000L)}}), Arguments.of((Object[])new Object[]{"timestamp_field=2025-01-03-22", new String[]{"timestamp_field"}, new Object[]{new Timestamp(1735941600000L)}}), Arguments.of((Object[])new Object[]{"2025/01/03", new String[]{"date_field"}, new Object[]{Date.valueOf("2025-01-03")}}), Arguments.of((Object[])new Object[]{"2025/01", new String[]{"date_field"}, new Object[]{Date.valueOf("2025-01-01")}}), Arguments.of((Object[])new Object[]{"2025", new String[]{"date_field"}, new Object[]{Date.valueOf("2025-01-01")}}), Arguments.of((Object[])new Object[]{"value1/2025/01/03", new String[]{"string_field", "date_field"}, new Object[]{"value1", Date.valueOf("2025-01-03")}}), Arguments.of((Object[])new Object[]{"2025/01/03/value1", new String[]{"date_field", "string_field"}, new Object[]{Date.valueOf("2025-01-03"), "value1"}}), Arguments.of((Object[])new Object[]{"string_field=value1/year=2020/month=08/day=28/hour=06", new String[]{"string_field", "timestamp_field"}, new Object[]{"value1", new Timestamp(1598594400000L)}}), Arguments.of((Object[])new Object[]{"year=2020/month=08/day=28/hour=06/string_field=value1", new String[]{"timestamp_field", "string_field"}, new Object[]{new Timestamp(1598594400000L), "value1"}}), Arguments.of((Object[])new Object[]{"", null, new Object[0]}));
    }

    @ParameterizedTest
    @MethodSource(value={"partitionPathCases"})
    void testGetPartitionFieldVals(String partitionPath, String[] partitionFields, Object[] expectedValues) {
        PartitionPathParser parser = new PartitionPathParser();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TestRecord\",\"fields\":[{\"name\":\"string_field\",\"type\":[\"null\", \"string\"]},{\"name\":\"date_field\",\"type\": {\"type\":\"int\",\"logicalType\": \"date\"}},{\"name\":\"timestamp_field\",\"type\": {\"type\":\"long\",\"logicalType\": \"timestamp-millis\"}}]}");
        Object[] result = parser.getPartitionFieldVals(Option.ofNullable((Object)partitionFields), partitionPath, schema);
        Assertions.assertEquals((int)expectedValues.length, (int)result.length);
        for (int i = 0; i < expectedValues.length; ++i) {
            Assertions.assertEquals((Object)expectedValues[i], (Object)result[i]);
        }
    }

    private static Stream<Arguments> fieldCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"123", Schema.create((Schema.Type)Schema.Type.LONG), 123L}), Arguments.of((Object[])new Object[]{"123", Schema.create((Schema.Type)Schema.Type.INT), 123}), Arguments.of((Object[])new Object[]{"123.45", Schema.create((Schema.Type)Schema.Type.DOUBLE), 123.45}), Arguments.of((Object[])new Object[]{"123.45", Schema.create((Schema.Type)Schema.Type.FLOAT), Float.valueOf(123.45f)}), Arguments.of((Object[])new Object[]{"false", Schema.create((Schema.Type)Schema.Type.BOOLEAN), false}), Arguments.of((Object[])new Object[]{"__HIVE_DEFAULT_PARTITION__", Schema.create((Schema.Type)Schema.Type.INT), null}), Arguments.of((Object[])new Object[]{"default", Schema.create((Schema.Type)Schema.Type.INT), null}), Arguments.of((Object[])new Object[]{"2025-01-03", Schema.create((Schema.Type)Schema.Type.STRING), "2025-01-03"}), Arguments.of((Object[])new Object[]{"value1", Schema.create((Schema.Type)Schema.Type.BYTES), "value1".getBytes(StandardCharsets.UTF_8)}), Arguments.of((Object[])new Object[]{"value1", Schema.createFixed((String)"fixed", (String)"docs", null, (int)50), "value1".getBytes(StandardCharsets.UTF_8)}));
    }

    @ParameterizedTest
    @MethodSource(value={"fieldCases"})
    void testValueParsing(String value, Schema fieldSchema, Object expected) {
        if (expected instanceof byte[]) {
            String expectedString = new String((byte[])expected, StandardCharsets.UTF_8);
            String actualString = new String((byte[])PartitionPathParser.parseValue((String)value, (Schema)fieldSchema));
            Assertions.assertEquals((Object)expectedString, (Object)actualString);
        } else {
            Assertions.assertEquals((Object)expected, (Object)PartitionPathParser.parseValue((String)value, (Schema)fieldSchema));
        }
    }
}

