/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.checkpoint;

import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.CheckpointUtils;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.checkpoint.UnresolvedStreamerCheckpointBasedOnCfg;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.exception.HoodieException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCheckpointUtils {
    private HoodieTableMetaClient metaClient;
    private HoodieActiveTimeline activeTimeline;
    private static final String CHECKPOINT_TO_RESUME = "20240101000000";
    private static final String GENERAL_SOURCE = "org.apache.hudi.utilities.sources.GeneralSource";

    @BeforeEach
    public void setUp() {
        this.metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        this.activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)this.metaClient.getActiveTimeline()).thenReturn((Object)this.activeTimeline);
    }

    @Test
    public void testGetCheckpointWithV1Metadata() {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)Mockito.mock(HoodieCommitMetadata.class);
        Mockito.when((Object)commitMetadata.getMetadata("deltastreamer.checkpoint.key")).thenReturn((Object)"v1_key");
        Checkpoint checkpoint = CheckpointUtils.getCheckpoint((HoodieCommitMetadata)commitMetadata);
        Assertions.assertTrue((boolean)(checkpoint instanceof StreamerCheckpointV1));
        Assertions.assertEquals((Object)"v1_key", (Object)checkpoint.getCheckpointKey());
    }

    @Test
    public void testGetCheckpointWithV2Metadata() {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)Mockito.mock(HoodieCommitMetadata.class);
        Mockito.when((Object)commitMetadata.getMetadata("streamer.checkpoint.key.v2")).thenReturn((Object)"v2_key");
        Checkpoint checkpoint = CheckpointUtils.getCheckpoint((HoodieCommitMetadata)commitMetadata);
        Assertions.assertTrue((boolean)(checkpoint instanceof StreamerCheckpointV2));
        Assertions.assertEquals((Object)"v2_key", (Object)checkpoint.getCheckpointKey());
    }

    @Test
    public void testGetCheckpointThrowsExceptionForMissingCheckpoint() {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)Mockito.mock(HoodieCommitMetadata.class);
        Mockito.when((Object)commitMetadata.getMetadata(ArgumentMatchers.anyString())).thenReturn(null);
        Exception exception = (Exception)Assertions.assertThrows(HoodieException.class, () -> CheckpointUtils.getCheckpoint((HoodieCommitMetadata)commitMetadata));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Checkpoint is not found"));
    }

    @Test
    public void testConvertToCheckpointV2ForCommitTime() {
        String instantTime = "20231127010101";
        String completionTime = "20231127020102";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", instantTime, completionTime, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.activeTimeline.getInstantsAsStream()).thenReturn(Stream.of(instant));
        StreamerCheckpointV1 checkpoint = new StreamerCheckpointV1(instantTime);
        StreamerCheckpointV2 translatedCheckpoint = CheckpointUtils.convertToCheckpointV2ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.FAIL);
        Assertions.assertEquals((Object)completionTime, (Object)translatedCheckpoint.getCheckpointKey());
    }

    @Test
    public void testConvertToCheckpointV1ForCommitTime() {
        String completionTime = "20231127020102";
        String instantTime = "20231127010101";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", instantTime, completionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.activeTimeline.getInstantsAsStream()).thenReturn(Stream.of(instant));
        StreamerCheckpointV2 checkpoint = new StreamerCheckpointV2(completionTime);
        StreamerCheckpointV1 translatedCheckpoint = CheckpointUtils.convertToCheckpointV1ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)instantTime, (Object)translatedCheckpoint.getCheckpointKey());
    }

    @Test
    public void testConvertToCheckpointV2ThrowsExceptionForMissingCompletionTime() {
        String instantTime = "20231127010101";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTime, null, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.activeTimeline.getInstantsAsStream()).thenReturn(Stream.of(instant));
        StreamerCheckpointV1 checkpoint = new StreamerCheckpointV1(instantTime);
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.lambda$testConvertToCheckpointV2ThrowsExceptionForMissingCompletionTime$1((Checkpoint)checkpoint));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unable to find completion time"));
    }

    @Test
    public void testConvertToCheckpointV1ThrowsExceptionForMissingRequestedTime() {
        String completionTime = "20231127020101";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", null, completionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.activeTimeline.getInstantsAsStream()).thenReturn(Stream.of(instant));
        StreamerCheckpointV2 checkpoint = new StreamerCheckpointV2(completionTime);
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.lambda$testConvertToCheckpointV1ThrowsExceptionForMissingRequestedTime$2((Checkpoint)checkpoint));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unable to find requested time"));
    }

    @Test
    public void testConvertToCheckpointV2ForCommitTimeEmptyTimeline() {
        String instantTime = "20231127010101";
        String completionTime = "20231127020102";
        Mockito.when((Object)this.activeTimeline.getInstantsAsStream()).thenReturn(Stream.empty());
        StreamerCheckpointV1 checkpoint = new StreamerCheckpointV1(instantTime);
        Exception exception = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.lambda$testConvertToCheckpointV2ForCommitTimeEmptyTimeline$3((Checkpoint)checkpoint));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Unable to find completion time"));
    }

    @Test
    public void testConvertCheckpointWithInitTimestamp() {
        String instantTime = "00000000000000";
        StreamerCheckpointV1 checkpoint = new StreamerCheckpointV1(instantTime);
        StreamerCheckpointV1 translated = CheckpointUtils.convertToCheckpointV1ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)"00000000000000", (Object)translated.getCheckpointKey());
        checkpoint = new StreamerCheckpointV2(instantTime);
        translated = CheckpointUtils.convertToCheckpointV2ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.BLOCK);
        Assertions.assertEquals((Object)"00000000000000", (Object)translated.getCheckpointKey());
    }

    @Test
    public void testConvertCheckpointWithUseTransitionTime() {
        String instantTime = "20231127010101";
        String completionTime = "20231127020102";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", instantTime, completionTime, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)this.activeTimeline.getInstantsAsStream()).thenReturn(Stream.of(instant));
        StreamerCheckpointV1 checkpoint = new StreamerCheckpointV1(completionTime);
        StreamerCheckpointV2 translatedCheckpoint = CheckpointUtils.convertToCheckpointV2ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.USE_TRANSITION_TIME);
        Assertions.assertEquals((Object)completionTime, (Object)translatedCheckpoint.getCheckpointKey());
    }

    @ParameterizedTest
    @CsvSource(value={"8, org.apache.hudi.utilities.sources.TestSource, true", "9, org.apache.hudi.utilities.sources.AnotherSource, true", "7, org.apache.hudi.utilities.sources.TestSource, false", "6, org.apache.hudi.utilities.sources.AnotherSource, false", "8, org.apache.hudi.utilities.sources.S3EventsHoodieIncrSource, false", "8, org.apache.hudi.utilities.sources.GcsEventsHoodieIncrSource, false", "8, org.apache.hudi.utilities.sources.MockS3EventsHoodieIncrSource, false", "8, org.apache.hudi.utilities.sources.MockGcsEventsHoodieIncrSource, false"})
    public void testTargetCheckpointV2(int version, String sourceClassName, boolean isV2Checkpoint) {
        Assertions.assertEquals((Object)isV2Checkpoint, (Object)(CheckpointUtils.buildCheckpointFromGeneralSource((String)sourceClassName, (int)version, (String)"ignored") instanceof StreamerCheckpointV2));
    }

    @Test
    public void testBuildCheckpointFromGeneralSource() {
        Checkpoint checkpoint1 = CheckpointUtils.buildCheckpointFromGeneralSource((String)GENERAL_SOURCE, (int)HoodieTableVersion.EIGHT.versionCode(), (String)CHECKPOINT_TO_RESUME);
        Assertions.assertInstanceOf(StreamerCheckpointV2.class, (Object)checkpoint1);
        Assertions.assertEquals((Object)CHECKPOINT_TO_RESUME, (Object)checkpoint1.getCheckpointKey());
        Checkpoint checkpoint2 = CheckpointUtils.buildCheckpointFromGeneralSource((String)GENERAL_SOURCE, (int)HoodieTableVersion.SEVEN.versionCode(), (String)CHECKPOINT_TO_RESUME);
        Assertions.assertInstanceOf(StreamerCheckpointV1.class, (Object)checkpoint2);
        Assertions.assertEquals((Object)CHECKPOINT_TO_RESUME, (Object)checkpoint2.getCheckpointKey());
    }

    @Test
    public void testBuildCheckpointFromConfigOverride() {
        Checkpoint checkpoint1 = CheckpointUtils.buildCheckpointFromConfigOverride((String)GENERAL_SOURCE, (int)HoodieTableVersion.EIGHT.versionCode(), (String)CHECKPOINT_TO_RESUME);
        Assertions.assertInstanceOf(UnresolvedStreamerCheckpointBasedOnCfg.class, (Object)checkpoint1);
        Assertions.assertEquals((Object)CHECKPOINT_TO_RESUME, (Object)checkpoint1.getCheckpointKey());
        Checkpoint checkpoint2 = CheckpointUtils.buildCheckpointFromConfigOverride((String)GENERAL_SOURCE, (int)HoodieTableVersion.SEVEN.versionCode(), (String)CHECKPOINT_TO_RESUME);
        Assertions.assertInstanceOf(StreamerCheckpointV1.class, (Object)checkpoint2);
        Assertions.assertEquals((Object)CHECKPOINT_TO_RESUME, (Object)checkpoint2.getCheckpointKey());
    }

    private /* synthetic */ void lambda$testConvertToCheckpointV2ForCommitTimeEmptyTimeline$3(Checkpoint checkpoint) throws Throwable {
        CheckpointUtils.convertToCheckpointV2ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.FAIL);
    }

    private /* synthetic */ void lambda$testConvertToCheckpointV1ThrowsExceptionForMissingRequestedTime$2(Checkpoint checkpoint) throws Throwable {
        CheckpointUtils.convertToCheckpointV1ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient);
    }

    private /* synthetic */ void lambda$testConvertToCheckpointV2ThrowsExceptionForMissingCompletionTime$1(Checkpoint checkpoint) throws Throwable {
        CheckpointUtils.convertToCheckpointV2ForCommitTime((Checkpoint)checkpoint, (HoodieTableMetaClient)this.metaClient, (TimelineUtils.HollowCommitHandling)TimelineUtils.HollowCommitHandling.BLOCK);
    }
}

