/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.checkpoint;

import org.apache.hudi.common.table.checkpoint.Checkpoint;
import org.apache.hudi.common.table.checkpoint.HoodieIncrSourceCheckpointValUtils;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV1;
import org.apache.hudi.common.table.checkpoint.StreamerCheckpointV2;
import org.apache.hudi.common.table.checkpoint.UnresolvedStreamerCheckpointBasedOnCfg;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHoodieIncrSourceCheckpointValUtils {
    @Test
    public void testResolveToV1V2CheckpointWithRequestTime() {
        String checkpoint = "20240301";
        UnresolvedStreamerCheckpointBasedOnCfg mockCheckpoint = (UnresolvedStreamerCheckpointBasedOnCfg)Mockito.mock(UnresolvedStreamerCheckpointBasedOnCfg.class);
        Mockito.when((Object)mockCheckpoint.getCheckpointKey()).thenReturn((Object)("resumeFromInstantRequestTime:" + checkpoint));
        Checkpoint result = HoodieIncrSourceCheckpointValUtils.resolveToActualCheckpointVersion((UnresolvedStreamerCheckpointBasedOnCfg)mockCheckpoint);
        Assertions.assertInstanceOf(StreamerCheckpointV1.class, (Object)result);
        Assertions.assertEquals((Object)checkpoint, (Object)result.getCheckpointKey());
    }

    @Test
    public void testResolveToV1V2CheckpointWithCompletionTime() {
        String checkpoint = "20240302";
        UnresolvedStreamerCheckpointBasedOnCfg mockCheckpoint = (UnresolvedStreamerCheckpointBasedOnCfg)Mockito.mock(UnresolvedStreamerCheckpointBasedOnCfg.class);
        Mockito.when((Object)mockCheckpoint.getCheckpointKey()).thenReturn((Object)("resumeFromInstantCompletionTime:" + checkpoint));
        Checkpoint result = HoodieIncrSourceCheckpointValUtils.resolveToActualCheckpointVersion((UnresolvedStreamerCheckpointBasedOnCfg)mockCheckpoint);
        Assertions.assertInstanceOf(StreamerCheckpointV2.class, (Object)result);
        Assertions.assertEquals((Object)checkpoint, (Object)result.getCheckpointKey());
    }

    @Test
    public void testResolveToV1V2CheckpointWithInvalidPrefix() {
        UnresolvedStreamerCheckpointBasedOnCfg mockCheckpoint = (UnresolvedStreamerCheckpointBasedOnCfg)Mockito.mock(UnresolvedStreamerCheckpointBasedOnCfg.class);
        Mockito.when((Object)mockCheckpoint.getCheckpointKey()).thenReturn((Object)"invalidPrefix:20240303");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIncrSourceCheckpointValUtils.resolveToActualCheckpointVersion((UnresolvedStreamerCheckpointBasedOnCfg)mockCheckpoint));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Illegal checkpoint key override"));
    }

    @Test
    public void testResolveToV1V2CheckpointWithMalformedInput() {
        UnresolvedStreamerCheckpointBasedOnCfg mockCheckpoint = (UnresolvedStreamerCheckpointBasedOnCfg)Mockito.mock(UnresolvedStreamerCheckpointBasedOnCfg.class);
        Mockito.when((Object)mockCheckpoint.getCheckpointKey()).thenReturn((Object)"malformedInput");
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIncrSourceCheckpointValUtils.resolveToActualCheckpointVersion((UnresolvedStreamerCheckpointBasedOnCfg)mockCheckpoint));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Illegal checkpoint key override"));
    }
}

